/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.pathquery;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.Model;
import org.intermine.objectstore.query.ConstraintOp;
import org.intermine.pathquery.LogicExpression;
import org.intermine.pathquery.OrderDirection;
import org.intermine.pathquery.OrderElement;
import org.intermine.pathquery.OuterJoinStatus;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathConstraintAttribute;
import org.intermine.pathquery.PathConstraintBag;
import org.intermine.pathquery.PathConstraintIds;
import org.intermine.pathquery.PathConstraintLookup;
import org.intermine.pathquery.PathConstraintLoop;
import org.intermine.pathquery.PathConstraintMultiValue;
import org.intermine.pathquery.PathConstraintNull;
import org.intermine.pathquery.PathConstraintSubclass;
import org.intermine.pathquery.PathException;
import org.intermine.pathquery.PathQueryBinding;
import org.intermine.util.DynamicUtil;
import org.intermine.util.TypeUtil;

public class PathQuery
implements Cloneable {
    protected static final Pattern SPACE_SPLITTER = Pattern.compile(" ", 16);
    public static final int USERPROFILE_VERSION = 2;
    private final Model model;
    private List<String> view = new ArrayList<String>();
    private List<OrderElement> orderBy = new ArrayList<OrderElement>();
    private Map<PathConstraint, String> constraints = new LinkedHashMap<PathConstraint, String>();
    private LogicExpression logic = null;
    private Map<String, OuterJoinStatus> outerJoinStatus = new LinkedHashMap<String, OuterJoinStatus>();
    private Map<String, String> descriptions = new LinkedHashMap<String, String>();
    private String description = null;
    private String title = null;
    private boolean isVerified = false;
    private String rootClass = null;
    private Map<String, String> subclasses = null;
    private Map<String, String> outerJoinGroups = null;
    private Map<String, Set<String>> constraintGroups = null;
    private Set<String> existingLoops = null;
    private boolean doNotVerifyLogic = false;
    private static final Pattern PATH_MATCHER = Pattern.compile("([a-zA-Z0-9]+\\.)*[a-zA-Z0-9]+");

    public PathQuery(Model model) {
        this.model = model;
    }

    public PathQuery(PathQuery o) {
        this.model = o.model;
        this.view = new ArrayList<String>(o.view);
        this.orderBy = new ArrayList<OrderElement>(o.orderBy);
        this.constraints = new LinkedHashMap<PathConstraint, String>(o.constraints);
        if (o.logic != null) {
            this.logic = new LogicExpression(o.logic.toString());
        }
        this.outerJoinStatus = new LinkedHashMap<String, OuterJoinStatus>(o.outerJoinStatus);
        this.descriptions = new LinkedHashMap<String, String>(o.descriptions);
        this.description = o.description;
    }

    public Model getModel() {
        return this.model;
    }

    public synchronized void addView(String viewPath) {
        this.deVerify();
        PathQuery.checkPathFormat(viewPath);
        this.view.add(viewPath);
    }

    public synchronized void removeView(String viewPath) {
        this.deVerify();
        PathQuery.checkPathFormat(viewPath);
        if (!this.view.contains(viewPath)) {
            throw new NoSuchElementException("Path \"" + viewPath + "\" is not in the view list: \"" + this.view + "\" - cannot remove it");
        }
        this.view.removeAll(Collections.singleton(viewPath));
    }

    public synchronized void clearView() {
        this.deVerify();
        this.view.clear();
    }

    public synchronized void addViews(Collection<String> viewPaths) {
        this.deVerify();
        try {
            for (String viewPath : viewPaths) {
                PathQuery.checkPathFormat(viewPath);
            }
            for (String viewPath : viewPaths) {
                this.addView(viewPath);
            }
        }
        catch (NullPointerException e) {
            NullPointerException e2 = new NullPointerException("While adding list to view: " + viewPaths);
            e2.initCause(e);
            throw e2;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("While adding list to view: " + viewPaths, e);
        }
    }

    public synchronized void addViews(String ... viewPaths) {
        this.deVerify();
        try {
            for (String viewPath : viewPaths) {
                PathQuery.checkPathFormat(viewPath);
            }
            for (String viewPath : viewPaths) {
                this.addView(viewPath);
            }
        }
        catch (NullPointerException e) {
            NullPointerException e2 = new NullPointerException("While adding array to view: " + viewPaths);
            e2.initCause(e);
            throw e2;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("While adding array to view: " + viewPaths, e);
        }
    }

    public synchronized void addViewSpaceSeparated(String viewPaths) {
        this.deVerify();
        try {
            String[] viewPathArray;
            for (String viewPath : viewPathArray = SPACE_SPLITTER.split(viewPaths.trim())) {
                if ("".equals(viewPath)) continue;
                PathQuery.checkPathFormat(viewPath);
            }
            for (String viewPath : viewPathArray) {
                if ("".equals(viewPath)) continue;
                this.addView(viewPath);
            }
        }
        catch (NullPointerException e) {
            NullPointerException e2 = new NullPointerException("While adding space-separated list to view: \"" + viewPaths + "\"");
            e2.initCause(e);
            throw e2;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("While adding space-separated list to view: \"" + viewPaths + "\"", e);
        }
    }

    public synchronized List<String> getView() {
        return Collections.unmodifiableList(new ArrayList<String>(this.view));
    }

    public synchronized void addOrderBy(String orderPath, OrderDirection direction) {
        this.deVerify();
        this.addOrderBy(new OrderElement(orderPath, direction));
    }

    public synchronized void removeOrderBy(String orderPath) {
        this.deVerify();
        PathQuery.checkPathFormat(orderPath);
        boolean found = false;
        int i = 0;
        while (i < this.orderBy.size()) {
            if (orderPath.equals(this.orderBy.get(i).getOrderPath())) {
                this.orderBy.remove(i);
                found = true;
                continue;
            }
            ++i;
        }
        if (!found) {
            throw new NoSuchElementException("Path \"" + orderPath + "\" is not in the order by " + "list: \"" + this.orderBy + "\" - cannot remove it");
        }
    }

    public synchronized void clearOrderBy() {
        this.deVerify();
        this.orderBy.clear();
    }

    public synchronized void addOrderBy(OrderElement orderElement) {
        this.deVerify();
        if (orderElement == null) {
            throw new NullPointerException("Cannot add a null OrderElement to the order by list");
        }
        this.orderBy.add(orderElement);
    }

    public synchronized void addOrderBys(Collection<OrderElement> orderElements) {
        this.deVerify();
        if (orderElements == null) {
            throw new NullPointerException("Cannot add null collection of OrderElements to order by list");
        }
        for (OrderElement orderElement : orderElements) {
            if (orderElement != null) continue;
            throw new NullPointerException("Cannot add null OrderElement (from collection \"" + orderElements + "\") to the order by list");
        }
        for (OrderElement orderElement : orderElements) {
            this.addOrderBy(orderElement);
        }
    }

    public synchronized void addOrderBys(OrderElement ... orderElements) {
        this.deVerify();
        if (orderElements == null) {
            throw new NullPointerException("Cannot add null array of OrderElements to order by list");
        }
        for (OrderElement orderElement : orderElements) {
            if (orderElement != null) continue;
            throw new NullPointerException("Cannot add null OrderElement (from array \"" + orderElements + "\") to the order by list");
        }
        for (OrderElement orderElement : orderElements) {
            this.addOrderBy(orderElement);
        }
    }

    public synchronized void addOrderBySpaceSeparated(String orderString) {
        this.deVerify();
        try {
            String[] orderPathArray = SPACE_SPLITTER.split(orderString.trim());
            if (orderPathArray.length % 2 != 0) {
                throw new IllegalArgumentException("Order String must contain alternating paths and directions, so must have an even number of space-separated elements.");
            }
            ArrayList<OrderElement> toAdd = new ArrayList<OrderElement>();
            for (int i = 0; i < orderPathArray.length - 1; i += 2) {
                if ("asc".equals(orderPathArray[i + 1].toLowerCase())) {
                    toAdd.add(new OrderElement(orderPathArray[i], OrderDirection.ASC));
                    continue;
                }
                if ("desc".equals(orderPathArray[i + 1].toLowerCase())) {
                    toAdd.add(new OrderElement(orderPathArray[i], OrderDirection.DESC));
                    continue;
                }
                throw new IllegalArgumentException("Order direction \"" + orderPathArray[i + 1] + "\" must be either \"asc\" or \"desc\"");
            }
            this.addOrderBys(toAdd);
        }
        catch (NullPointerException e) {
            NullPointerException e2 = new NullPointerException("While adding space-separated list to order by: \"" + orderString + "\"");
            e2.initCause(e);
            throw e2;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("While adding space-separated list to order by: \"" + orderString + "\"");
        }
    }

    public synchronized List<OrderElement> getOrderBy() {
        return Collections.unmodifiableList(new ArrayList<OrderElement>(this.orderBy));
    }

    public synchronized String addConstraint(PathConstraint constraint) {
        this.deVerify();
        if (constraint == null) {
            throw new NullPointerException("Cannot add a null constraint to this query");
        }
        if (this.constraints.containsKey(constraint)) {
            return this.constraints.get(constraint);
        }
        if (constraint instanceof PathConstraintSubclass) {
            this.constraints.put(constraint, null);
            return null;
        }
        HashSet<String> usedCodes = new HashSet<String>(this.constraints.values());
        char charCode = 'A';
        String code = "A";
        while (usedCodes.contains(code)) {
            charCode = (char)(charCode + 1);
            code = "" + charCode;
        }
        this.logic = this.logic == null ? new LogicExpression(code) : new LogicExpression("(" + this.logic.toString() + ") AND " + code);
        this.constraints.put(constraint, code);
        return code;
    }

    public synchronized void addConstraint(PathConstraint constraint, String code) {
        this.deVerify();
        if (constraint == null) {
            throw new NullPointerException("Cannot add a null constraint to this query");
        }
        if (constraint instanceof PathConstraintSubclass) {
            throw new IllegalArgumentException("Cannot associate a code with a subclass constraint. Use the addConstraint(PathConstraint) method instead");
        }
        if (code == null) {
            throw new NullPointerException("Cannot use a null code for a constraint in this query");
        }
        if (code.length() != 1 || code.charAt(0) > 'Z' || code.charAt(0) < 'A') {
            throw new IllegalArgumentException("The constraint code must be a single plain latin uppercase character");
        }
        if (this.constraints.containsKey(constraint)) {
            if (code.equals(this.constraints.get(constraint))) {
                return;
            }
            throw new IllegalStateException("Given constraint is already associated with code " + this.constraints.get(constraint) + " - cannot associate with code " + code + "for query " + this.toString());
        }
        HashSet<String> usedCodes = new HashSet<String>(this.constraints.values());
        if (usedCodes.contains(code)) {
            throw new IllegalStateException("Given code " + code + " from constraint " + constraint + " conflicts with an existing constraint for query " + this.toString());
        }
        this.logic = this.logic == null ? new LogicExpression(code) : new LogicExpression("(" + this.logic.toString() + ") AND " + code);
        this.constraints.put(constraint, code);
    }

    public synchronized void removeConstraint(PathConstraint constraint) {
        this.deVerify();
        if (constraint == null) {
            throw new NullPointerException("Cannot remove null constraint from this query");
        }
        if (this.constraints.containsKey(constraint)) {
            String code = this.constraints.remove(constraint);
            if (code != null) {
                if (this.logic.getVariableNames().size() > 1) {
                    this.logic.removeVariable(code);
                } else {
                    this.logic = null;
                }
            }
        } else {
            throw new NoSuchElementException("Constraint to remove is not present in query");
        }
    }

    public synchronized void replaceConstraint(PathConstraint old, PathConstraint replacement) {
        this.deVerify();
        if (old == null) {
            throw new NullPointerException("Cannot replace a null constraint");
        }
        if (replacement == null) {
            throw new NullPointerException("Cannot replace a constraint with null");
        }
        if (!this.constraints.containsKey(old)) {
            throw new NoSuchElementException("Old constraint is not in the query");
        }
        if (this.constraints.containsKey(replacement)) {
            throw new IllegalStateException("Replacement constraint is already in the query");
        }
        String code = this.constraints.get(old);
        if (replacement instanceof PathConstraintSubclass != (code == null)) {
            throw new IllegalArgumentException("Cannot replace a " + old.getClass().getSimpleName() + " with a " + replacement.getClass().getSimpleName());
        }
        LinkedHashMap<PathConstraint, String> temp = new LinkedHashMap<PathConstraint, String>(this.constraints);
        this.constraints.clear();
        for (Map.Entry entry : temp.entrySet()) {
            if (old.equals(entry.getKey())) {
                this.constraints.put(replacement, code);
                continue;
            }
            this.constraints.put((PathConstraint)entry.getKey(), (String)entry.getValue());
        }
    }

    public synchronized void clearConstraints() {
        this.deVerify();
        this.constraints.clear();
        this.logic = null;
    }

    public synchronized void addConstraints(Collection<PathConstraint> constraintList) {
        this.deVerify();
        if (constraintList == null) {
            throw new NullPointerException("Cannot add null collection of PathConstraints to this query");
        }
        for (PathConstraint constraint : constraintList) {
            if (constraint != null) continue;
            throw new NullPointerException("Cannot add null PathConstraint (from collection \"" + constraintList + "\" to this query");
        }
        for (PathConstraint constraint : constraintList) {
            this.addConstraint(constraint);
        }
    }

    public synchronized void addConstraints(PathConstraint ... constraintList) {
        this.deVerify();
        if (constraintList == null) {
            throw new NullPointerException("Cannot add null array of PathConstraints to this query");
        }
        for (PathConstraint constraint : constraintList) {
            if (constraint != null) continue;
            throw new NullPointerException("Cannot add null PathConstraint (from array \"" + constraintList + "\" to this query");
        }
        for (PathConstraint constraint : constraintList) {
            this.addConstraint(constraint);
        }
    }

    public synchronized Map<PathConstraint, String> getConstraints() {
        LinkedHashMap<PathConstraint, String> retval = new LinkedHashMap<PathConstraint, String>(this.constraints);
        return retval;
    }

    public synchronized PathConstraint getConstraintForCode(String code) {
        for (Map.Entry<PathConstraint, String> entry : this.constraints.entrySet()) {
            if (!code.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        throw new NoSuchElementException("No constraint is associated with code " + code + ", valid codes are " + this.constraints.values());
    }

    public synchronized List<PathConstraint> getConstraintsForPath(String path) {
        ArrayList<PathConstraint> retval = new ArrayList<PathConstraint>();
        for (PathConstraint con : this.constraints.keySet()) {
            if (!con.getPath().equals(path)) continue;
            retval.add(con);
        }
        return Collections.unmodifiableList(retval);
    }

    public synchronized Set<String> getConstraintCodes() {
        HashSet<String> codes = new HashSet<String>();
        for (String code : this.constraints.values()) {
            if (code == null) continue;
            codes.add(code);
        }
        return codes;
    }

    public synchronized String getConstraintLogic() {
        return this.logic == null ? "" : this.logic.toString();
    }

    public synchronized void setConstraintLogic(String logic) {
        this.deVerify();
        if (this.constraints.isEmpty()) {
            this.logic = null;
        } else {
            this.logic = new LogicExpression(logic);
            for (String code : this.constraints.values()) {
                if (this.logic.getVariableNames().contains(code)) continue;
                this.logic = new LogicExpression("(" + this.logic.toString() + ") and " + code);
            }
            this.logic.removeAllVariablesExcept(this.constraints.values());
        }
    }

    public synchronized OuterJoinStatus getOuterJoinStatus(String path) {
        PathQuery.checkPathFormat(path);
        return this.outerJoinStatus.get(path);
    }

    public synchronized void setOuterJoinStatus(String path, OuterJoinStatus status) {
        this.deVerify();
        PathQuery.checkPathFormat(path);
        if (status == null) {
            this.outerJoinStatus.remove(path);
        } else {
            this.outerJoinStatus.put(path, status);
        }
    }

    public synchronized Map<String, OuterJoinStatus> getOuterJoinStatus() {
        return Collections.unmodifiableMap(new LinkedHashMap<String, OuterJoinStatus>(this.outerJoinStatus));
    }

    public synchronized void clearOuterJoinStatus() {
        this.deVerify();
        this.outerJoinStatus.clear();
    }

    public synchronized Map<String, Boolean> getOuterMap() {
        HashMap<String, Boolean> retval = new HashMap<String, Boolean>();
        for (Map.Entry<String, OuterJoinStatus> stat : this.outerJoinStatus.entrySet()) {
            if (!OuterJoinStatus.OUTER.equals((Object)stat.getValue())) continue;
            retval.put(stat.getKey(), Boolean.TRUE);
        }
        return retval;
    }

    public synchronized String getDescription(String path) {
        PathQuery.checkPathFormat(path);
        return this.descriptions.get(path);
    }

    public synchronized void setDescription(String path, String description) {
        this.deVerify();
        PathQuery.checkPathFormat(path);
        if (description == null) {
            this.descriptions.remove(path);
        } else {
            this.descriptions.put(path, description);
        }
    }

    public synchronized Map<String, String> getDescriptions() {
        return Collections.unmodifiableMap(new LinkedHashMap<String, String>(this.descriptions));
    }

    public synchronized void clearDescriptions() {
        this.deVerify();
        this.descriptions.clear();
    }

    public synchronized String getGeneratedPathDescription(String path) {
        PathQuery.checkPathFormat(path);
        String retval = this.descriptions.get(path);
        if (retval == null) {
            int lastDot = path.lastIndexOf(46);
            if (lastDot == -1) {
                return path;
            }
            return this.getGeneratedPathDescription(path.substring(0, lastDot)) + " > " + path.substring(lastDot + 1);
        }
        return retval;
    }

    public List<String> getColumnHeaders() {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (String viewString : this.getView()) {
            columnNames.add(this.getGeneratedPathDescription(viewString));
        }
        return columnNames;
    }

    public synchronized void setDescription(String description) {
        this.deVerify();
        this.description = description;
    }

    public synchronized String getDescription() {
        return this.description;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.deVerify();
        this.title = title;
    }

    public synchronized void removeAllUnder(String path) {
        PathQuery.checkPathFormat(path);
        this.deVerify();
        for (String v : this.getView()) {
            if (!PathQuery.isPathUnder(path, v)) continue;
            this.removeView(v);
        }
        for (OrderElement order : this.getOrderBy()) {
            if (!PathQuery.isPathUnder(path, order.getOrderPath())) continue;
            this.removeOrderBy(order.getOrderPath());
        }
        for (PathConstraint con : this.getConstraints().keySet()) {
            if (!PathQuery.isPathUnder(path, con.getPath())) continue;
            this.removeConstraint(con);
        }
        for (String join : this.getOuterJoinStatus().keySet()) {
            if (!PathQuery.isPathUnder(path, join)) continue;
            this.setOuterJoinStatus(join, null);
        }
        for (String desc : this.getDescriptions().keySet()) {
            if (!PathQuery.isPathUnder(desc, path) || this.isAnyViewWithPathUnder(desc)) continue;
            this.setDescription(desc, null);
        }
    }

    private static boolean isPathUnder(String parent, String child) {
        if (parent.equals(child)) {
            return true;
        }
        return child.startsWith(parent + ".");
    }

    private boolean isAnyViewWithPathUnder(String parent) {
        for (String v : this.getView()) {
            if (!parent.equals(v) && !v.startsWith(parent + ".")) continue;
            return true;
        }
        return false;
    }

    public synchronized void removeAllIrrelevant() throws PathException {
        Path path;
        this.deVerify();
        ArrayList<String> problems = new ArrayList<String>();
        this.buildSubclassMap(problems);
        this.rootClass = null;
        LinkedHashSet<String> validMainPaths = new LinkedHashSet<String>();
        this.validateView(problems, validMainPaths);
        this.validateConstraints(problems, validMainPaths);
        if (!problems.isEmpty()) {
            throw new PathException(((Object)problems).toString(), null);
        }
        for (OrderElement order : this.getOrderBy()) {
            path = new Path(this.model, order.getOrderPath(), this.subclasses);
            if (path.endIsAttribute()) {
                path = path.getPrefix();
            }
            if (validMainPaths.contains(path.getNoConstraintsString())) continue;
            this.removeOrderBy(order.getOrderPath());
        }
        for (String join : this.getOuterJoinStatus().keySet()) {
            path = new Path(this.model, join, this.subclasses);
            if (path.endIsAttribute()) {
                path = path.getPrefix();
            }
            if (validMainPaths.contains(path.getNoConstraintsString())) continue;
            this.setOuterJoinStatus(join, null);
        }
        for (String desc : this.getDescriptions().keySet()) {
            path = new Path(this.model, desc, this.subclasses);
            if (path.endIsAttribute()) {
                path = path.getPrefix();
            }
            if (validMainPaths.contains(path.getNoConstraintsString())) continue;
            this.setDescription(desc, null);
        }
    }

    public synchronized List<String> fixUpForJoinStyle() throws PathException {
        this.deVerify();
        ArrayList<String> problems = new ArrayList<String>();
        this.buildSubclassMap(problems);
        this.rootClass = null;
        LinkedHashSet<String> validMainPaths = new LinkedHashSet<String>();
        this.validateView(problems, validMainPaths);
        this.validateConstraints(problems, validMainPaths);
        this.validateOuterJoins(problems, validMainPaths);
        this.calculateConstraintGroups(problems);
        if (!problems.isEmpty()) {
            throw new PathException(((Object)problems).toString(), null);
        }
        ArrayList<String> messages = new ArrayList<String>();
        for (OrderElement order : this.getOrderBy()) {
            String orderString = order.getOrderPath();
            boolean outer = false;
            while (orderString.contains(".")) {
                if (OuterJoinStatus.OUTER.equals((Object)this.outerJoinStatus.get(orderString))) {
                    outer = true;
                    break;
                }
                orderString = orderString.substring(0, orderString.lastIndexOf(46));
            }
            if (!outer) continue;
            this.removeOrderBy(order.getOrderPath());
            messages.add("Removed path " + order.getOrderPath() + " from ORDER BY because of " + "outer joins");
        }
        if (this.logic != null) {
            ArrayList<Set<String>> groups = new ArrayList<Set<String>>(this.constraintGroups.values());
            try {
                this.logic.split(groups);
            }
            catch (IllegalArgumentException e) {
                String oldLogic = this.logic.toString();
                this.logic = this.logic.validateForGroups(groups);
                messages.add("Changed constraint logic from " + oldLogic + " to " + this.logic.toString() + " because of outer joins");
            }
        }
        return messages;
    }

    public synchronized List<String> removeSubclassAndFixUp(String path) throws PathException {
        PathQuery.checkPathFormat(path);
        List<String> problems = this.verifyQuery();
        if (!problems.isEmpty()) {
            throw new PathException("Query does not verify: " + problems, null);
        }
        this.deVerify();
        ArrayList<String> messages = new ArrayList<String>();
        PathConstraint toRemove = null;
        for (PathConstraint con : this.getConstraints().keySet()) {
            if (!(con instanceof PathConstraintSubclass) || !con.getPath().equals(path)) continue;
            toRemove = con;
            break;
        }
        if (toRemove == null) {
            return messages;
        }
        this.removeConstraint(toRemove);
        this.buildSubclassMap(problems);
        for (String viewPath : this.getView()) {
            try {
                Path viewPathObj = new Path(this.model, viewPath, this.subclasses);
            }
            catch (PathException e) {
                this.removeView(viewPath);
                messages.add("Removed path " + viewPath + " from view, because you removed the " + "subclass constraint that it depended on.");
            }
        }
        for (PathConstraint con : this.getConstraints().keySet()) {
            try {
                Path constraintPath = new Path(this.model, con.getPath(), this.subclasses);
                if (!(con instanceof PathConstraintLoop)) continue;
                try {
                    Path loopPath = new Path(this.model, ((PathConstraintLoop)con).getLoopPath(), this.subclasses);
                }
                catch (PathException e) {
                    this.removeConstraint(con);
                    messages.add("Removed constraint " + con + " because you removed the " + "subclass constraint it depended on.");
                }
            }
            catch (PathException e) {
                this.removeConstraint(con);
                messages.add("Removed constraint " + con + " because you removed the " + "subclass constraint it depended on.");
            }
        }
        for (OrderElement order : this.getOrderBy()) {
            try {
                Path orderPath = new Path(this.model, order.getOrderPath(), this.subclasses);
            }
            catch (PathException e) {
                this.removeOrderBy(order.getOrderPath());
                messages.add("Removed path " + order.getOrderPath() + " from ORDER BY, because you " + "removed the subclass constraint it depended on.");
            }
        }
        for (String join : this.getOuterJoinStatus().keySet()) {
            try {
                Path joinPath = new Path(this.model, join, this.subclasses);
            }
            catch (PathException e) {
                this.setOuterJoinStatus(join, null);
            }
        }
        for (String desc : this.getDescriptions().keySet()) {
            try {
                Path descPath = new Path(this.model, desc, this.subclasses);
            }
            catch (PathException e) {
                this.setDescription(desc, null);
                messages.add("Removed description on path " + desc + ", because you removed the " + "subclass constraint it depended on.");
            }
        }
        this.removeAllIrrelevant();
        return messages;
    }

    public PathQuery clone() {
        try {
            PathQuery retval = (PathQuery)super.clone();
            retval.view = new ArrayList<String>(retval.view);
            retval.orderBy = new ArrayList<OrderElement>(retval.orderBy);
            retval.constraints = new LinkedHashMap<PathConstraint, String>(retval.constraints);
            if (retval.logic != null) {
                retval.logic = new LogicExpression(retval.logic.toString());
            }
            retval.outerJoinStatus = new LinkedHashMap<String, OuterJoinStatus>(retval.outerJoinStatus);
            retval.descriptions = new LinkedHashMap<String, String>(retval.descriptions);
            return retval;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Should never happen", e);
        }
    }

    public synchronized Path makePath(String path) throws PathException {
        HashMap<String, String> lSubclasses = new HashMap<String, String>();
        for (PathConstraint subclass : this.constraints.keySet()) {
            if (!(subclass instanceof PathConstraintSubclass)) continue;
            lSubclasses.put(subclass.getPath(), ((PathConstraintSubclass)subclass).getType());
        }
        return new Path(this.model, path, lSubclasses);
    }

    private synchronized void deVerify() {
        this.isVerified = false;
    }

    public boolean isValid() {
        return this.verifyQuery().isEmpty();
    }

    public synchronized List<String> verifyQuery() {
        Path path;
        ArrayList<String> problems = new ArrayList<String>();
        if (this.isVerified) {
            return problems;
        }
        this.buildSubclassMap(problems);
        this.rootClass = null;
        LinkedHashSet<String> validMainPaths = new LinkedHashSet<String>();
        this.validateView(problems, validMainPaths);
        this.validateConstraints(problems, validMainPaths);
        for (PathConstraint constraint : this.constraints.keySet()) {
            if (!(constraint instanceof PathConstraintSubclass)) continue;
            try {
                path = new Path(this.model, constraint.getPath(), this.subclasses);
                if (path.endIsAttribute()) {
                }
            }
            catch (PathException e) {}
            continue;
            if (validMainPaths.contains(constraint.getPath())) continue;
            problems.add("Subclass constraint on path " + constraint.getPath() + " is not relevant to the query");
        }
        this.validateOuterJoins(problems, validMainPaths);
        for (String descPath : this.descriptions.keySet()) {
            try {
                path = new Path(this.model, descPath, this.subclasses);
                if (path.endIsAttribute()) {
                    path = path.getPrefix();
                }
                if (validMainPaths.contains(path.getNoConstraintsString())) continue;
                problems.add("Description on path " + descPath + " is not relevant to the query");
            }
            catch (PathException e) {
                problems.add("Path " + descPath + " for description is not in the model");
            }
        }
        for (OrderElement orderPath : this.orderBy) {
            try {
                path = new Path(this.model, orderPath.getOrderPath(), this.subclasses);
                if (!path.endIsAttribute()) {
                    problems.add("Path " + orderPath.getOrderPath() + " in order by list must be " + "an attribute");
                    continue;
                }
                if (!validMainPaths.contains(path.getPrefix().toStringNoConstraints())) {
                    problems.add("Order by element for path " + orderPath.getOrderPath() + " is not relevant to the query");
                    continue;
                }
                if (this.rootClass.equals(this.outerJoinGroups.get(path.getPrefix().getNoConstraintsString()))) continue;
                problems.add("Order by element " + orderPath + " is not in the root outer join group");
            }
            catch (PathException e) {
                problems.add("Path " + orderPath.getOrderPath() + " in order by list is not in the model");
            }
        }
        this.calculateConstraintGroups(problems);
        if (this.logic != null && !this.doNotVerifyLogic) {
            try {
                this.logic.split(new ArrayList<Set<String>>(this.constraintGroups.values()));
            }
            catch (IllegalArgumentException e) {
                problems.add("Logic expression is not compatible with outer join status: " + e.getMessage());
            }
        }
        if (problems.isEmpty()) {
            this.isVerified = true;
        }
        return problems;
    }

    private void calculateConstraintGroups(List<String> problems) {
        this.doNotVerifyLogic = false;
        this.constraintGroups = new LinkedHashMap<String, Set<String>>();
        for (Map.Entry<PathConstraint, String> constraintEntry : this.constraints.entrySet()) {
            if (constraintEntry.getValue() != null) {
                try {
                    Path path = new Path(this.model, constraintEntry.getKey().getPath(), this.subclasses);
                    if (path.getStartClassDescriptor().getUnqualifiedName().equals(this.rootClass)) {
                        String groupPath;
                        if (path.endIsAttribute()) {
                            path = path.getPrefix();
                        }
                        if ((groupPath = this.outerJoinGroups.get(path.getNoConstraintsString())) != null) {
                            Set<String> group = this.constraintGroups.get(groupPath);
                            if (group == null) {
                                group = new HashSet<String>();
                                this.constraintGroups.put(groupPath, group);
                            }
                            group.add(constraintEntry.getValue());
                        }
                    } else {
                        this.doNotVerifyLogic = true;
                    }
                }
                catch (PathException e) {
                    this.doNotVerifyLogic = true;
                }
            }
            if (!(constraintEntry.getKey() instanceof PathConstraintLoop)) continue;
            PathConstraintLoop loop = (PathConstraintLoop)constraintEntry.getKey();
            String aGroup = this.outerJoinGroups.get(loop.getPath());
            String bGroup = this.outerJoinGroups.get(loop.getLoopPath());
            if (aGroup == null || bGroup == null || aGroup.equals(bGroup)) continue;
            problems.add("Loop constraint " + loop + " crosses an outer join");
        }
        for (String group : new HashSet<String>(this.outerJoinGroups.values())) {
            if (this.constraintGroups.containsKey(group)) continue;
            this.constraintGroups.put(group, new HashSet());
        }
    }

    private void validateOuterJoins(List<String> problems, Set<String> validMainPaths) {
        Path path;
        for (String joinPath : this.outerJoinStatus.keySet()) {
            block9: {
                try {
                    path = new Path(this.model, joinPath, this.subclasses);
                    if (path.endIsAttribute()) {
                        problems.add("Outer join status on path " + joinPath + " must not be on an attribute");
                        continue;
                    }
                    if (path.isRootPath()) {
                        problems.add("Outer join status cannot be set on root path " + joinPath);
                    }
                    break block9;
                }
                catch (PathException e) {
                    problems.add("Path " + joinPath + " for outer join status is not in the model");
                }
                continue;
            }
            if (validMainPaths.contains(joinPath)) continue;
            problems.add("Outer join status path " + joinPath + " is not relevant to the " + "query");
        }
        this.outerJoinGroups = new LinkedHashMap<String, String>();
        for (String validPath : validMainPaths) {
            try {
                path = new Path(this.model, validPath, this.subclasses);
                while (this.isInner(path)) {
                    path = path.getPrefix();
                }
                this.outerJoinGroups.put(validPath, path.getNoConstraintsString());
            }
            catch (PathException e) {
                throw new Error(e);
            }
        }
    }

    private void validateConstraints(List<String> problems, Set<String> validMainPaths) {
        this.existingLoops = new HashSet<String>();
        for (PathConstraint constraint : this.constraints.keySet()) {
            try {
                Class<?> valueType;
                Path path = new Path(this.model, constraint.getPath(), this.subclasses);
                if (this.rootClass == null) {
                    this.rootClass = path.getStartClassDescriptor().getUnqualifiedName();
                } else {
                    String newRootClass = path.getStartClassDescriptor().getUnqualifiedName();
                    if (!this.rootClass.equals(newRootClass)) {
                        problems.add("Multiple root classes in query: " + this.rootClass + " and " + newRootClass);
                        continue;
                    }
                }
                if (path.endIsAttribute()) {
                    PathQuery.addValidPaths(validMainPaths, path.getPrefix());
                } else {
                    PathQuery.addValidPaths(validMainPaths, path);
                }
                if (constraint instanceof PathConstraintAttribute) {
                    if (!path.endIsAttribute()) {
                        problems.add("Constraint " + constraint + " must be on an attribute");
                        continue;
                    }
                    valueType = path.getEndType();
                    try {
                        TypeUtil.stringToObject(valueType, (String)((PathConstraintAttribute)constraint).getValue());
                    }
                    catch (Exception e) {
                        problems.add("Value in constraint " + constraint + " is not in correct " + "format for type of " + DynamicUtil.getFriendlyName(valueType));
                    }
                    continue;
                }
                if (constraint instanceof PathConstraintNull) {
                    if (path.isRootPath()) {
                        problems.add("Constraint " + constraint + " cannot be applied to the root path");
                        continue;
                    }
                    if (!constraint.getOp().equals(ConstraintOp.IS_NULL) || path.endIsAttribute()) continue;
                    problems.add("Constraint " + constraint + " is invalid - can only set IS NULL on an attribute");
                    continue;
                }
                if (constraint instanceof PathConstraintBag) {
                    if (!path.endIsAttribute()) continue;
                    problems.add("Constraint " + constraint + " must not be on an attribute");
                    continue;
                }
                if (constraint instanceof PathConstraintIds) {
                    if (!path.endIsAttribute()) continue;
                    problems.add("Constraint " + constraint + " must not be on an attribute");
                    continue;
                }
                if (constraint instanceof PathConstraintMultiValue) {
                    if (!path.endIsAttribute()) {
                        problems.add("Constraint " + constraint + " must be on an attribute");
                        continue;
                    }
                    valueType = path.getEndType();
                    for (String value : ((PathConstraintMultiValue)constraint).getValues()) {
                        try {
                            TypeUtil.stringToObject(valueType, (String)value);
                        }
                        catch (Exception e) {
                            problems.add("Value (" + value + ") in list in constraint " + constraint + " is not in correct format for type of " + DynamicUtil.getFriendlyName(valueType));
                        }
                    }
                    continue;
                }
                if (constraint instanceof PathConstraintLoop) {
                    if (path.endIsAttribute()) {
                        problems.add("Constraint " + constraint + " must not be on an attribute");
                        continue;
                    }
                    String loopPathString = ((PathConstraintLoop)constraint).getLoopPath();
                    try {
                        Class<?> bClass;
                        Class<?> aClass;
                        Path loopPath = new Path(this.model, loopPathString, this.subclasses);
                        if (loopPath.endIsAttribute()) {
                            problems.add("Loop path in constraint " + constraint + " must not be an attribute");
                            continue;
                        }
                        String newRootClass = loopPath.getStartClassDescriptor().getUnqualifiedName();
                        if (!this.rootClass.equals(newRootClass)) {
                            problems.add("Multiple root classes in query: " + this.rootClass + " and " + newRootClass);
                            continue;
                        }
                        PathQuery.addValidPaths(validMainPaths, loopPath);
                        if (constraint.getPath().equals(loopPathString)) {
                            problems.add("Path " + constraint.getPath() + " may not be looped back on itself");
                            continue;
                        }
                        if (this.model.isGeneratedClassesAvailable() && !(aClass = path.getEndType()).isAssignableFrom(bClass = loopPath.getEndType()) && !bClass.isAssignableFrom(aClass)) {
                            problems.add("Loop constraint " + constraint + " must loop between similar types");
                            continue;
                        }
                        String loop = ((PathConstraintLoop)constraint).getDescriptiveString();
                        if (this.existingLoops.contains(loop)) {
                            problems.add("Cannot have two loop constraints between paths " + constraint.getPath() + " and " + loopPathString);
                            continue;
                        }
                        this.existingLoops.add(loop);
                    }
                    catch (PathException e) {
                        problems.add("Path " + loopPathString + " in loop constraint from " + constraint.getPath() + " is not in the model");
                    }
                    continue;
                }
                if (constraint instanceof PathConstraintLookup) {
                    if (!path.endIsAttribute()) continue;
                    problems.add("Constraint " + constraint + " must not be on an attribute");
                    continue;
                }
                if (constraint instanceof PathConstraintSubclass) continue;
                problems.add("Unrecognised constraint type " + constraint.getClass().getName());
            }
            catch (PathException e) {
                if (constraint instanceof PathConstraintSubclass) continue;
                problems.add("Path " + constraint.getPath() + " in constraint is not in the model");
            }
        }
    }

    private Set<String> validateView(List<String> problems, Set<String> validMainPaths) {
        for (String viewPath : this.view) {
            try {
                Path path = new Path(this.model, viewPath, this.subclasses);
                if (!path.endIsAttribute()) {
                    problems.add("Path " + viewPath + " in view list must be an attribute");
                    continue;
                }
                if (this.rootClass == null) {
                    this.rootClass = path.getStartClassDescriptor().getUnqualifiedName();
                } else {
                    String newRootClass = path.getStartClassDescriptor().getUnqualifiedName();
                    if (!this.rootClass.equals(newRootClass)) {
                        problems.add("Multiple root classes in query: " + this.rootClass + " and " + newRootClass);
                        continue;
                    }
                }
                PathQuery.addValidPaths(validMainPaths, path.getPrefix());
            }
            catch (PathException e) {
                problems.add("Path " + viewPath + " in view list is not in the model");
            }
        }
        return validMainPaths;
    }

    private void buildSubclassMap(List<String> problems) {
        ArrayList<PathConstraintSubclass> subclassConstraints = new ArrayList<PathConstraintSubclass>();
        for (PathConstraint constraint : this.constraints.keySet()) {
            if (!(constraint instanceof PathConstraintSubclass)) continue;
            subclassConstraints.add((PathConstraintSubclass)constraint);
        }
        PathConstraintSubclass[] subclassConstraintArray = subclassConstraints.toArray(new PathConstraintSubclass[0]);
        Arrays.sort(subclassConstraintArray, new Comparator<PathConstraintSubclass>(){

            @Override
            public int compare(PathConstraintSubclass o1, PathConstraintSubclass o2) {
                return o1.getPath().length() - o2.getPath().length();
            }
        });
        this.subclasses = new LinkedHashMap<String, String>();
        for (PathConstraintSubclass subclass : subclassConstraintArray) {
            if (this.subclasses.containsKey(subclass.getPath())) {
                problems.add("Cannot have multiple subclass constraints on path " + subclass.getPath());
                continue;
            }
            Path subclassPath = null;
            try {
                subclassPath = new Path(this.model, subclass.getPath(), this.subclasses);
            }
            catch (PathException e) {
                problems.add("Path " + subclass.getPath() + " (from subclass constraint) is not in" + " the model");
                continue;
            }
            if (subclassPath.isRootPath()) {
                problems.add("Root node " + subclass.getPath() + " may not have a subclass constraint");
                continue;
            }
            if (subclassPath.endIsAttribute()) {
                problems.add("Path " + subclass.getPath() + " (from subclass constraint) must not " + "be an attribute");
                continue;
            }
            ClassDescriptor subclassDesc = this.model.getClassDescriptorByName(subclass.getType());
            if (this.model.isGeneratedClassesAvailable()) {
                Class subclassType;
                Class parentClassType = subclassPath.getEndClassDescriptor().getType();
                Class clazz = subclassType = subclassDesc == null ? null : subclassDesc.getType();
                if (subclassType == null) {
                    problems.add("Subclass " + subclass.getType() + " (for path " + subclass.getPath() + ") is not in the model");
                    continue;
                }
                if (!parentClassType.isAssignableFrom(subclassType)) {
                    problems.add("Subclass constraint on path " + subclass.getPath() + " (type " + DynamicUtil.getFriendlyName((Class)parentClassType) + ") restricting to type " + DynamicUtil.getFriendlyName((Class)subclassType) + " is not possible, as it is " + "not a subclass");
                    continue;
                }
            }
            this.subclasses.put(subclass.getPath(), subclass.getType());
        }
    }

    public synchronized String getRootClass() throws PathException {
        List<String> problems = this.verifyQuery();
        if (problems.isEmpty()) {
            return this.rootClass;
        }
        throw new PathException("Query does not verify: " + problems, null);
    }

    public synchronized Map<String, String> getSubclasses() throws PathException {
        List<String> problems = this.verifyQuery();
        if (problems.isEmpty()) {
            return Collections.unmodifiableMap(new LinkedHashMap<String, String>(this.subclasses));
        }
        throw new PathException("Query does not verify: " + problems, null);
    }

    public synchronized Set<String> getBagNames() {
        HashSet<String> bagNames = new HashSet<String>();
        for (PathConstraint constraint : this.constraints.keySet()) {
            if (!(constraint instanceof PathConstraintBag)) continue;
            bagNames.add(((PathConstraintBag)constraint).getBag());
        }
        return bagNames;
    }

    public synchronized Map<String, String> getOuterJoinGroups() throws PathException {
        List<String> problems = this.verifyQuery();
        if (problems.isEmpty()) {
            return Collections.unmodifiableMap(new LinkedHashMap<String, String>(this.outerJoinGroups));
        }
        throw new PathException("Query does not verify: " + problems, null);
    }

    public synchronized Set<String> getExistingLoops() throws PathException {
        List<String> problems = this.verifyQuery();
        if (problems.isEmpty()) {
            return Collections.unmodifiableSet(new HashSet<String>(this.existingLoops));
        }
        throw new PathException("Query does not verify: " + problems, null);
    }

    public String getOuterJoinGroup(String stringPath) throws PathException {
        if (stringPath == null) {
            throw new NullPointerException("stringPath is null");
        }
        Map<String, String> groups = this.getOuterJoinGroups();
        Path path = this.makePath(stringPath);
        if (path.endIsAttribute()) {
            path = path.getPrefix();
        }
        if (!groups.containsKey(path.getNoConstraintsString())) {
            throw new NoSuchElementException("Path " + stringPath + " is not in the query");
        }
        return groups.get(path.getNoConstraintsString());
    }

    public boolean isPathCompletelyInner(String stringPath) throws PathException {
        String root = this.getRootClass();
        return root.equals(this.getOuterJoinGroup(stringPath));
    }

    public synchronized Set<String> getCandidateLoops(String stringPath) throws PathException {
        if (stringPath == null) {
            throw new NullPointerException("stringPath is null");
        }
        Path path = this.makePath(stringPath);
        if (path.endIsAttribute()) {
            throw new IllegalArgumentException("stringPath \"" + stringPath + "\" is an attribute, not a class");
        }
        String lRootClass = this.getRootClass();
        String rootOfStringPath = path.getStartClassDescriptor().getUnqualifiedName();
        if (lRootClass != null && !lRootClass.equals(rootOfStringPath)) {
            throw new NoSuchElementException("Path " + stringPath + " is not in the query");
        }
        if (lRootClass == null) {
            this.outerJoinGroups.put(rootOfStringPath, rootOfStringPath);
        }
        HashMap<String, String> groups = new HashMap<String, String>(this.getOuterJoinGroups());
        Path groupPath = path;
        HashSet<String> toAdd = new HashSet<String>();
        while (!groups.containsKey(groupPath.getNoConstraintsString())) {
            toAdd.add(groupPath.toStringNoConstraints());
            groupPath = groupPath.getPrefix();
        }
        String group = (String)groups.get(groupPath.getNoConstraintsString());
        for (String toAddElement : toAdd) {
            groups.put(toAddElement, group);
        }
        Class<?> type = path.getEndType();
        Set<String> lExistingLoops = this.getExistingLoops();
        HashSet<String> retval = new HashSet<String>();
        for (Map.Entry entry : groups.entrySet()) {
            String desc;
            Path entryPath;
            if (((String)entry.getKey()).equals(stringPath) || !type.isAssignableFrom((entryPath = this.makePath((String)entry.getKey())).getEndType()) && !entryPath.getEndType().isAssignableFrom(type) || !group.equals(entry.getValue()) || lExistingLoops.contains(desc = stringPath.compareTo((String)entry.getKey()) > 0 ? (String)entry.getKey() + " -- " + stringPath : stringPath + " -- " + (String)entry.getKey())) continue;
            retval.add((String)entry.getKey());
        }
        return retval;
    }

    public synchronized Map<String, Set<String>> getConstraintGroups() throws PathException {
        List<String> problems = this.verifyQuery();
        if (problems.isEmpty()) {
            return Collections.unmodifiableMap(new LinkedHashMap<String, Set<String>>(this.constraintGroups));
        }
        throw new PathException("Query does not verify: " + problems, null);
    }

    public synchronized List<String> getGroupedConstraintLogic() throws PathException {
        if (this.logic == null) {
            return Collections.emptyList();
        }
        Map<String, Set<String>> groups = this.getConstraintGroups();
        List<LogicExpression> grouped = this.logic.split(new ArrayList<Set<String>>(groups.values()));
        ArrayList<String> retval = new ArrayList<String>();
        for (LogicExpression group : grouped) {
            if (group == null) continue;
            retval.add(group.toString());
        }
        return retval;
    }

    public synchronized LogicExpression getConstraintLogicForGroup(String group) throws PathException {
        List<String> problems = this.verifyQuery();
        if (problems.isEmpty()) {
            if (this.logic == null) {
                return null;
            }
            Set<String> codes = this.constraintGroups.get(group);
            if (codes == null) {
                throw new IllegalArgumentException("Outer join group " + group + " does not seem to be in this query. Valid inputs are " + this.constraintGroups.keySet());
            }
            if (codes.isEmpty()) {
                return null;
            }
            return this.logic.getSection(codes);
        }
        throw new PathException("Query does not verify: " + problems, null);
    }

    private static void addValidPaths(Set<String> validMainPaths, Path path) {
        Path pathToAdd = path;
        while (!pathToAdd.isRootPath()) {
            validMainPaths.add(pathToAdd.toStringNoConstraints());
            pathToAdd = pathToAdd.getPrefix();
        }
        validMainPaths.add(pathToAdd.toStringNoConstraints());
    }

    private boolean isInner(Path path) {
        if (path.isRootPath()) {
            return false;
        }
        if (path.endIsAttribute()) {
            throw new IllegalArgumentException("Cannot call isInner() with a path that is an attribute");
        }
        OuterJoinStatus status = this.getOuterJoinStatus(path.getNoConstraintsString());
        if (OuterJoinStatus.INNER.equals((Object)status)) {
            return true;
        }
        return !OuterJoinStatus.OUTER.equals((Object)status);
    }

    public static void checkPathFormat(String path) {
        if (path == null) {
            throw new NullPointerException("Path must not be null");
        }
        if (!PATH_MATCHER.matcher(path).matches()) {
            throw new IllegalArgumentException("Path \"" + path + "\" does not match regular " + "expression \"([a-zA-Z0-9]+\\.)*[a-zA-Z0-9]+\"");
        }
    }

    public PathQuery getQueryToExecute() {
        return this;
    }

    protected synchronized void sortConstraints(List<PathConstraint> listToSortBy) {
        ConstraintComparator comparator = new ConstraintComparator(listToSortBy);
        TreeMap<PathConstraint, String> orderedConstraints = new TreeMap<PathConstraint, String>(comparator);
        orderedConstraints.putAll(this.constraints);
        this.constraints = new LinkedHashMap<PathConstraint, String>(orderedConstraints);
    }

    public synchronized String toString() {
        return "PathQuery( view: " + this.view + ", orderBy: " + this.orderBy + ", constraints: " + this.constraints + ", logic: " + this.logic + ", outerJoinStatus: " + this.outerJoinStatus + ", descriptions: " + this.descriptions + ", description: " + this.description + ")";
    }

    public synchronized String toXml() {
        return this.toXml(2);
    }

    public synchronized String toXml(int version) {
        StringWriter sw = new StringWriter();
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        try {
            XMLStreamWriter writer = factory.createXMLStreamWriter(sw);
            PathQueryBinding.marshal(this, "query", this.model.getName(), writer, version);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        return sw.toString();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof PathQuery) {
            return ((PathQuery)other).toXml().equals(this.toXml());
        }
        return false;
    }

    public int hashCode() {
        return this.toXml().hashCode();
    }

    private class ConstraintComparator
    implements Comparator<PathConstraint> {
        private final List<PathConstraint> listToSortBy;

        public ConstraintComparator(List<PathConstraint> listToSortBy) {
            this.listToSortBy = listToSortBy;
        }

        @Override
        public int compare(PathConstraint c1, PathConstraint c2) {
            if (!this.listToSortBy.contains(c1) && !this.listToSortBy.contains(c2)) {
                return -1;
            }
            return this.listToSortBy.indexOf(c1) < this.listToSortBy.indexOf(c2) ? -1 : 1;
        }
    }
}

