/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.pathquery;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.intermine.objectstore.query.ConstraintOp;
import org.intermine.pathquery.PathConstraint;

public class PathConstraintMultiValue
extends PathConstraint {
    public static final Set<ConstraintOp> VALID_OPS = new HashSet<ConstraintOp>(Arrays.asList(ConstraintOp.ONE_OF, ConstraintOp.NONE_OF));
    private Collection<String> values;

    public PathConstraintMultiValue(String path, ConstraintOp op, Collection<String> values) {
        super(path, op);
        if (op == null) {
            throw new NullPointerException("Cannot construct a PathConstraintMultiValue with a null op");
        }
        if (!VALID_OPS.contains(op)) {
            throw new IllegalArgumentException("PathConstraints with multiple values must use an op in the list \"" + VALID_OPS + "\"");
        }
        if (values == null) {
            throw new NullPointerException("Cannot create a multivalue constrait with a null  collection of values.");
        }
        this.values = values;
    }

    public Collection<String> getValues() {
        return this.values;
    }

    public String toString() {
        return this.path + " " + this.op + " " + this.values;
    }
}

