/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.pathquery;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.intermine.objectstore.query.ConstraintOp;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathQuery;

public class PathConstraintLoop
extends PathConstraint {
    public static final Set<ConstraintOp> VALID_OPS = new HashSet<ConstraintOp>(Arrays.asList(ConstraintOp.EQUALS, ConstraintOp.NOT_EQUALS));
    private String loopPath;

    public PathConstraintLoop(String path, ConstraintOp op, String loopPath) {
        super(path, op);
        if (op == null) {
            throw new NullPointerException("Cannot construct a PathConstraintLoop with a null op");
        }
        if (!VALID_OPS.contains(op)) {
            throw new IllegalArgumentException("PathConstraints for loops must use an op in the list \"" + VALID_OPS + "\"");
        }
        if (loopPath == null) {
            throw new NullPointerException("Cannot create a loop constraint to a null path");
        }
        PathQuery.checkPathFormat(loopPath);
        this.loopPath = loopPath;
    }

    public String getLoopPath() {
        return this.loopPath;
    }

    public String getDescriptiveString() {
        return this.path.compareTo(this.loopPath) > 0 ? this.loopPath + " -- " + this.path : this.path + " -- " + this.loopPath;
    }

    public String toString() {
        return this.path + " " + this.op + " " + this.loopPath;
    }
}

