/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.pathquery;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.intermine.objectstore.query.ConstraintOp;
import org.intermine.pathquery.PathConstraint;

public class PathConstraintBag
extends PathConstraint {
    public static final Set<ConstraintOp> VALID_OPS = new HashSet<ConstraintOp>(Arrays.asList(ConstraintOp.IN, ConstraintOp.NOT_IN));
    private String bag;

    public PathConstraintBag(String path, ConstraintOp op, String bag) {
        super(path, op);
        if (op == null) {
            throw new NullPointerException("Cannot construct a PathConstraintBag with a null op");
        }
        if (!VALID_OPS.contains(op)) {
            throw new IllegalArgumentException("PathConstraints to bags must use an op in the list \"" + VALID_OPS + "\"");
        }
        if (bag == null) {
            throw new NullPointerException("Cannot create a constraint to a null bag");
        }
        this.bag = bag;
    }

    public String getBag() {
        return this.bag;
    }

    public String toString() {
        return this.path + " " + this.op + " " + this.bag;
    }
}

