/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.pathquery;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.intermine.objectstore.query.ConstraintOp;
import org.intermine.pathquery.PathConstraint;

public class PathConstraintAttribute
extends PathConstraint {
    public static final Set<ConstraintOp> VALID_OPS = new HashSet<ConstraintOp>(Arrays.asList(ConstraintOp.DOES_NOT_MATCH, ConstraintOp.EQUALS, ConstraintOp.GREATER_THAN, ConstraintOp.GREATER_THAN_EQUALS, ConstraintOp.LESS_THAN, ConstraintOp.LESS_THAN_EQUALS, ConstraintOp.MATCHES, ConstraintOp.NOT_EQUALS, ConstraintOp.CONTAINS, ConstraintOp.DOES_NOT_CONTAIN));
    private String value;

    public PathConstraintAttribute(String path, ConstraintOp op, String value) {
        super(path, op);
        if (op == null) {
            throw new NullPointerException("Cannot construct a PathConstraintAttribute with a null op");
        }
        if (!VALID_OPS.contains(op)) {
            throw new IllegalArgumentException("PathConstraints on attributes must use an op in the list \"" + VALID_OPS + "\"");
        }
        if (value == null) {
            throw new NullPointerException("Cannot create a constraint on a null value");
        }
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.path + " " + this.op + " " + this.value;
    }
}

