/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.pathquery;

import org.intermine.objectstore.query.ConstraintOp;
import org.intermine.pathquery.PathConstraintAttribute;
import org.intermine.pathquery.PathConstraintBag;
import org.intermine.pathquery.PathConstraintLookup;
import org.intermine.pathquery.PathConstraintLoop;
import org.intermine.pathquery.PathConstraintNull;
import org.intermine.pathquery.PathConstraintSubclass;
import org.intermine.pathquery.PathQuery;

public abstract class PathConstraint {
    protected String path;
    protected ConstraintOp op;

    protected PathConstraint(String path, ConstraintOp op) {
        PathQuery.checkPathFormat(path);
        this.path = path;
        this.op = op;
    }

    public String getPath() {
        return this.path;
    }

    public ConstraintOp getOp() {
        return this.op;
    }

    public static String getValue(PathConstraint con) {
        if (con instanceof PathConstraintAttribute) {
            return ((PathConstraintAttribute)con).getValue();
        }
        if (con instanceof PathConstraintBag) {
            return ((PathConstraintBag)con).getBag();
        }
        if (con instanceof PathConstraintLookup) {
            return ((PathConstraintLookup)con).getValue();
        }
        if (con instanceof PathConstraintSubclass) {
            return ((PathConstraintSubclass)con).getType();
        }
        if (con instanceof PathConstraintLoop) {
            return ((PathConstraintLoop)con).getLoopPath();
        }
        if (con instanceof PathConstraintNull) {
            return ((PathConstraintNull)con).getOp().toString();
        }
        return null;
    }

    public static String getExtraValue(PathConstraint con) {
        if (con instanceof PathConstraintLookup) {
            return ((PathConstraintLookup)con).getExtraValue();
        }
        return null;
    }

    public static String getType(PathConstraint con) {
        if (con instanceof PathConstraintSubclass) {
            return ((PathConstraintSubclass)con).getType();
        }
        return null;
    }
}

