/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.pathquery;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.intermine.metadata.AttributeDescriptor;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.CollectionDescriptor;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.metadata.Model;
import org.intermine.metadata.ReferenceDescriptor;
import org.intermine.pathquery.PathException;
import org.intermine.util.StringUtil;
import org.intermine.util.TypeUtil;
import org.intermine.util.Util;

public class Path {
    protected static final Logger LOG = Logger.getLogger(Path.class);
    private ClassDescriptor startCld;
    private List<String> elements;
    private FieldDescriptor endFld;
    private final Model model;
    private String path;
    private boolean containsCollections = false;
    private boolean containsReferences = false;
    private final Map<String, String> subClassConstraintPaths;
    private List<ClassDescriptor> elementClassDescriptors;
    private final List<Boolean> outers;

    public Path(Model model, String path) throws PathException {
        if (model == null) {
            throw new IllegalArgumentException("model argument is null");
        }
        this.model = model;
        if (path == null) {
            throw new IllegalArgumentException("path argument is null");
        }
        if (StringUtils.isBlank((String)path)) {
            throw new IllegalArgumentException("path argument is blank");
        }
        this.subClassConstraintPaths = new HashMap<String, String>();
        Pattern p = Pattern.compile("([^\\[\\]]+)\\[(.*)\\]");
        ArrayList<String> newPathBits = new ArrayList<String>();
        ArrayList<Boolean> newPathOuters = new ArrayList<Boolean>();
        StringTokenizer bits = new StringTokenizer(". " + path, ".:", true);
        boolean notFirst = false;
        while (bits.hasMoreTokens()) {
            String separator = bits.nextToken();
            String thisBit = bits.nextToken();
            if (notFirst) {
                newPathOuters.add(":".equals(separator));
            } else {
                thisBit = thisBit.substring(1);
                notFirst = true;
            }
            Matcher m = p.matcher(thisBit);
            if (m.matches()) {
                String pathBit = m.group(1);
                String className = m.group(2);
                newPathBits.add(pathBit);
                this.subClassConstraintPaths.put(StringUtil.join(newPathBits, (String)"."), className);
                continue;
            }
            newPathBits.add(thisBit);
        }
        this.path = StringUtil.join(newPathBits, (String)".");
        this.outers = newPathOuters;
        this.initialise();
    }

    public Path(Model model, String stringPath, Map<String, String> constraintMap) throws PathException {
        this.model = model;
        if (stringPath == null) {
            throw new IllegalArgumentException("path argument is null");
        }
        if (StringUtils.isBlank((String)stringPath)) {
            throw new IllegalArgumentException("path argument is blank");
        }
        this.path = stringPath;
        this.subClassConstraintPaths = new HashMap<String, String>(constraintMap);
        for (String constaintPath : this.subClassConstraintPaths.keySet()) {
            if (constaintPath.indexOf(58) == -1) continue;
            throw new IllegalArgumentException("illegal character (':') in constraint map");
        }
        if (this.path.indexOf("[") != -1) {
            throw new IllegalArgumentException("path: " + stringPath + " contains illegal character '['");
        }
        ArrayList<String> newPathBits = new ArrayList<String>();
        ArrayList<Boolean> newPathOuters = new ArrayList<Boolean>();
        StringTokenizer bits = new StringTokenizer(". " + this.path, ".:", true);
        boolean notFirst = false;
        while (bits.hasMoreTokens()) {
            String separator = bits.nextToken();
            String thisBit = bits.nextToken();
            if (notFirst) {
                newPathOuters.add(":".equals(separator));
            } else {
                thisBit = thisBit.substring(1);
                notFirst = true;
            }
            newPathBits.add(thisBit);
        }
        this.path = StringUtil.join(newPathBits, (String)".");
        this.outers = newPathOuters;
        this.initialise();
    }

    private void initialise() throws PathException {
        this.elements = new ArrayList<String>();
        this.elementClassDescriptors = new ArrayList<ClassDescriptor>();
        String[] parts = this.path.split("[.]");
        String clsName = parts[0];
        ClassDescriptor cld = null;
        if (!"".equals(clsName)) {
            cld = this.model.getClassDescriptorByName(this.model.getPackageName() + "." + clsName);
            if (cld == null) {
                throw new PathException("Unable to resolve path '" + this.path + "': class '" + clsName + "' not found in model '" + this.model.getName() + "'", this.path);
            }
            this.startCld = cld;
            this.elementClassDescriptors.add(cld);
        } else {
            LOG.error((Object)("First part is empty. Path is \"" + this.path + "\""));
        }
        StringBuffer currentPath = new StringBuffer(parts[0]);
        for (int i = 1; i < parts.length; ++i) {
            currentPath.append(".");
            String thisPart = parts[i];
            currentPath.append(thisPart);
            this.elements.add(thisPart);
            if ("".equals(clsName)) continue;
            FieldDescriptor fld = cld.getFieldDescriptorByName(thisPart);
            if (fld == null) {
                throw new PathException("Unable to resolve path '" + this.path + "': field '" + thisPart + "' of class '" + cld.getName() + "' not found in model '" + this.model.getName() + "'", this.path);
            }
            if (fld.isCollection()) {
                this.containsCollections = true;
            }
            if (fld.isReference()) {
                this.containsReferences = true;
            }
            if (i < parts.length - 1) {
                if (fld.isAttribute()) {
                    throw new PathException("Unable to resolve path '" + this.path + "': field '" + thisPart + "' of class '" + cld.getName() + "' is not a reference/collection field in the model '" + this.model.getName() + "'", this.path);
                }
            } else {
                this.endFld = fld;
            }
            if (fld.isAttribute()) continue;
            String constrainedClassName = this.subClassConstraintPaths.get(currentPath.toString());
            if (constrainedClassName == null) {
                cld = ((ReferenceDescriptor)fld).getReferencedClassDescriptor();
            } else {
                String qualifiedClassName = this.model.getPackageName() + "." + constrainedClassName;
                cld = this.model.getClassDescriptorByName(qualifiedClassName);
                if (cld == null) {
                    throw new PathException("Unable to resolve path '" + this.path + "': class '" + qualifiedClassName + "' not found in model '" + this.model.getName() + "'", this.path);
                }
            }
            this.elementClassDescriptors.add(cld);
        }
    }

    public List<Path> decomposePath() {
        ArrayList<Path> pathList = new ArrayList<Path>();
        pathList.add(this);
        Path currentPath = this;
        while (!currentPath.isRootPath()) {
            Path nextPath = currentPath.getPrefix();
            pathList.add(nextPath);
            currentPath = nextPath;
        }
        Collections.reverse(pathList);
        return pathList;
    }

    public boolean containsCollections() {
        return this.containsCollections;
    }

    public boolean containsReferences() {
        return this.containsReferences;
    }

    public boolean isOnlyAttribute() {
        return !this.containsReferences && !this.containsCollections;
    }

    public boolean endIsAttribute() {
        if (this.endFld == null) {
            return false;
        }
        return this.endFld.isAttribute();
    }

    public boolean endIsCollection() {
        if (this.endFld == null) {
            return false;
        }
        return this.endFld.isCollection();
    }

    public boolean endIsReference() {
        if (this.endFld == null) {
            return false;
        }
        return this.endFld.isReference();
    }

    public ClassDescriptor getStartClassDescriptor() {
        return this.startCld;
    }

    public FieldDescriptor getEndFieldDescriptor() {
        return this.endFld;
    }

    public ClassDescriptor getEndClassDescriptor() {
        if (this.getEndFieldDescriptor() == null) {
            return this.getStartClassDescriptor();
        }
        if (!this.getEndFieldDescriptor().isAttribute()) {
            if (this.getEndFieldDescriptor().isCollection()) {
                CollectionDescriptor collDesc = (CollectionDescriptor)this.getEndFieldDescriptor();
                return collDesc.getReferencedClassDescriptor();
            }
            if (this.getEndFieldDescriptor().isReference()) {
                ReferenceDescriptor refDesc = (ReferenceDescriptor)this.getEndFieldDescriptor();
                return refDesc.getReferencedClassDescriptor();
            }
        }
        return null;
    }

    public Path getPrefix() {
        int lastIndex;
        if (this.isRootPath()) {
            throw new RuntimeException("path (" + this + ") has only one element");
        }
        String pathString = this.toString();
        int lastDotIndex = pathString.lastIndexOf(46);
        if (lastDotIndex > (lastIndex = pathString.lastIndexOf(58))) {
            lastIndex = lastDotIndex;
        }
        try {
            return new Path(this.model, pathString.substring(0, lastIndex));
        }
        catch (PathException e) {
            throw new Error("There must be a bug", e);
        }
    }

    public Path append(String fieldName) throws PathException {
        return new Path(this.model, this.toString() + "." + fieldName);
    }

    public Class<?> getEndType() {
        Class retval = null;
        retval = this.endFld != null && this.endFld.isAttribute() ? Util.getClassFromString((String)((AttributeDescriptor)this.endFld).getType()) : this.getLastClassDescriptor().getType();
        return retval;
    }

    public ClassDescriptor getLastClassDescriptor() {
        List<ClassDescriptor> l = this.getElementClassDescriptors();
        return l.get(l.size() - 1);
    }

    public ClassDescriptor getSecondLastClassDescriptor() {
        List<ClassDescriptor> l = this.getElementClassDescriptors();
        return l.get(l.size() - 2);
    }

    public String getLastElement() {
        if (this.isRootPath()) {
            throw new RuntimeException("path (" + this + ") has only one element");
        }
        return this.elements.get(this.elements.size() - 1);
    }

    public boolean isRootPath() {
        return this.getElements().size() == 0;
    }

    public boolean equals(Object o) {
        if (o instanceof Path) {
            Path p = (Path)o;
            return p.startCld.equals((Object)this.startCld) && ((Object)p.elements).equals(this.elements);
        }
        return false;
    }

    public String toString() {
        String cdUnqualifiedName = this.getStartClassDescriptor().getUnqualifiedName();
        StringBuffer returnStringBuffer = new StringBuffer(cdUnqualifiedName);
        StringBuffer simplePath = new StringBuffer(cdUnqualifiedName);
        for (int i = 0; i < this.elements.size(); ++i) {
            returnStringBuffer.append(this.outers.get(i) != false ? ":" : ".");
            simplePath.append(".");
            String fieldName = this.elements.get(i);
            returnStringBuffer.append(fieldName);
            simplePath.append(fieldName);
            String constraintClassName = this.subClassConstraintPaths.get(simplePath.toString());
            if (constraintClassName == null) continue;
            if (this.startCld != null) {
                String referencedClassName;
                FieldDescriptor fieldDescriptor = this.elementClassDescriptors.get(i).getFieldDescriptorByName(fieldName);
                if (!fieldDescriptor.isReference() && !fieldDescriptor.isCollection() || TypeUtil.unqualifiedName((String)(referencedClassName = ((ReferenceDescriptor)fieldDescriptor).getReferencedClassName())).equals(constraintClassName)) continue;
                returnStringBuffer.append('[');
                returnStringBuffer.append(constraintClassName);
                returnStringBuffer.append(']');
                continue;
            }
            returnStringBuffer.append('[').append(constraintClassName).append(']');
        }
        return returnStringBuffer.toString();
    }

    public int hashCode() {
        return 0;
    }

    public List<String> getElements() {
        return this.elements;
    }

    public List<ClassDescriptor> getElementClassDescriptors() {
        return this.elementClassDescriptors;
    }

    public String toStringNoConstraints() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.elements.size(); ++i) {
            sb.append(this.outers.get(i) != false ? ":" : ".");
            sb.append(this.elements.get(i));
        }
        return this.getStartClassDescriptor().getUnqualifiedName() + sb.toString();
    }

    public String getNoConstraintsString() {
        return this.toStringNoConstraints();
    }

    public Map<String, String> getSubClassConstraintPaths() {
        return this.subClassConstraintPaths;
    }

    public Model getModel() {
        return this.model;
    }

    public boolean startContainsClass(String cls) {
        String rootClass = this.startCld.getSimpleName();
        return rootClass.equals(cls);
    }

    public List<Integer> getElementsContainingField(String cls, String field) {
        ArrayList<Integer> indexElementsContainingField = new ArrayList<Integer>();
        block0: for (int index = 0; index < this.elements.size(); ++index) {
            if (!this.elements.get(index).equals(field)) continue;
            ClassDescriptor cd = this.getElementClassDescriptors().get(index);
            if (cd.getSimpleName().equals(cls)) {
                indexElementsContainingField.add(index);
                continue;
            }
            for (String superClass : cd.getAllSuperclassNames()) {
                if (!superClass.equals(cls)) continue;
                indexElementsContainingField.add(index);
                continue block0;
            }
        }
        return indexElementsContainingField;
    }
}

