/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.pathquery;

import org.intermine.pathquery.OrderDirection;
import org.intermine.pathquery.PathQuery;

public class OrderElement {
    private String orderPath;
    private OrderDirection direction;

    public OrderElement(String orderPath, OrderDirection direction) {
        if (orderPath == null) {
            throw new NullPointerException("Cannot create an OrderElement with a null orderPath");
        }
        if (direction == null) {
            throw new NullPointerException("Cannot create an OrderElement with a null direction");
        }
        PathQuery.checkPathFormat(orderPath);
        this.orderPath = orderPath;
        this.direction = direction;
    }

    public String getOrderPath() {
        return this.orderPath;
    }

    public OrderDirection getDirection() {
        return this.direction;
    }

    public int hashCode() {
        return this.orderPath.hashCode() + this.direction.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof OrderElement) {
            OrderElement oe = (OrderElement)o;
            return this.orderPath.equals(oe.orderPath) && this.direction.equals((Object)oe.direction);
        }
        return false;
    }

    public String toString() {
        return this.orderPath + " " + (Object)((Object)this.direction);
    }
}

