/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.pathquery;

import org.intermine.metadata.AttributeDescriptor;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.metadata.Model;
import org.intermine.metadata.ReferenceDescriptor;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathException;
import org.intermine.util.TypeUtil;
import org.intermine.util.Util;

public class Node {
    private Node parent;
    private String fieldName;
    private String type;
    private boolean attribute = false;
    private boolean reference = false;
    private boolean collection = false;
    private boolean outer = false;
    private Path minimalPath = null;
    private FieldDescriptor fd = null;
    private Model model = null;

    public Node(String type) {
        this.type = type;
        this.parent = null;
        this.fieldName = null;
    }

    public Node(Node parent, String fieldName, boolean outer) {
        this.fieldName = fieldName;
        this.parent = parent;
        this.outer = outer;
    }

    public void setModel(Model model) {
        ClassDescriptor cld = model.getClassDescriptorByName(this.getParentType());
        if (cld == null) {
            throw new IllegalArgumentException("No class '" + this.getParentType() + "' found in model '" + model.getName() + "'.");
        }
        this.fd = cld.getFieldDescriptorByName(this.fieldName);
        if (this.fd == null) {
            throw new IllegalArgumentException("Class '" + cld.getName() + "' does not have field '" + this.fieldName + "'.");
        }
        this.type = TypeUtil.unqualifiedName((String)(this.fd.isAttribute() ? ((AttributeDescriptor)this.fd).getType() : ((ReferenceDescriptor)this.fd).getReferencedClassDescriptor().getName()));
        this.attribute = this.fd.isAttribute();
        this.reference = this.fd.isReference();
        this.collection = this.fd.isCollection();
        this.model = model;
    }

    public String getParentType() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getType();
    }

    public Path getMinimalPath() {
        if (this.minimalPath == null) {
            String minimalPathString = this.getParentType() + "." + this.fd.getName();
            try {
                this.minimalPath = new Path(this.model, minimalPathString);
            }
            catch (PathException e) {
                throw new IllegalStateException(minimalPathString + " is not a valid path", e);
            }
        }
        return this.minimalPath;
    }

    public FieldDescriptor getFieldDescriptor() {
        return this.fd;
    }

    public Node getParent() {
        return this.parent;
    }

    public String getPathString() {
        return this.parent == null ? this.type : this.getPrefix() + (this.outer ? ":" : ".") + this.fieldName;
    }

    public String getOuterJoinGroup() {
        return Node.getOuterJoinGroup(this.getPathString());
    }

    public static String getOuterJoinGroup(String path) {
        int lastIndexOf = path.lastIndexOf(":");
        if (lastIndexOf == -1) {
            int nextIndex = path.indexOf(".");
            if (nextIndex == -1) {
                return path;
            }
            return path.substring(0, nextIndex);
        }
        int nextDot = path.indexOf(".", lastIndexOf + 1);
        if (nextDot == -1) {
            return path;
        }
        return path.substring(0, nextDot);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getPrefix() {
        return this.parent == null ? "" : this.parent.getPathString();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getFriendlyName() {
        if (this.fieldName == null) {
            return this.type;
        }
        return this.fieldName;
    }

    public boolean isAttribute() {
        return this.attribute;
    }

    public boolean isReference() {
        return this.reference;
    }

    public boolean isCollection() {
        return this.collection;
    }

    public int getIndentation() {
        return this.parent == null ? 0 : this.parent.getIndentation() + 1;
    }

    public boolean isOuterJoin() {
        return this.outer;
    }

    public void setOuterJoin(boolean outer) {
        this.outer = outer;
    }

    public String toString() {
        return this.getPathString() + ":" + this.type;
    }

    public boolean equals(Object o) {
        return o instanceof Node && Util.equals((Object)this.type, (Object)((Node)o).type) && Util.equals((Object)this.parent, (Object)((Node)o).parent) && Util.equals((Object)this.fieldName, (Object)((Node)o).fieldName);
    }

    public int hashCode() {
        return (this.type == null ? 0 : 3 * this.type.hashCode()) + (this.parent == null ? 0 : 5 * this.parent.hashCode()) + (this.fieldName == null ? 0 : 7 * this.fieldName.hashCode());
    }
}

