/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.pathquery;

import antlr.DumpASTVisitor;
import antlr.RecognitionException;
import antlr.TokenStreamException;
import antlr.collections.AST;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.intermine.pathquery.LogicLexer;
import org.intermine.pathquery.LogicParser;

public class LogicExpression {
    private Node root;

    public LogicExpression(String expression) {
        this.root = this.parse(expression);
    }

    private Node parse(String expression) {
        AST ast = null;
        try {
            LogicLexer lexer = new LogicLexer(new StringReader(expression));
            LogicParser parser = new LogicParser(lexer);
            parser.expr();
            ast = parser.getAST();
            Node rootNode = "or".equals(ast.getText().toLowerCase()) ? new Or(ast) : ("and".equals(ast.getText().toLowerCase()) ? new And(ast) : new Variable(ast.getText()));
            return rootNode;
        }
        catch (RecognitionException e) {
            new DumpASTVisitor().visit(ast);
            IllegalArgumentException e2 = new IllegalArgumentException(e.getMessage() + " while parsing " + expression);
            e2.initCause(e);
            throw e2;
        }
        catch (TokenStreamException e) {
            new DumpASTVisitor().visit(ast);
            IllegalArgumentException e2 = new IllegalArgumentException(e.getMessage() + " while parsing " + expression);
            e2.initCause(e);
            throw e2;
        }
        catch (IllegalArgumentException e) {
            new DumpASTVisitor().visit(ast);
            throw e;
        }
    }

    public String toString() {
        return this.root.toString();
    }

    public Node getRootNode() {
        return this.root;
    }

    public void removeVariable(String name) {
        if (this.root instanceof Operator) {
            this.removeVariable(name, (Operator)this.root);
        } else if (this.root instanceof Variable && ((Variable)this.root).getName().equals(name)) {
            throw new IllegalArgumentException("Removing root node");
        }
        String logic = this.toString();
        this.root = this.parse(logic);
    }

    private void removeVariable(String name, Operator node) {
        for (Node child : new ArrayList<Node>(node.getChildren())) {
            if (child instanceof Operator) {
                this.removeVariable(name, (Operator)child);
                continue;
            }
            if (!(child instanceof Variable) || !((Variable)child).getName().equals(name)) continue;
            node.removeChild(child);
        }
    }

    public void removeAllVariablesExcept(Collection<String> variables) {
        if (this.root instanceof Operator) {
            this.removeAllVariablesExcept(variables, (Operator)this.root);
        } else if (this.root instanceof Variable && !variables.contains(((Variable)this.root).getName())) {
            throw new IllegalArgumentException("Removing root node");
        }
        String logic = this.toString();
        this.root = this.parse(logic);
    }

    private void removeAllVariablesExcept(Collection<String> variables, Operator node) {
        for (Node child : new ArrayList<Node>(node.getChildren())) {
            if (child instanceof Operator) {
                this.removeAllVariablesExcept(variables, (Operator)child);
                continue;
            }
            if (!(child instanceof Variable) || variables.contains(((Variable)child).getName())) continue;
            node.removeChild(child);
        }
    }

    public Set<String> getVariableNames() {
        HashSet<String> variables = new HashSet<String>();
        this.getVariableNames(variables, this.root);
        return variables;
    }

    private void getVariableNames(Set<String> variables, Node node) {
        if (node instanceof Operator) {
            for (Node child : ((Operator)node).getChildren()) {
                this.getVariableNames(variables, child);
            }
        } else {
            variables.add(((Variable)node).getName());
        }
    }

    public List<LogicExpression> split(List<? extends Collection<String>> variables) {
        HashSet<String> presentVariables = new HashSet<String>();
        for (Collection<String> collection : variables) {
            for (String var : collection) {
                if (presentVariables.contains(var)) {
                    throw new IllegalArgumentException("There is an overlap in variables");
                }
                presentVariables.add(var);
            }
        }
        if (!((Object)presentVariables).equals(this.getVariableNames())) {
            throw new IllegalArgumentException("Variables in argument (" + presentVariables + ") do not match variables in expression (" + this.getVariableNames() + ")");
        }
        if (this.root instanceof Variable) {
            return Collections.singletonList(this);
        }
        if (this.root instanceof Or) {
            if (variables.size() == 1) {
                return Collections.singletonList(this);
            }
            throw new IllegalArgumentException("Cannot split OR constraint " + this.toString());
        }
        And and = (And)this.root;
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < variables.size(); ++i) {
            arrayList.add(new ArrayList());
        }
        for (Node node : and.getChildren()) {
            HashSet<String> hashSet = new HashSet<String>();
            this.getVariableNames(hashSet, node);
            int bucketNo = -1;
            for (int i = 0; i < variables.size(); ++i) {
                Collection<String> bucketVariables = variables.get(i);
                if (!bucketVariables.containsAll(hashSet)) continue;
                ((List)arrayList.get(i)).add(node.toString());
                bucketNo = i;
                break;
            }
            if (bucketNo != -1) continue;
            throw new IllegalArgumentException("Cannot split node " + node.toString());
        }
        ArrayList<LogicExpression> retval = new ArrayList<LogicExpression>();
        for (List list : arrayList) {
            if (list.isEmpty()) {
                retval.add(null);
                continue;
            }
            StringBuffer newExpression = new StringBuffer();
            boolean needComma = false;
            for (String part : list) {
                if (needComma) {
                    newExpression.append(" and ");
                }
                needComma = true;
                newExpression.append("(" + part + ")");
            }
            retval.add(new LogicExpression(newExpression.toString()));
        }
        return retval;
    }

    public LogicExpression getSection(Collection<String> variables) {
        if (variables.isEmpty()) {
            return null;
        }
        if (!this.getVariableNames().containsAll(variables)) {
            throw new IllegalArgumentException("Unrecognised variables in request");
        }
        if (this.root instanceof Variable) {
            return this;
        }
        if (this.root instanceof Or) {
            if (variables.containsAll(this.getVariableNames())) {
                return this;
            }
            throw new IllegalArgumentException("Expression " + this.toString() + " cannot be split");
        }
        And and = (And)this.root;
        StringBuffer retval = new StringBuffer();
        boolean needComma = false;
        for (Node node : and.getChildren()) {
            HashSet<String> hasVariables = new HashSet<String>();
            this.getVariableNames(hasVariables, node);
            boolean containsAll = true;
            boolean containsNone = true;
            for (String var : hasVariables) {
                if (variables.contains(var)) {
                    containsNone = false;
                    continue;
                }
                containsAll = false;
            }
            if (!containsNone && !containsAll) {
                throw new IllegalArgumentException("Expression " + node + " cannot be split");
            }
            if (!containsAll) continue;
            if (needComma) {
                retval.append(" and ");
            }
            needComma = true;
            retval.append("(" + node.toString() + ")");
        }
        return new LogicExpression(retval.toString());
    }

    public LogicExpression validateForGroups(List<? extends Collection<String>> variables) {
        try {
            this.split(variables);
            return this;
        }
        catch (IllegalArgumentException e) {
            HashSet<String> presentVariables = new HashSet<String>();
            for (Collection<String> collection : variables) {
                for (String string : collection) {
                    if (presentVariables.contains(string)) {
                        throw new IllegalArgumentException("There is an overlap in variables");
                    }
                    presentVariables.add(string);
                }
            }
            if (!((Object)presentVariables).equals(this.getVariableNames())) {
                throw new IllegalArgumentException("Variables in argument (" + presentVariables + ") do not match variables in expression (" + this.getVariableNames() + ")");
            }
            StringBuffer retval = new StringBuffer();
            boolean bl = false;
            for (Collection collection : variables) {
                LogicExpression copy = new LogicExpression(this.toString());
                try {
                    boolean bl2;
                    copy.removeAllVariablesExcept(collection);
                    if (bl2) {
                        retval.append(" and ");
                    }
                    bl2 = true;
                    retval.append("(" + copy + ")");
                }
                catch (IllegalArgumentException e2) {}
            }
            return new LogicExpression(retval.toString());
        }
    }

    public boolean equals(Object o) {
        if (o instanceof LogicExpression) {
            return this.toString().equals(o.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public final class Variable
    extends Node {
        private String name;

        private Variable(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }
    }

    public final class Or
    extends Operator {
        private Or(AST ast) {
            super(ast);
        }

        @Override
        protected String getOperator() {
            return "or";
        }

        @Override
        protected void addChild(Node child) {
            if (child instanceof Or) {
                for (Node subChild : ((Or)child).getChildren()) {
                    this.addChild(subChild);
                }
            } else {
                super.addChild(child);
            }
        }
    }

    public final class And
    extends Operator {
        private And(AST ast) {
            super(ast);
        }

        @Override
        protected String getOperator() {
            return "and";
        }

        @Override
        protected void addChild(Node child) {
            if (child instanceof And) {
                for (Node subChild : ((And)child).getChildren()) {
                    this.addChild(subChild);
                }
            } else {
                super.addChild(child);
            }
        }
    }

    public abstract class Operator
    extends Node {
        private Set<Node> children;

        private Operator(AST ast) {
            this.children = new LinkedHashSet<Node>();
            if (ast != null) {
                for (AST child = ast.getFirstChild(); child != null; child = child.getNextSibling()) {
                    Node childNode = null;
                    childNode = "or".equals(child.getText().toLowerCase()) ? new Or(child) : ("and".equals(child.getText().toLowerCase()) ? new And(child) : new Variable(child.getText()));
                    this.addChild(childNode);
                }
            }
        }

        protected abstract String getOperator();

        public String toString() {
            StringBuffer expr = new StringBuffer();
            boolean needComma = false;
            for (Node child : this.getChildren()) {
                String subexpr = child.toString();
                if ("".equals(subexpr)) continue;
                if (child instanceof Or && this instanceof And) {
                    subexpr = "(" + subexpr + ")";
                } else if (child instanceof And && this instanceof Or) {
                    subexpr = "(" + subexpr + ")";
                }
                if (needComma) {
                    expr.append(" " + this.getOperator() + " ");
                }
                needComma = true;
                expr.append(subexpr);
            }
            return expr.toString();
        }

        public Set<Node> getChildren() {
            return Collections.unmodifiableSet(this.children);
        }

        private void removeChild(Node child) {
            this.children.remove(child);
        }

        protected void addChild(Node child) {
            this.children.add(child);
        }
    }

    public abstract class Node {
    }
}

