/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.pathquery;

import java.util.Collection;
import org.intermine.objectstore.query.ConstraintOp;
import org.intermine.pathquery.PathConstraintAttribute;
import org.intermine.pathquery.PathConstraintBag;
import org.intermine.pathquery.PathConstraintIds;
import org.intermine.pathquery.PathConstraintLookup;
import org.intermine.pathquery.PathConstraintLoop;
import org.intermine.pathquery.PathConstraintMultiValue;
import org.intermine.pathquery.PathConstraintNull;
import org.intermine.pathquery.PathConstraintSubclass;

public final class Constraints {
    private Constraints() {
    }

    public static PathConstraintAttribute eq(String path, String value) {
        return new PathConstraintAttribute(path, ConstraintOp.EQUALS, value);
    }

    public static PathConstraintAttribute neq(String path, String value) {
        return new PathConstraintAttribute(path, ConstraintOp.NOT_EQUALS, value);
    }

    public static PathConstraintAttribute like(String path, String value) {
        return new PathConstraintAttribute(path, ConstraintOp.MATCHES, value);
    }

    public static PathConstraintAttribute notLike(String path, String value) {
        return new PathConstraintAttribute(path, ConstraintOp.DOES_NOT_MATCH, value);
    }

    public static PathConstraintAttribute lessThan(String path, String value) {
        return new PathConstraintAttribute(path, ConstraintOp.LESS_THAN, value);
    }

    public static PathConstraintAttribute lessThanEqualTo(String path, String value) {
        return new PathConstraintAttribute(path, ConstraintOp.LESS_THAN_EQUALS, value);
    }

    public static PathConstraintAttribute greaterThan(String path, String value) {
        return new PathConstraintAttribute(path, ConstraintOp.GREATER_THAN, value);
    }

    public static PathConstraintAttribute greaterThanEqualTo(String path, String value) {
        return new PathConstraintAttribute(path, ConstraintOp.GREATER_THAN_EQUALS, value);
    }

    public static PathConstraintLookup lookup(String path, String value, String extraValue) {
        return new PathConstraintLookup(path, value, extraValue);
    }

    public static PathConstraintBag in(String path, String bag) {
        return new PathConstraintBag(path, ConstraintOp.IN, bag);
    }

    public static PathConstraintBag notIn(String path, String bag) {
        return new PathConstraintBag(path, ConstraintOp.NOT_IN, bag);
    }

    public static PathConstraintIds inIds(String path, Collection<Integer> ids) {
        return new PathConstraintIds(path, ConstraintOp.IN, ids);
    }

    public static PathConstraintIds notInIds(String path, Collection<Integer> ids) {
        return new PathConstraintIds(path, ConstraintOp.NOT_IN, ids);
    }

    public static PathConstraintMultiValue oneOfValues(String path, Collection<String> values) {
        return new PathConstraintMultiValue(path, ConstraintOp.ONE_OF, values);
    }

    public static PathConstraintMultiValue noneOfValues(String path, Collection<String> values) {
        return new PathConstraintMultiValue(path, ConstraintOp.NONE_OF, values);
    }

    public static PathConstraintNull isNull(String path) {
        return new PathConstraintNull(path, ConstraintOp.IS_NULL);
    }

    public static PathConstraintNull isNotNull(String path) {
        return new PathConstraintNull(path, ConstraintOp.IS_NOT_NULL);
    }

    public static PathConstraintSubclass type(String path, String type) {
        return new PathConstraintSubclass(path, type);
    }

    public static PathConstraintLoop equalToLoop(String path, String loopPath) {
        return new PathConstraintLoop(path, ConstraintOp.EQUALS, loopPath);
    }

    public static PathConstraintLoop notEqualToLoop(String path, String loopPath) {
        return new PathConstraintLoop(path, ConstraintOp.NOT_EQUALS, loopPath);
    }

    public static PathConstraintAttribute contains(String path, String contained) {
        return new PathConstraintAttribute(path, ConstraintOp.CONTAINS, contained);
    }
}

