/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.pathquery;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.intermine.pathquery.ParseValueException;
import org.intermine.util.TypeUtil;

public final class ConstraintValueParser {
    private static final Logger LOG = Logger.getLogger(ConstraintValueParser.class);
    public static final DateFormat ISO_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    private ConstraintValueParser() {
    }

    public static Object parse(String value, Class<?> type) throws ParseValueException {
        Object parsedValue = null;
        if (value == null || value.length() == 0) {
            throw new ParseValueException("No input given, please supply a valid expression");
        }
        if (Date.class.equals(type)) {
            try {
                parsedValue = ISO_DATE_FORMAT.parse(value);
            }
            catch (ParseException e) {
                throw new ParseValueException(value + " is not a valid date - example: " + ISO_DATE_FORMAT.format(new Date()));
            }
        }
        if (String.class.equals(type)) {
            if (value.length() == 0) {
                throw new ParseValueException("Please supply a valid expression.");
            }
            parsedValue = value.trim();
        } else {
            try {
                parsedValue = TypeUtil.stringToObject(type, (String)value);
                if (parsedValue instanceof String) {
                    parsedValue = ((String)parsedValue).trim();
                }
            }
            catch (NumberFormatException e) {
                throw new ParseValueException(value + " is not a valid number.");
            }
        }
        return parsedValue;
    }

    public static String format(String value) {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM d HH:mm:ss Z yyyy");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            Date date = sdf.parse(value);
            return ISO_DATE_FORMAT.format(date);
        }
        catch (ParseException e) {
            LOG.log(Priority.ERROR, (Object)("The date" + value + " is not a valid date"), (Throwable)e);
            return "";
        }
    }

    static {
        Calendar gregorianCalendar = GregorianCalendar.getInstance(TimeZone.getTimeZone("GMT"));
        ISO_DATE_FORMAT.setCalendar(gregorianCalendar);
    }
}

