/*
 * Decompiled with CFR 0.152.
 */
package test.it.unimi.dsi.mg4j.compression;

import cern.colt.bitvector.BitVector;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.mg4j.compression.Decoder;
import it.unimi.dsi.mg4j.compression.HuffmanCodec;
import it.unimi.dsi.mg4j.compression.PrefixCodec;
import java.util.Random;
import junit.framework.TestCase;

public class HuffmanCodecTest
extends TestCase {
    public void testOneSymbol() {
        HuffmanCodec coder = new HuffmanCodec(new int[]{1});
        HuffmanCodecTest.assertEquals((int)1, (int)coder.codeWord.length);
        HuffmanCodecTest.assertEquals((Object)new BitVector(0), (Object)coder.codeWord[0]);
    }

    public void testTwoEquiprobableSymbols() {
        HuffmanCodec coder = new HuffmanCodec(new int[]{1, 1});
        HuffmanCodecTest.assertEquals((int)2, (int)coder.codeWord.length);
        HuffmanCodecTest.assertEquals((Object)new BitVector(1), (Object)coder.codeWord[0]);
        BitVector v = new BitVector(1);
        v.set(0);
        HuffmanCodecTest.assertEquals((Object)v, (Object)coder.codeWord[1]);
    }

    public void testThreeNonequiprobableSymbols() {
        HuffmanCodec coder = new HuffmanCodec(new int[]{1, 2, 4});
        HuffmanCodecTest.assertEquals((int)3, (int)coder.codeWord.length);
        HuffmanCodecTest.assertEquals((Object)new BitVector(2), (Object)coder.codeWord[0]);
        BitVector v = new BitVector(2);
        v.set(1);
        HuffmanCodecTest.assertEquals((Object)v, (Object)coder.codeWord[1]);
        v = new BitVector(1);
        v.set(0);
        HuffmanCodecTest.assertEquals((Object)v, (Object)coder.codeWord[2]);
    }

    public void testRandomFrequencies() {
        long seed = System.currentTimeMillis();
        System.err.println(seed);
        Random r = new Random(seed);
        int[] frequency = new int[100];
        for (int i = 0; i < frequency.length; ++i) {
            frequency[i] = r.nextInt(1000);
        }
        HuffmanCodec codec = new HuffmanCodec(frequency);
        this.checkPrefixCodec(codec, r);
    }

    private void checkPrefixCodec(PrefixCodec codec, Random r) {
        int i;
        int[] symbol = new int[100];
        BooleanArrayList bits = new BooleanArrayList();
        for (i = 0; i < symbol.length; ++i) {
            symbol[i] = r.nextInt(codec.size);
        }
        for (i = 0; i < symbol.length; ++i) {
            BitVector word = codec.codeWord[symbol[i]];
            for (int j = 0; j < word.size(); ++j) {
                bits.add(word.get(j));
            }
        }
        BooleanIterator booleanIterator = bits.iterator();
        Decoder decoder = codec.getDecoder();
        for (int i2 = 0; i2 < symbol.length; ++i2) {
            HuffmanCodecTest.assertEquals((int)decoder.decode(booleanIterator), (int)symbol[i2]);
        }
    }

    private void checkLengths(int[] frequency, int[] codeLength, BitVector[] codeWord) {
        for (int i = 0; i < frequency.length; ++i) {
            HuffmanCodecTest.assertEquals((String)Integer.toString(i), (int)codeLength[i], (int)codeWord[i].size());
        }
    }

    public void testRandomCodeLengths() {
        int[] frequency = new int[]{805, 1335, 6401, 7156, 7333, 10613, 10951, 11708, 12710, 12948, 13237, 13976, 20355, 20909, 22398, 26303, 26400, 28380, 28865, 30152, 31693};
        int[] codeLength = new int[]{7, 7, 6, 5, 5, 5, 5, 5, 5, 5, 5, 5, 4, 4, 4, 4, 4, 4, 4, 3, 3};
        HuffmanCodec codec = new HuffmanCodec(frequency);
        this.checkLengths(frequency, codeLength, codec.codeWord);
        this.checkPrefixCodec(codec, new Random());
    }

    public void testExponentialCodeLengths() {
        int[] frequency = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000, 0x1000000, 0x2000000, 0x4000000, 0x8000000, 0x10000000, 0x20000000, 0x40000000};
        int[] codeLength = new int[]{30, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1};
        HuffmanCodec codec = new HuffmanCodec(frequency);
        this.checkLengths(frequency, codeLength, codec.codeWord);
        this.checkPrefixCodec(codec, new Random());
    }
}

