/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.util;

import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.mg4j.io.FileLinesCollection;
import it.unimi.dsi.mg4j.util.Fast;
import it.unimi.dsi.mg4j.util.MinimalPerfectHash;
import it.unimi.dsi.mg4j.util.MutableString;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SignedMinimalPerfectHash
extends MinimalPerfectHash
implements Serializable {
    private static final Logger LOGGER = Fast.getLogger(MinimalPerfectHash.class);
    public static final long serialVersionUID = -7046029254386353130L;

    public SignedMinimalPerfectHash(Iterable<? extends CharSequence> terms) {
        super(terms);
        this.initSignatures(terms);
    }

    public SignedMinimalPerfectHash(Iterable<? extends CharSequence> terms, int weightLength) {
        super(terms, weightLength);
        this.initSignatures(terms);
    }

    public SignedMinimalPerfectHash(String termFile, String encoding, int weightLength, boolean zipped) {
        super(termFile, encoding, weightLength, zipped);
        this.initSignatures(new FileLinesCollection(termFile, encoding, zipped));
    }

    public SignedMinimalPerfectHash(String termFile, String encoding, boolean zipped) {
        super(termFile, encoding, zipped);
        this.initSignatures(new FileLinesCollection(termFile, encoding, zipped));
    }

    public SignedMinimalPerfectHash(String termFile, String encoding, int weightLength) {
        super(termFile, encoding, weightLength);
        this.initSignatures(new FileLinesCollection(termFile, encoding));
    }

    public SignedMinimalPerfectHash(String termFile, String encoding) {
        super(termFile, encoding);
        this.initSignatures(new FileLinesCollection(termFile, encoding));
    }

    @Override
    public int getNumber(CharSequence term) {
        int i = super.getNumber(term);
        if (this.checkSignature(term, i)) {
            return i;
        }
        return -1;
    }

    @Override
    public int getNumber(MutableString term) {
        int i = super.getNumber(term);
        if (this.checkSignature(term, i)) {
            return i;
        }
        return -1;
    }

    @Override
    public int getNumber(byte[] a, int off, int len) {
        int i = super.getNumber(a, off, len);
        if (this.checkSignature(a, off, len, i)) {
            return i;
        }
        return -1;
    }

    protected abstract void initSignatures(Iterable<? extends CharSequence> var1);

    protected abstract boolean checkSignature(CharSequence var1, int var2);

    protected abstract boolean checkSignature(byte[] var1, int var2, int var3, int var4);

    public MinimalPerfectHash asUnsigned() {
        return new MinimalPerfectHash(this);
    }

    public static void main(String[] arg) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, IOException, JSAPException, ClassNotFoundException {
        SimpleJSAP jsap = new SimpleJSAP(SignedMinimalPerfectHash.class.getName(), "Builds an unsigned order-preserving minimal perfect hash from a signed one.", new Parameter[]{new UnflaggedOption("smph", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename for the input serialised signed minimal perfect hash table."), new UnflaggedOption("mph", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename for the output serialised unsigned minimal perfect hash table.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        LOGGER.info((Object)"Reading signed map...");
        SignedMinimalPerfectHash smph = (SignedMinimalPerfectHash)BinIO.loadObject((CharSequence)jsapResult.getString("smph"));
        LOGGER.info((Object)"Writing unsigned map to file...");
        BinIO.storeObject((Object)smph.asUnsigned(), (CharSequence)jsapResult.getString("mph"));
        LOGGER.info((Object)"Completed.");
    }
}

