/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search.score;

import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Reference2DoubleMap;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.score.AbstractWeightedScorer;
import it.unimi.dsi.mg4j.search.score.DelegatingScorer;
import it.unimi.dsi.mg4j.search.visitor.CounterCollectionVisitor;
import it.unimi.dsi.mg4j.search.visitor.CounterSetupVisitor;
import it.unimi.dsi.mg4j.search.visitor.TermCollectionVisitor;
import java.io.IOException;
import org.apache.log4j.Logger;

public class TfIdfScorer
extends AbstractWeightedScorer
implements DelegatingScorer {
    private static final Logger LOGGER = Logger.getLogger(TfIdfScorer.class);
    private static final boolean DEBUG = false;
    private final CounterCollectionVisitor counterCollectionVisitor;
    private final CounterSetupVisitor setupVisitor;
    private final TermCollectionVisitor termVisitor = new TermCollectionVisitor();
    private IntList[] sizes;
    private int[] size;
    private double[] weightedIdfPart;

    public TfIdfScorer() {
        this.setupVisitor = new CounterSetupVisitor(this.termVisitor);
        this.counterCollectionVisitor = new CounterCollectionVisitor(this.setupVisitor);
    }

    public synchronized TfIdfScorer copy() {
        TfIdfScorer scorer = new TfIdfScorer();
        scorer.setWeights((Reference2DoubleMap<Index>)this.index2Weight);
        return scorer;
    }

    public double score() throws IOException {
        this.setupVisitor.clear();
        this.documentIterator.acceptOnTruePaths(this.counterCollectionVisitor);
        int document = this.documentIterator.document();
        int[] count = this.setupVisitor.count;
        int[] indexNumber = this.setupVisitor.indexNumber;
        double[] weightedIdfPart = this.weightedIdfPart;
        int[] size = this.size;
        int i = this.currIndex.length;
        while (i-- != 0) {
            size[i] = this.sizes[i].getInt(document);
        }
        double score = 0.0;
        int i2 = count.length;
        while (i2-- != 0) {
            int k = indexNumber[i2];
            score += (double)count[i2] / (double)size[k] * weightedIdfPart[i2];
        }
        return score;
    }

    public double score(Index index) {
        throw new UnsupportedOperationException();
    }

    public void wrap(DocumentIterator d) throws IOException {
        this.documentIterator = d;
        this.termVisitor.prepare();
        d.accept(this.termVisitor);
        Index[] index = this.termVisitor.indices();
        this.sizes = new IntList[index.length];
        int i = index.length;
        while (i-- != 0) {
            this.sizes[i] = index[i].sizes;
            if (this.sizes[i] != null) continue;
            throw new IllegalStateException("A BM25 scorer requires document sizes");
        }
        this.setupVisitor.prepare();
        d.accept(this.setupVisitor);
        int[] frequency = this.setupVisitor.frequency;
        int[] indexNumber = this.setupVisitor.indexNumber;
        this.weightedIdfPart = new double[frequency.length];
        int i2 = this.weightedIdfPart.length;
        while (i2-- != 0) {
            this.weightedIdfPart[i2] = Math.log((double)index[indexNumber[i2]].numberOfDocuments / (double)frequency[i2]) * this.index2Weight.getDouble((Object)index[indexNumber[i2]]);
        }
        this.size = new int[index.length];
        this.currIndex = index;
    }

    public boolean usesIntervals() {
        return false;
    }
}

