/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.compression;

import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.mg4j.compression.Decoder;
import it.unimi.dsi.mg4j.io.InputBitStream;
import java.io.IOException;
import java.io.Serializable;

public final class TreeDecoder
implements Decoder,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Node root;

    public TreeDecoder(Node root) {
        this.root = root;
    }

    public int decode(BooleanIterator iterator) {
        Node n = this.root;
        while (!(n instanceof LeafNode)) {
            n = iterator.nextBoolean() ? n.right : n.left;
        }
        return ((LeafNode)n).symbol;
    }

    public int decode(InputBitStream ibs) throws IOException {
        Node n = this.root;
        while (!(n instanceof LeafNode)) {
            n = ibs.readBit() == 0 ? n.left : n.right;
        }
        return ((LeafNode)n).symbol;
    }

    public static class LeafNode
    extends Node {
        private static final long serialVersionUID = 1L;
        public final int symbol;

        public LeafNode(int symbol) {
            this.symbol = symbol;
        }
    }

    public static class Node
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public Node left;
        public Node right;
    }
}

