/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.compression;

import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.longs.LongHeapSemiIndirectPriorityQueue;
import it.unimi.dsi.mg4j.compression.PrefixCodec;
import it.unimi.dsi.mg4j.compression.TreeDecoder;
import java.io.Serializable;

public class HuffmanCodec
extends PrefixCodec
implements Serializable {
    private static final long serialVersionUID = 1L;

    public HuffmanCodec(int[] frequency) {
        super(frequency);
    }

    protected TreeDecoder.Node initTree(int[] frequency) {
        boolean[] internal = new boolean[this.size];
        boolean[] removed = new boolean[this.size];
        long[] compoundFrequency = new long[this.size];
        TreeDecoder.Node[] externalNode = new TreeDecoder.Node[this.size];
        TreeDecoder.Node[] node = new TreeDecoder.Node[this.size];
        int i = this.size;
        while (i-- != 0) {
            compoundFrequency[i] = frequency[i];
            node[i] = externalNode[i] = new TreeDecoder.LeafNode(i);
        }
        int[] a = new int[this.size];
        IntIterators.unwrap((IntIterator)IntIterators.fromTo((int)0, (int)this.size), (int[])a);
        LongHeapSemiIndirectPriorityQueue queue = new LongHeapSemiIndirectPriorityQueue(compoundFrequency, a);
        int min2 = 0;
        int i2 = this.size;
        while (--i2 != 0) {
            int min1 = queue.dequeue();
            min2 = queue.first();
            internal[min2] = true;
            removed[min1] = true;
            TreeDecoder.Node n = new TreeDecoder.Node();
            n.left = node[min1];
            n.right = node[min2];
            node[min2] = n;
            int n2 = min2;
            compoundFrequency[n2] = compoundFrequency[n2] + compoundFrequency[min1];
            queue.changed();
        }
        return node[min2];
    }
}

