/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.hups;

import cern.colt.list.IntArrayList;
import umontreal.iro.lecuyer.hups.CycleBasedPointSetBase2;
import umontreal.iro.lecuyer.hups.F2wStructure;
import umontreal.iro.lecuyer.util.PrintfFormat;

public class F2wCycleBasedLFSR
extends CycleBasedPointSetBase2 {
    private F2wStructure param;

    public F2wCycleBasedLFSR(int w, int r, int modQ, int step, int nbcoeff, int[] coeff, int[] nocoeff) {
        this.param = new F2wStructure(w, r, modQ, step, nbcoeff, coeff, nocoeff);
        this.init();
    }

    public F2wCycleBasedLFSR(String filename, int no) {
        this.param = new F2wStructure(filename, no);
        this.init();
    }

    private void init() {
        this.param.initParamLFSR();
        this.normFactor = this.param.normFactor;
        this.EpsilonHalf = this.param.EpsilonHalf;
        this.numBits = this.param.numBits;
        this.fillCyclesLFSR();
    }

    public String toString() {
        String s = "F2wCycleBasedLFSR:" + PrintfFormat.NEWLINE;
        return s + this.param.toString();
    }

    private void fillCyclesLFSR() {
        int i;
        int n = 1 << this.param.getLog2N();
        boolean[] stateVisited = new boolean[n];
        for (i = 0; i < n; ++i) {
            stateVisited[i] = false;
        }
        int startState = 0;
        this.numPoints = 0;
        while (startState < n) {
            stateVisited[startState] = true;
            IntArrayList c = new IntArrayList();
            this.param.state = startState;
            this.param.initF2wLFSR();
            c.add(this.param.output);
            this.param.F2wLFSR();
            while (this.param.state != startState) {
                stateVisited[this.param.state] = true;
                c.add(this.param.output);
                this.param.F2wLFSR();
            }
            this.addCycle(c);
            for (i = startState + 1; i < n && stateVisited[i]; ++i) {
            }
            startState = i;
        }
    }
}

