/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.ints.AbstractInt2LongSortedMap;
import it.unimi.dsi.fastutil.ints.AbstractIntSortedSet;
import it.unimi.dsi.fastutil.ints.Int2LongMap;
import it.unimi.dsi.fastutil.ints.Int2LongSortedMap;
import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import it.unimi.dsi.fastutil.longs.AbstractLongCollection;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Int2LongLinkedOpenHashMap
extends AbstractInt2LongSortedMap
implements Serializable,
Cloneable,
Hash {
    protected transient int[] key;
    protected transient long[] value;
    protected transient byte[] state;
    protected final float f;
    protected transient int p;
    protected transient int maxFill;
    protected transient int free;
    protected int count;
    protected volatile transient ObjectSortedSet<Map.Entry<Integer, Long>> entries;
    protected volatile transient IntSortedSet keys;
    protected volatile transient LongCollection values;
    protected transient int growthFactor = 16;
    protected transient int first = -1;
    protected transient int last = -1;
    protected transient int[] link;
    public static final long serialVersionUID = -7046029254386353129L;
    private static final boolean ASSERTS = false;

    public Int2LongLinkedOpenHashMap(int n, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Hash table size must be nonnegative");
        }
        int l = Arrays.binarySearch(PRIMES, (int)((float)n / f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        this.p = l;
        this.free = PRIMES[this.p];
        this.f = f;
        this.maxFill = (int)((float)this.free * f);
        this.key = new int[this.free];
        this.value = new long[this.free];
        this.state = new byte[this.free];
        this.link = new int[this.free];
    }

    public Int2LongLinkedOpenHashMap(int n) {
        this(n, 0.75f);
    }

    public Int2LongLinkedOpenHashMap() {
        this(16, 0.75f);
    }

    public Int2LongLinkedOpenHashMap(Map<? extends Integer, ? extends Long> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Int2LongLinkedOpenHashMap(Map<? extends Integer, ? extends Long> m) {
        this(m, 0.75f);
    }

    public Int2LongLinkedOpenHashMap(Int2LongMap m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Int2LongLinkedOpenHashMap(Int2LongMap m) {
        this(m, 0.75f);
    }

    public Int2LongLinkedOpenHashMap(int[] k, long[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Int2LongLinkedOpenHashMap(int[] k, long[] v) {
        this(k, v, 0.75f);
    }

    public void growthFactor(int growthFactor) {
        if (growthFactor <= 0) {
            throw new IllegalArgumentException("Illegal growth factor " + growthFactor);
        }
        this.growthFactor = growthFactor;
    }

    public int growthFactor() {
        return this.growthFactor;
    }

    protected final int findInsertionPoint(int k) {
        byte[] state = this.state;
        int k2i = k & Integer.MAX_VALUE;
        int[] key = this.key;
        int n = key.length;
        int h1 = k2i % n;
        if (state[h1] == -1 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] == -1 && k != key[h1]) {
            }
        }
        if (state[h1] == 0) {
            return h1;
        }
        if (state[h1] == -1) {
            return -h1 - 1;
        }
        int i = h1;
        if (k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] != 0 && k != key[h1]) {
            }
        }
        return state[h1] == -1 ? -h1 - 1 : i;
    }

    protected final int findKey(int k) {
        byte[] state = this.state;
        int k2i = k & Integer.MAX_VALUE;
        int[] key = this.key;
        int n = key.length;
        int h1 = k2i % n;
        if (state[h1] != 0 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] != 0 && k != key[h1]) {
            }
        }
        return state[h1] == -1 ? h1 : -1;
    }

    @Override
    public long put(int k, long v) {
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            long oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return oldValue;
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (this.count == 0) {
            this.first = this.last = i;
            this.link[i] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~i;
            this.link[i] = ~this.last;
            this.last = i;
        }
        if (++this.count >= this.maxFill) {
            int newP = Math.min(this.p + this.growthFactor, PRIMES.length - 1);
            while (PRIMES[newP] == PRIMES[this.p]) {
                ++newP;
            }
            this.rehash(newP);
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return this.defRetValue;
    }

    @Override
    public Long put(Integer ok, Long ov) {
        long v = ov;
        int k = ok;
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            long oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return oldValue;
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (this.count == 0) {
            this.first = this.last = i;
            this.link[i] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~i;
            this.link[i] = ~this.last;
            this.last = i;
        }
        if (++this.count >= this.maxFill) {
            this.rehash(Math.min(this.p + 16, PRIMES.length - 1));
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return null;
    }

    @Override
    public boolean containsValue(long v) {
        long[] value = this.value;
        byte[] state = this.state;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (state[i] != -1) {
                ++i;
            }
            if (value[i] == v) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.free == this.state.length) {
            return;
        }
        this.free = this.state.length;
        this.count = 0;
        ByteArrays.fill(this.state, (byte)0);
        this.last = -1;
        this.first = -1;
    }

    private void fixPointers(int i) {
        int next;
        if (this.count == 0) {
            this.last = -1;
            this.first = -1;
            return;
        }
        if (this.first == i) {
            int n = this.first = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        if (this.last == i) {
            int n = this.last = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        int j = this.first;
        int prev = -1;
        while ((next = this.link[j] ^ prev) != i) {
            prev = j;
            j = next;
        }
        int n = j;
        this.link[n] = this.link[n] ^ (this.link[i] ^ i ^ j);
        int n2 = this.link[i] ^ j;
        this.link[n2] = this.link[n2] ^ (i ^ j);
    }

    @Override
    public int firstIntKey() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.first];
    }

    @Override
    public int lastIntKey() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.last];
    }

    @Override
    public IntComparator comparator() {
        return null;
    }

    @Override
    public Int2LongSortedMap tailMap(int from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Int2LongSortedMap headMap(int to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Int2LongSortedMap subMap(int from, int to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(int k) {
        return this.findKey(k) >= 0;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public long get(int k) {
        int i = this.findKey(k);
        return i < 0 ? this.defRetValue : this.value[i];
    }

    @Override
    public long remove(int k) {
        int i = this.findKey(k);
        if (i < 0) {
            return this.defRetValue;
        }
        this.state[i] = 1;
        --this.count;
        this.fixPointers(i);
        return this.value[i];
    }

    public Long get(Integer ok) {
        int i = this.findKey(ok);
        return i < 0 ? null : Long.valueOf(this.value[i]);
    }

    @Override
    public Long remove(Object ok) {
        int i = this.findKey((Integer)ok);
        if (i < 0) {
            return null;
        }
        this.state[i] = 1;
        --this.count;
        this.fixPointers(i);
        return this.value[i];
    }

    @Override
    public ObjectSortedSet<Map.Entry<Integer, Long>> entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractObjectSortedSet<Map.Entry<Integer, Long>>(){

                @Override
                public ObjectBidirectionalIterator<Map.Entry<Integer, Long>> iterator() {
                    return new EntryIterator();
                }

                @Override
                public Comparator<? super Map.Entry<Integer, Long>> comparator() {
                    return null;
                }

                @Override
                public ObjectSortedSet<Map.Entry<Integer, Long>> subSet(Map.Entry<Integer, Long> fromElement, Map.Entry<Integer, Long> toElement) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public ObjectSortedSet<Map.Entry<Integer, Long>> headSet(Map.Entry<Integer, Long> toElement) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public ObjectSortedSet<Map.Entry<Integer, Long>> tailSet(Map.Entry<Integer, Long> fromElement) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public Map.Entry<Integer, Long> first() {
                    if (Int2LongLinkedOpenHashMap.this.count == 0) {
                        throw new NoSuchElementException();
                    }
                    return new MapEntry(Int2LongLinkedOpenHashMap.this.first);
                }

                @Override
                public Map.Entry<Integer, Long> last() {
                    if (Int2LongLinkedOpenHashMap.this.count == 0) {
                        throw new NoSuchElementException();
                    }
                    return new MapEntry(Int2LongLinkedOpenHashMap.this.last);
                }

                @Override
                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    int i = Int2LongLinkedOpenHashMap.this.findKey((Integer)e.getKey());
                    return i >= 0 && Int2LongLinkedOpenHashMap.this.value[i] == (Long)e.getValue();
                }

                @Override
                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    int i = Int2LongLinkedOpenHashMap.this.findKey((Integer)e.getKey());
                    if (i >= 0) {
                        Int2LongLinkedOpenHashMap.this.remove(e.getKey());
                    }
                    return i >= 0;
                }

                @Override
                public int size() {
                    return Int2LongLinkedOpenHashMap.this.count;
                }

                @Override
                public void clear() {
                    Int2LongLinkedOpenHashMap.this.clear();
                }

                @Override
                public ObjectBidirectionalIterator<Map.Entry<Integer, Long>> iterator(Map.Entry<Integer, Long> from) {
                    return new EntryIterator(from.getKey());
                }
            };
        }
        return this.entries;
    }

    @Override
    public IntSortedSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public LongCollection values() {
        if (this.values == null) {
            this.values = new AbstractLongCollection(){

                public LongIterator iterator() {
                    return new ValueIterator();
                }

                public int size() {
                    return Int2LongLinkedOpenHashMap.this.count;
                }

                public boolean contains(long v) {
                    return Int2LongLinkedOpenHashMap.this.containsValue(v);
                }

                public void clear() {
                    Int2LongLinkedOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    public boolean rehash() {
        try {
            this.rehash(this.p);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim() {
        int l = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (l >= this.p) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = Arrays.binarySearch(PRIMES, (int)Math.min(2.1474836E9f, (float)Math.max(n, this.count) / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (this.p <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newP) {
        int i = this.first;
        int j = this.count;
        int prev = -1;
        int newPrev = -1;
        int newN = PRIMES[newP];
        int[] key = this.key;
        int[] newKey = new int[newN];
        long[] value = this.value;
        long[] newValue = new long[newN];
        byte[] newState = new byte[newN];
        int[] link = this.link;
        int[] newLink = new int[newN];
        this.first = -1;
        while (j-- != 0) {
            int k = key[i];
            long v = value[i];
            int k2i = k & Integer.MAX_VALUE;
            int h1 = k2i % newN;
            int h2 = k2i % (newN - 2) + 1;
            if (newState[h1] != 0) {
                h2 = k2i % (newN - 2) + 1;
                while (newState[h1 = (h1 + h2) % newN] != 0) {
                }
            }
            newState[h1] = -1;
            newKey[h1] = k;
            newValue[h1] = v;
            int t = i;
            i = link[i] ^ prev;
            prev = t;
            if (this.first != -1) {
                int n = newPrev;
                newLink[n] = newLink[n] ^ h1;
                newLink[h1] = newPrev;
                newPrev = h1;
                continue;
            }
            newPrev = this.first = h1;
            newLink[h1] = -1;
        }
        this.p = newP;
        this.free = newN - this.count;
        this.maxFill = (int)((float)newN * this.f);
        this.key = newKey;
        this.value = newValue;
        this.state = newState;
        this.link = newLink;
        this.last = newPrev;
        if (newPrev != -1) {
            int n = newPrev;
            newLink[n] = ~newLink[n];
        }
    }

    public Object clone() {
        Int2LongLinkedOpenHashMap c;
        try {
            c = (Int2LongLinkedOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (int[])this.key.clone();
        c.value = (long[])this.value.clone();
        c.state = (byte[])this.state.clone();
        c.link = (int[])this.link.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (this.state[i] != -1) {
                ++i;
            }
            int t = 0;
            t = this.key[i];
            h += (t ^= HashCommon.long2int(this.value[i]));
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        int[] key = this.key;
        long[] value = this.value;
        MapIterator i = new MapIterator();
        int j = this.count;
        s.defaultWriteObject();
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeInt(key[e]);
            s.writeLong(value[e]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.growthFactor = 16;
        this.p = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (this.p < 0) {
            this.p = -this.p - 1;
        }
        int n = PRIMES[this.p];
        this.maxFill = (int)((float)n * this.f);
        this.free = n - this.count;
        this.key = new int[n];
        int[] key = this.key;
        this.value = new long[n];
        long[] value = this.value;
        this.state = new byte[n];
        byte[] state = this.state;
        this.link = new int[n];
        int[] link = this.link;
        int prev = -1;
        this.last = -1;
        this.first = -1;
        int i = this.count;
        while (i-- != 0) {
            int k = s.readInt();
            long v = s.readLong();
            int k2i = k & Integer.MAX_VALUE;
            int h1 = k2i % n;
            if (state[h1] != 0) {
                int h2 = k2i % (n - 2) + 1;
                while (state[h1 = (h1 + h2) % n] != 0) {
                }
            }
            state[h1] = -1;
            key[h1] = k;
            value[h1] = v;
            if (this.first != -1) {
                int n2 = prev;
                link[n2] = link[n2] ^ h1;
                link[h1] = prev;
                prev = h1;
                continue;
            }
            prev = this.first = h1;
            link[h1] = -1;
        }
        this.last = prev;
        if (prev != -1) {
            int n3 = prev;
            link[n3] = ~link[n3];
        }
    }

    private void checkTable() {
    }

    private final class ValueIterator
    extends MapIterator
    implements LongListIterator {
        public long previousLong() {
            return Int2LongLinkedOpenHashMap.this.value[this.previousEntry()];
        }

        public Long previous() {
            return Int2LongLinkedOpenHashMap.this.value[this.previousEntry()];
        }

        public void set(Long ok) {
            throw new UnsupportedOperationException();
        }

        public void add(Long ok) {
            throw new UnsupportedOperationException();
        }

        public void set(long v) {
            throw new UnsupportedOperationException();
        }

        public void add(long v) {
            throw new UnsupportedOperationException();
        }

        public long nextLong() {
            return Int2LongLinkedOpenHashMap.this.value[this.nextEntry()];
        }

        public Long next() {
            return Int2LongLinkedOpenHashMap.this.value[this.nextEntry()];
        }
    }

    private final class KeySet
    extends AbstractIntSortedSet {
        private KeySet() {
        }

        public IntBidirectionalIterator iterator(int from) {
            return new KeyIterator(from);
        }

        public IntBidirectionalIterator iterator() {
            return new KeyIterator();
        }

        public int size() {
            return Int2LongLinkedOpenHashMap.this.count;
        }

        public boolean contains(int k) {
            return Int2LongLinkedOpenHashMap.this.containsKey(k);
        }

        public boolean remove(int k) {
            int oldCount = Int2LongLinkedOpenHashMap.this.count;
            Int2LongLinkedOpenHashMap.this.remove(k);
            return Int2LongLinkedOpenHashMap.this.count != oldCount;
        }

        public void clear() {
            Int2LongLinkedOpenHashMap.this.clear();
        }

        public int firstInt() {
            if (Int2LongLinkedOpenHashMap.this.count == 0) {
                throw new NoSuchElementException();
            }
            return Int2LongLinkedOpenHashMap.this.key[Int2LongLinkedOpenHashMap.this.first];
        }

        public int lastInt() {
            if (Int2LongLinkedOpenHashMap.this.count == 0) {
                throw new NoSuchElementException();
            }
            return Int2LongLinkedOpenHashMap.this.key[Int2LongLinkedOpenHashMap.this.last];
        }

        public IntComparator comparator() {
            return null;
        }

        public final IntSortedSet tailSet(int from) {
            throw new UnsupportedOperationException();
        }

        public final IntSortedSet headSet(int to) {
            throw new UnsupportedOperationException();
        }

        public final IntSortedSet subSet(int from, int to) {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements IntListIterator {
        public KeyIterator(int k) {
            super(k);
        }

        public int previousInt() {
            return Int2LongLinkedOpenHashMap.this.key[this.previousEntry()];
        }

        public void set(int k) {
            throw new UnsupportedOperationException();
        }

        public void add(int k) {
            throw new UnsupportedOperationException();
        }

        public Integer previous() {
            return Int2LongLinkedOpenHashMap.this.key[this.previousEntry()];
        }

        public void set(Integer ok) {
            throw new UnsupportedOperationException();
        }

        public void add(Integer ok) {
            throw new UnsupportedOperationException();
        }

        public KeyIterator() {
        }

        public int nextInt() {
            return Int2LongLinkedOpenHashMap.this.key[this.nextEntry()];
        }

        public Integer next() {
            return Int2LongLinkedOpenHashMap.this.key[this.nextEntry()];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    extends MapIterator
    implements ObjectListIterator<Map.Entry<Integer, Long>> {
        public EntryIterator() {
        }

        public EntryIterator(int from) {
            super(from);
        }

        @Override
        public MapEntry next() {
            return new MapEntry(this.nextEntry());
        }

        @Override
        public MapEntry previous() {
            return new MapEntry(this.previousEntry());
        }

        @Override
        public void set(Map.Entry<Integer, Long> ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Map.Entry<Integer, Long> ok) {
            throw new UnsupportedOperationException();
        }
    }

    private class MapIterator {
        int prev = -1;
        int next = -1;
        int curr = -1;
        int index = 0;

        MapIterator() {
            this.next = Int2LongLinkedOpenHashMap.this.first;
        }

        MapIterator(int from) {
            if (Int2LongLinkedOpenHashMap.this.key[Int2LongLinkedOpenHashMap.this.last] == from) {
                this.prev = Int2LongLinkedOpenHashMap.this.last;
                this.index = Int2LongLinkedOpenHashMap.this.count;
            } else {
                int e;
                if (!Int2LongLinkedOpenHashMap.this.containsKey(from)) {
                    throw new IllegalArgumentException("The key " + from + " does not belong to this set.");
                }
                this.next = Int2LongLinkedOpenHashMap.this.first;
                while (Int2LongLinkedOpenHashMap.this.key[e = this.nextEntry()] != from) {
                }
                this.curr = -1;
            }
        }

        public boolean hasNext() {
            return this.next != -1;
        }

        public boolean hasPrevious() {
            return this.prev != -1;
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                return Int2LongLinkedOpenHashMap.this.size();
            }
            this.curr = this.next;
            this.next = Int2LongLinkedOpenHashMap.this.link[this.curr] ^ this.prev;
            this.prev = this.curr;
            ++this.index;
            return this.curr;
        }

        public int previousEntry() {
            if (!this.hasPrevious()) {
                return -1;
            }
            this.curr = this.prev;
            this.prev = Int2LongLinkedOpenHashMap.this.link[this.curr] ^ this.next;
            this.next = this.curr;
            --this.index;
            return this.curr;
        }

        public void remove() {
            if (this.curr == -1) {
                throw new IllegalStateException();
            }
            Int2LongLinkedOpenHashMap.this.state[this.curr] = 1;
            if (this.curr == this.prev) {
                --this.index;
                this.prev = Int2LongLinkedOpenHashMap.this.link[this.curr] ^ this.next;
            } else {
                this.next = Int2LongLinkedOpenHashMap.this.link[this.curr] ^ this.prev;
            }
            --Int2LongLinkedOpenHashMap.this.count;
            if (this.prev == -1) {
                Int2LongLinkedOpenHashMap.this.first = this.next;
            } else {
                int n = this.prev;
                Int2LongLinkedOpenHashMap.this.link[n] = Int2LongLinkedOpenHashMap.this.link[n] ^ (this.curr ^ this.next);
            }
            if (this.next == -1) {
                Int2LongLinkedOpenHashMap.this.last = this.prev;
            } else {
                int n = this.next;
                Int2LongLinkedOpenHashMap.this.link[n] = Int2LongLinkedOpenHashMap.this.link[n] ^ (this.curr ^ this.prev);
            }
            this.curr = -1;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }

        public int back(int n) {
            int i = n;
            while (i-- != 0 && this.hasPrevious()) {
                this.previousEntry();
            }
            return n - i - 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MapEntry
    implements Int2LongMap.Entry,
    Map.Entry<Integer, Long> {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        @Override
        public Integer getKey() {
            return Int2LongLinkedOpenHashMap.this.key[this.index];
        }

        @Override
        public int getIntKey() {
            return Int2LongLinkedOpenHashMap.this.key[this.index];
        }

        @Override
        public Long getValue() {
            return Int2LongLinkedOpenHashMap.this.value[this.index];
        }

        @Override
        public long getLongValue() {
            return Int2LongLinkedOpenHashMap.this.value[this.index];
        }

        @Override
        public long setValue(long v) {
            long oldValue = Int2LongLinkedOpenHashMap.this.value[this.index];
            Int2LongLinkedOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        public Long setValue(Long v) {
            return this.setValue((long)v);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Int2LongLinkedOpenHashMap.this.key[this.index] == (Integer)e.getKey() && Int2LongLinkedOpenHashMap.this.value[this.index] == (Long)e.getValue();
        }

        @Override
        public int hashCode() {
            return Int2LongLinkedOpenHashMap.this.key[this.index] ^ HashCommon.long2int(Int2LongLinkedOpenHashMap.this.value[this.index]);
        }

        public String toString() {
            return Int2LongLinkedOpenHashMap.this.key[this.index] + "->" + Int2LongLinkedOpenHashMap.this.value[this.index];
        }
    }
}

