/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.UUID;
import javax.el.ValueExpression;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import org.primefaces.application.resource.DynamicContentType;
import org.primefaces.context.RequestContext;
import org.primefaces.el.ValueExpressionAnalyzer;
import org.primefaces.model.StreamedContent;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.SharedStringBuilder;
import org.primefaces.util.StringEncrypter;

public class DynamicResourceBuilder {
    private static final String SB_BUILD = DynamicResourceBuilder.class.getName() + "#build";

    public static String build(FacesContext context, Object value, UIComponent component, boolean cache, DynamicContentType type) throws UnsupportedEncodingException {
        String src = null;
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            src = ComponentUtils.getResourceURL(context, (String)value);
        } else if (value instanceof StreamedContent) {
            StreamedContent streamedContent = (StreamedContent)value;
            Resource resource = context.getApplication().getResourceHandler().createResource("dynamiccontent.properties", "primefaces", streamedContent.getContentType());
            String resourcePath = resource.getRequestPath();
            StringEncrypter encrypter = RequestContext.getCurrentInstance().getEncrypter();
            ValueExpression expression = ValueExpressionAnalyzer.getExpression(context.getELContext(), component.getValueExpression("value"));
            String rid = encrypter.encrypt(expression.getExpressionString());
            StringBuilder builder = SharedStringBuilder.get(context, SB_BUILD);
            builder.append(resourcePath).append("&").append("pfdrid").append("=").append(URLEncoder.encode(rid, "UTF-8")).append("&").append("pfdrt").append("=").append(type.toString());
            for (UIComponent kid : component.getChildren()) {
                UIParameter param;
                if (!(kid instanceof UIParameter) || (param = (UIParameter)kid).isDisable()) continue;
                Object paramValue = param.getValue();
                builder.append("&").append(param.getName()).append("=");
                if (paramValue == null) continue;
                builder.append(URLEncoder.encode(paramValue.toString(), "UTF-8"));
            }
            src = builder.toString();
        }
        if (src != null) {
            src = src + (src.contains("?") ? "&" : "?");
            src = src + "pfdrid_c=" + cache;
            if (!cache) {
                src = src + "&uid=" + UUID.randomUUID().toString();
            }
        }
        return context.getExternalContext().encodeResourceURL(src);
    }
}

