/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import java.util.ArrayList;
import java.util.Iterator;
import javax.faces.component.ContextCallback;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UniqueIdVendor;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import org.primefaces.util.ComponentUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentTraversalUtils {
    public static <T> T closest(Class<T> type, UIComponent base) {
        for (UIComponent parent = base.getParent(); parent != null; parent = parent.getParent()) {
            if (!type.isAssignableFrom(parent.getClass())) continue;
            return (T)parent;
        }
        return null;
    }

    public static <T> T first(Class<T> type, UIComponent base) {
        Object result = null;
        Iterator kids = base.getFacetsAndChildren();
        while (kids.hasNext() && result == null) {
            UIComponent kid = (UIComponent)kids.next();
            if (type.isAssignableFrom(kid.getClass())) {
                result = kid;
                break;
            }
            result = ComponentTraversalUtils.first(type, base);
            if (result == null) continue;
            break;
        }
        return (T)result;
    }

    public static <T> ArrayList<T> children(Class<T> type, UIComponent base) {
        ArrayList<UIComponent> result = new ArrayList<UIComponent>();
        Iterator kids = base.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            if (!type.isAssignableFrom(kid.getClass())) continue;
            result.add(kid);
        }
        return result;
    }

    public static UIComponent firstWithId(String id, UIComponent base) {
        if (id.equals(base.getId())) {
            return base;
        }
        UIComponent result = null;
        Iterator kids = base.getFacetsAndChildren();
        while (kids.hasNext() && result == null) {
            UIComponent kid = (UIComponent)kids.next();
            if (id.equals(kid.getId())) {
                result = kid;
                break;
            }
            result = ComponentTraversalUtils.firstWithId(id, kid);
            if (result == null) continue;
            break;
        }
        return result;
    }

    public static UIComponent firstById(String id, UIComponent base, String separatorString, FacesContext context) {
        return ComponentTraversalUtils.firstById(id, base, separatorString, context, false);
    }

    public static UIComponent firstById(String id, UIComponent base, String separatorString, FacesContext context, boolean skipUnrendered) {
        UIComponent component = base.findComponent(id);
        if (component == null) {
            String tempExpression = id;
            if (tempExpression.startsWith(separatorString)) {
                tempExpression = tempExpression.substring(1);
            }
            if (skipUnrendered) {
                VisitContext visitContext = VisitContext.createVisitContext((FacesContext)context, null, ComponentUtils.VISIT_HINTS_SKIP_UNRENDERED);
                IdVisitCallback callback = new IdVisitCallback(tempExpression);
                context.getViewRoot().visitTree(visitContext, (VisitCallback)callback);
                return callback.getComponent();
            }
            IdContextCallback callback = new IdContextCallback();
            context.getViewRoot().invokeOnComponent(context, tempExpression, (ContextCallback)callback);
            component = callback.getComponent();
        }
        return component;
    }

    public static UIForm closestForm(FacesContext context, UIComponent component) {
        return ComponentTraversalUtils.closest(UIForm.class, component);
    }

    public static UniqueIdVendor closestUniqueIdVendor(UIComponent component) {
        return ComponentTraversalUtils.closest(UniqueIdVendor.class, component);
    }

    public static UIComponent closestNamingContainer(UIComponent component) {
        return (UIComponent)ComponentTraversalUtils.closest(NamingContainer.class, component);
    }

    public static class IdContextCallback
    implements ContextCallback {
        private UIComponent component;

        public void invokeContextCallback(FacesContext context, UIComponent target) {
            this.component = target;
        }

        public UIComponent getComponent() {
            return this.component;
        }
    }

    public static class IdVisitCallback
    implements VisitCallback {
        private final String targetClientId;
        private UIComponent component;

        public IdVisitCallback(String targetClientId) {
            this.targetClientId = targetClientId;
        }

        public VisitResult visit(VisitContext context, UIComponent target) {
            if (target.getClientId().equals(this.targetClientId)) {
                this.component = target;
                return VisitResult.COMPLETE;
            }
            return VisitResult.ACCEPT;
        }

        public UIComponent getComponent() {
            return this.component;
        }
    }
}

