/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.mobile.renderkit;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.inputtext.InputText;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;

public class InputTextRenderer
extends org.primefaces.component.inputtext.InputTextRenderer {
    public void decode(FacesContext context, UIComponent component) {
        InputText inputText = (InputText)component;
        if (inputText.isDisabled() || inputText.isReadonly()) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)inputText);
        String inputId = inputText.getClientId(context) + "_input";
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(inputId);
        if (submittedValue != null) {
            inputText.setSubmittedValue(submittedValue);
        }
    }

    public void encodeMarkup(FacesContext context, InputText inputText) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = inputText.getClientId(context);
        String inputId = clientId + "_input";
        String type = inputText.getType();
        boolean search = type.equals("search");
        String style = inputText.getStyle();
        String defaultStyleClass = search ? "ui-input-search ui-body-inherit ui-corner-all ui-shadow-inset ui-input-has-clear" : "ui-input-text ui-body-inherit ui-corner-all ui-shadow-inset ui-input-has-clear";
        String styleClass = inputText.getStyleClass();
        String string = styleClass = styleClass == null ? defaultStyleClass : defaultStyleClass + " " + styleClass;
        if (inputText.isDisabled()) {
            styleClass = styleClass + " ui-state-disabled";
        }
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        this.encodeInput(context, inputText, inputId);
        this.encodeClearIcon(context, inputText);
        writer.endElement("div");
    }

    protected void encodeInput(FacesContext context, InputText inputText, String inputId) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String valueToRender = ComponentUtils.getValueToRender(context, (UIComponent)inputText);
        writer.startElement("input", (UIComponent)inputText);
        writer.writeAttribute("data-role", (Object)"none", null);
        writer.writeAttribute("id", (Object)inputId, null);
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("type", (Object)inputText.getType(), null);
        if (inputText.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (inputText.isReadonly()) {
            writer.writeAttribute("readonly", (Object)"readonly", null);
        }
        if (valueToRender != null) {
            writer.writeAttribute("value", (Object)valueToRender, null);
        }
        this.renderPassThruAttributes(context, (UIComponent)inputText, HTML.INPUT_TEXT_ATTRS_WITHOUT_EVENTS);
        this.renderDomEvents(context, (UIComponent)inputText, HTML.INPUT_TEXT_EVENTS);
        writer.endElement("input");
    }

    protected void encodeClearIcon(FacesContext context, InputText inputText) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("a", null);
        writer.writeAttribute("href", (Object)"#", null);
        writer.writeAttribute("class", (Object)"ui-input-clear ui-btn ui-icon-delete ui-btn-icon-notext ui-corner-all ui-input-clear-hidden", null);
        writer.endElement("a");
    }
}

