/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.mobile.renderkit;

import java.io.IOException;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.primefaces.config.ConfigContainer;
import org.primefaces.context.RequestContext;

public class HeadRenderer
extends Renderer {
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        ConfigContainer cc = RequestContext.getCurrentInstance().getApplicationContext().getConfig();
        ProjectStage projectStage = context.getApplication().getProjectStage();
        writer.startElement("head", component);
        UIComponent first = component.getFacet("first");
        if (first != null) {
            first.encodeAll(context);
        }
        writer.write("<meta name=\"viewport\" content=\"width=device-width, initial-scale=1\"/>");
        String theme = this.resolveTheme(context);
        if (theme == null) {
            this.renderCSS(context, "mobile/jquery-mobile.css", "primefaces");
        } else {
            this.renderCSS(context, "theme.css", "primefaces-" + theme);
            this.renderCSS(context, "mobile/jquery-mobile-icons.css", "primefaces");
            this.renderCSS(context, "mobile/jquery-mobile-structure.css", "primefaces");
        }
        this.renderCSS(context, "mobile/primefaces-mobile.css", "primefaces");
        if (cc.isFontAwesomeEnabled()) {
            this.renderCSS(context, "fa/font-awesome.css", "primefaces");
        }
        this.renderJS(context, "jquery/jquery.js", "primefaces");
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("$(document).on('mobileinit', function(){");
        writer.write("$.mobile.ajaxEnabled = false;");
        writer.write("$.mobile.pushStateEnabled = false;");
        writer.write("$.mobile.page.prototype.options.domCache = true;");
        UIComponent init = component.getFacet("init");
        if (init != null) {
            init.encodeAll(context);
        }
        writer.write("});");
        writer.endElement("script");
        this.renderJS(context, "mobile/jquery-mobile.js", "primefaces");
        this.renderJS(context, "primefaces-mobile.js", "primefaces");
        UIViewRoot viewRoot = context.getViewRoot();
        for (UIComponent resource : viewRoot.getComponentResources(context, "head")) {
            String resourceName;
            boolean shouldRender = true;
            Map attrs = resource.getAttributes();
            String library = (String)attrs.get("library");
            if (library != null && library.equals("primefaces") && ((resourceName = (String)attrs.get("name")).startsWith("jquery") || resourceName.startsWith("primefaces"))) {
                shouldRender = false;
            }
            if (!shouldRender) continue;
            resource.encodeAll(context);
        }
        if (!projectStage.equals((Object)ProjectStage.Production) || cc.isLegacyWidgetNamespace()) {
            writer.startElement("script", null);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            writer.write("if(window.PrimeFaces){");
            if (cc.isLegacyWidgetNamespace()) {
                writer.write("PrimeFaces.settings.legacyWidgetNamespace = true;");
            }
            if (!projectStage.equals((Object)ProjectStage.Production)) {
                writer.write("PrimeFaces.settings.projectStage='" + projectStage.toString() + "';");
            }
            writer.write("}");
            writer.endElement("script");
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIComponent last = component.getFacet("last");
        if (last != null) {
            last.encodeAll(context);
        }
        writer.endElement("head");
    }

    protected String resolveTheme(FacesContext context) {
        String theme = null;
        String themeConfigValue = RequestContext.getCurrentInstance().getApplicationContext().getConfig().getMobileTheme();
        if (themeConfigValue != null) {
            ELContext elContext = context.getELContext();
            ExpressionFactory expressionFactory = context.getApplication().getExpressionFactory();
            ValueExpression ve = expressionFactory.createValueExpression(elContext, themeConfigValue, String.class);
            theme = ve.isLiteralText() ? themeConfigValue : (String)ve.getValue(elContext);
        }
        return theme;
    }

    private void renderJS(FacesContext context, String name, String library) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Resource resource = context.getApplication().getResourceHandler().createResource(name, library);
        if (resource != null) {
            writer.startElement("script", null);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            writer.writeAttribute("src", (Object)resource.getRequestPath(), null);
            writer.endElement("script");
        }
    }

    private void renderCSS(FacesContext context, String name, String library) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Resource resource = context.getApplication().getResourceHandler().createResource(name, library);
        if (resource != null) {
            writer.startElement("link", null);
            writer.writeAttribute("type", (Object)"text/css", null);
            writer.writeAttribute("rel", (Object)"stylesheet", null);
            writer.writeAttribute("href", (Object)resource.getRequestPath(), null);
            writer.endElement("link");
        }
    }
}

