/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.mobile.renderkit;

import java.io.IOException;
import java.util.List;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.column.Column;
import org.primefaces.component.columngroup.ColumnGroup;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.row.Row;
import org.primefaces.mobile.renderkit.paginator.PaginatorRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.WidgetBuilder;

public class DataTableRenderer
extends org.primefaces.component.datatable.DataTableRenderer {
    protected void encodeScript(FacesContext context, DataTable table) throws IOException {
        String clientId = table.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("DataTable", table.resolveWidgetVar(), clientId);
        wb.attr("selectionMode", table.getSelectionMode(), null);
        if (table.isPaginator()) {
            PaginatorRenderer paginatorRenderer = this.getPaginatorRenderer(context);
            paginatorRenderer.encodeScript(context, table, wb);
        }
        this.encodeClientBehaviors(context, table);
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, DataTable table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = table.getClientId(context);
        String style = table.getStyle();
        String defaultStyleClass = "ui-datatable ui-shadow";
        String styleClass = table.getStyleClass();
        styleClass = styleClass == null ? defaultStyleClass : defaultStyleClass + " " + styleClass;
        boolean hasPaginator = table.isPaginator();
        String paginatorPosition = table.getPaginatorPosition();
        PaginatorRenderer paginatorRenderer = this.getPaginatorRenderer(context);
        writer.startElement("div", (UIComponent)table);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        if (hasPaginator && !paginatorPosition.equalsIgnoreCase("bottom")) {
            paginatorRenderer.encodeMarkup(context, table, "top");
        }
        this.encodeRegularTable(context, table);
        this.renderDynamicPassThruAttributes(context, (UIComponent)table);
        if (hasPaginator && !paginatorPosition.equalsIgnoreCase("top")) {
            paginatorRenderer.encodeMarkup(context, table, "bottom");
        }
        if (table.isSelectionEnabled()) {
            this.encodeStateHolder(context, table, table.getClientId(context) + "_selection", table.getSelectedRowKeysAsString());
        }
        writer.endElement("div");
    }

    protected void encodeRegularTable(FacesContext context, DataTable table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String styleClass = table.getTableStyleClass();
        String string = styleClass = styleClass == null ? "ui-responsive ui-table table-stripe" : "ui-responsive ui-table table-stripe " + styleClass;
        if (table.isReflow()) {
            styleClass = styleClass + " ui-table-reflow";
        }
        writer.startElement("table", null);
        writer.writeAttribute("role", (Object)"grid", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (table.getTableStyle() != null) {
            writer.writeAttribute("style", (Object)table.getTableStyle(), null);
        }
        if (table.getSummary() != null) {
            writer.writeAttribute("summary", (Object)table.getSummary(), null);
        }
        this.encodeThead(context, table);
        this.encodeTFoot(context, table);
        this.encodeTbody(context, table, false);
        writer.endElement("table");
    }

    protected void encodeThead(FacesContext context, DataTable table, int columnStart, int columnEnd, String theadId, String columnGroupName) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        ColumnGroup group = table.getColumnGroup("header");
        List<UIColumn> columns = table.getColumns();
        String theadClientId = theadId == null ? table.getClientId(context) + "_head" : theadId;
        writer.startElement("thead", null);
        writer.writeAttribute("id", (Object)theadClientId, null);
        if (group != null && group.isRendered()) {
            context.getAttributes().put("org.primefaces.HELPER_RENDERER", "columnGroup");
            for (UIComponent child : group.getChildren()) {
                if (!child.isRendered()) continue;
                if (child instanceof Row) {
                    Row headerRow = (Row)child;
                    writer.startElement("tr", null);
                    writer.writeAttribute("class", (Object)"ui-bar-a", null);
                    for (UIComponent headerRowChild : headerRow.getChildren()) {
                        if (!headerRowChild.isRendered()) continue;
                        if (headerRowChild instanceof Column) {
                            this.encodeColumnHeader(context, table, (Column)headerRowChild);
                            continue;
                        }
                        headerRowChild.encodeAll(context);
                    }
                    writer.endElement("tr");
                    continue;
                }
                child.encodeAll(context);
            }
            context.getAttributes().remove("org.primefaces.HELPER_RENDERER");
        } else {
            writer.startElement("tr", null);
            writer.writeAttribute("class", (Object)"ui-bar-a", null);
            writer.writeAttribute("role", (Object)"row", null);
            for (int i = columnStart; i < columnEnd; ++i) {
                UIColumn column = columns.get(i);
                if (column instanceof Column) {
                    this.encodeColumnHeader(context, table, column);
                    continue;
                }
                if (!(column instanceof DynamicColumn)) continue;
                DynamicColumn dynamicColumn = (DynamicColumn)column;
                dynamicColumn.applyModel();
                this.encodeColumnHeader(context, table, dynamicColumn);
            }
            writer.endElement("tr");
        }
        writer.endElement("thead");
    }

    public void encodeColumnHeader(FacesContext context, DataTable table, UIColumn column) throws IOException {
        if (!column.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        String clientId = column.getContainerClientId(context);
        ValueExpression columnSortByVE = column.getValueExpression("sortBy");
        int priority = column.getPriority();
        boolean sortable = columnSortByVE != null;
        String sortIcon = null;
        String defaultStyleClass = sortable ? "ui-column-header ui-sortable-column" : "ui-column-header";
        String style = column.getStyle();
        String styleClass = column.getStyleClass();
        String string = styleClass = styleClass == null ? defaultStyleClass : defaultStyleClass + " " + styleClass;
        if (priority > 0) {
            styleClass = styleClass + " ui-table-priority-" + priority;
        }
        if (sortable) {
            boolean defaultSorted;
            ValueExpression tableSortByVE = table.getValueExpression("sortBy");
            boolean bl = defaultSorted = tableSortByVE != null;
            if (defaultSorted) {
                sortIcon = this.resolveDefaultSortIcon(table, column, table.getSortOrder());
            }
            if (sortIcon == null) {
                sortIcon = "ui-sortable-column-icon ui-icon-bars ui-btn-icon-notext ui-btn-right";
            } else {
                styleClass = styleClass + " " + "ui-column-sorted";
            }
        }
        writer.startElement("th", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("role", (Object)"columnheader", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (column.getRowspan() != 1) {
            writer.writeAttribute("rowspan", (Object)column.getRowspan(), null);
        }
        if (column.getColspan() != 1) {
            writer.writeAttribute("colspan", (Object)column.getColspan(), null);
        }
        this.encodeColumnHeaderContent(context, column, sortIcon);
        writer.endElement("th");
    }

    public void encodeColumnFooter(FacesContext context, DataTable table, UIColumn column) throws IOException {
        if (!column.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        String style = column.getStyle();
        String styleClass = column.getStyleClass();
        writer.startElement("td", null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
        if (column.getRowspan() != 1) {
            writer.writeAttribute("rowspan", (Object)column.getRowspan(), null);
        }
        if (column.getColspan() != 1) {
            writer.writeAttribute("colspan", (Object)column.getColspan(), null);
        }
        UIComponent facet = column.getFacet("footer");
        String text = column.getFooterText();
        if (facet != null) {
            facet.encodeAll(context);
        } else if (text != null) {
            writer.write(text);
        }
        writer.endElement("td");
    }

    public void encodeTbody(FacesContext context, DataTable table, boolean dataOnly, int columnStart, int columnEnd, String tbodyId) throws IOException {
        boolean hasData;
        String tbodyClientId;
        ResponseWriter writer = context.getResponseWriter();
        String rowIndexVar = table.getRowIndexVar();
        String clientId = table.getClientId(context);
        String emptyMessage = table.getEmptyMessage();
        UIComponent emptyFacet = table.getFacet("emptyMessage");
        String string = tbodyClientId = tbodyId == null ? clientId + "_data" : tbodyId;
        if (table.isSelectionEnabled()) {
            table.findSelectedRowKeys();
        }
        int rows = table.getRows();
        int first = table.getFirst();
        int rowCount = table.getRowCount();
        int rowCountToRender = rows == 0 ? rowCount : rows;
        boolean bl = hasData = rowCount > 0;
        if (!dataOnly) {
            writer.startElement("tbody", null);
            writer.writeAttribute("id", (Object)tbodyClientId, null);
        }
        if (hasData) {
            this.encodeRows(context, table, first, first + rowCountToRender, columnStart, columnEnd);
        } else {
            writer.startElement("tr", null);
            writer.writeAttribute("class", (Object)"ui-widget-content ui-datatable-empty-message", null);
            writer.startElement("td", null);
            writer.writeAttribute("colspan", (Object)table.getColumnsCount(), null);
            if (emptyFacet != null) {
                emptyFacet.encodeAll(context);
            } else {
                writer.write(emptyMessage);
            }
            writer.endElement("td");
            writer.endElement("tr");
        }
        if (!dataOnly) {
            writer.endElement("tbody");
        }
        table.setRowIndex(-1);
        if (rowIndexVar != null) {
            context.getExternalContext().getRequestMap().remove(rowIndexVar);
        }
    }

    protected void encodeRows(FacesContext context, DataTable table, int first, int last, int columnStart, int columnEnd) throws IOException {
        String clientId = table.getClientId(context);
        for (int i = first; i < last; ++i) {
            table.setRowIndex(i);
            if (!table.isRowAvailable()) break;
            this.encodeRow(context, table, clientId, i, columnStart, columnEnd);
        }
    }

    public boolean encodeRow(FacesContext context, DataTable table, String clientId, int rowIndex, int columnStart, int columnEnd) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        boolean selectionEnabled = table.isSelectionEnabled();
        Object rowKey = null;
        List<UIColumn> columns = table.getColumns();
        if (selectionEnabled && (rowKey = table.getRowKey()) == null) {
            rowKey = table.getRowKeyFromModel(table.getRowData());
        }
        boolean selected = table.getSelectedRowKeys().contains(rowKey);
        String userRowStyleClass = table.getRowStyleClass();
        String rowStyleClass = "ui-table-row";
        if (selectionEnabled && !table.isDisabledSelection()) {
            rowStyleClass = rowStyleClass + " " + "ui-datatable-selectable";
        }
        if (selected) {
            rowStyleClass = rowStyleClass + " ui-bar-b";
        }
        if (userRowStyleClass != null) {
            rowStyleClass = rowStyleClass + " " + userRowStyleClass;
        }
        writer.startElement("tr", null);
        writer.writeAttribute("data-ri", (Object)rowIndex, null);
        if (rowKey != null) {
            writer.writeAttribute("data-rk", rowKey, null);
        }
        writer.writeAttribute("class", (Object)rowStyleClass, null);
        for (int i = columnStart; i < columnEnd; ++i) {
            UIColumn column = columns.get(i);
            if (column instanceof Column) {
                this.encodeCell(context, table, column, clientId, false);
                continue;
            }
            if (!(column instanceof DynamicColumn)) continue;
            DynamicColumn dynamicColumn = (DynamicColumn)column;
            dynamicColumn.applyModel();
            this.encodeCell(context, table, dynamicColumn, null, false);
        }
        writer.endElement("tr");
        return true;
    }

    protected void encodeCell(FacesContext context, DataTable table, UIColumn column, String clientId, boolean selected) throws IOException {
        if (!column.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        String style = column.getStyle();
        String styleClass = column.getStyleClass();
        int colspan = column.getColspan();
        int rowspan = column.getRowspan();
        int priority = column.getPriority();
        if (priority > 0) {
            styleClass = styleClass == null ? "ui-table-priority-" + priority : styleClass + " ui-table-priority-" + priority;
        }
        writer.startElement("td", null);
        writer.writeAttribute("role", (Object)"gridcell", null);
        if (colspan != 1) {
            writer.writeAttribute("colspan", (Object)colspan, null);
        }
        if (rowspan != 1) {
            writer.writeAttribute("rowspan", (Object)rowspan, null);
        }
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
        if (table.isReflow()) {
            writer.startElement("b", (UIComponent)table);
            writer.writeAttribute("class", (Object)"ui-table-cell-label", null);
            String headerText = column.getHeaderText();
            if (!ComponentUtils.isValueBlank(headerText)) {
                writer.writeText((Object)headerText, null);
            }
            writer.endElement("b");
        }
        column.renderChildren(context);
        writer.endElement("td");
    }

    protected String resolveDefaultSortIcon(DataTable table, UIColumn column, String sortOrder) {
        ValueExpression tableSortByVE = table.getValueExpression("sortBy");
        ValueExpression columnSortByVE = column.getValueExpression("sortBy");
        String columnSortByExpression = columnSortByVE.getExpressionString();
        String tableSortByExpression = tableSortByVE.getExpressionString();
        String field = column.getField();
        String sortField = table.getSortField();
        String sortIcon = null;
        if (sortField != null && field != null && sortField.equals(field) || tableSortByExpression != null && tableSortByExpression.equals(columnSortByExpression)) {
            if (sortOrder.equalsIgnoreCase("ASCENDING")) {
                sortIcon = "ui-sortable-column-icon ui-icon-arrow-u ui-btn-icon-notext ui-btn-right";
            } else if (sortOrder.equalsIgnoreCase("DESCENDING")) {
                sortIcon = "ui-sortable-column-icon ui-icon-arrow-d ui-btn-icon-notext ui-btn-right";
            }
        }
        return sortIcon;
    }

    private PaginatorRenderer getPaginatorRenderer(FacesContext context) {
        return (PaginatorRenderer)context.getRenderKit().getRenderer("org.primefaces.component", "org.primefaces.component.PaginatorRenderer");
    }
}

