/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.mobile.renderkit;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.commandbutton.CommandButton;
import org.primefaces.util.HTML;

public class CommandButtonRenderer
extends org.primefaces.component.commandbutton.CommandButtonRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        CommandButton button = (CommandButton)component;
        String clientId = button.getClientId(context);
        Object value = button.getValue();
        String type = button.getType();
        String request = type.equals("reset") || type.equals("button") ? null : this.buildRequest(context, button, clientId);
        String onclick = this.buildDomEvent(context, (UIComponent)button, "onclick", "click", "action", request);
        writer.startElement("button", (UIComponent)button);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("class", (Object)button.resolveMobileStyleClass(), null);
        if (onclick != null) {
            if (button.requiresConfirmation()) {
                writer.writeAttribute("data-pfconfirmcommand", (Object)onclick, null);
                writer.writeAttribute("onclick", (Object)button.getConfirmationScript(), "onclick");
            } else {
                writer.writeAttribute("onclick", (Object)onclick, "onclick");
            }
        }
        this.renderPassThruAttributes(context, (UIComponent)button, HTML.BUTTON_ATTRS, HTML.CLICK_EVENT);
        if (button.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", "disabled");
        }
        if (button.isReadonly()) {
            writer.writeAttribute("readonly", (Object)"readonly", "readonly");
        }
        if (value == null) {
            writer.write("ui-button");
        } else if (button.isEscape()) {
            writer.writeText(value, "value");
        } else {
            writer.write(value.toString());
        }
        writer.endElement("button");
    }
}

