/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.mobile.component.uiswitch;

import java.io.IOException;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.mobile.component.uiswitch.UISwitch;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.WidgetBuilder;

public class UISwitchRenderer
extends CoreRenderer {
    private static final Logger logger = Logger.getLogger(UISwitchRenderer.class.getName());

    public void decode(FacesContext context, UIComponent component) {
        UISwitch uiswitch = (UISwitch)component;
        if (uiswitch.isDisabled()) {
            return;
        }
        String clientId = uiswitch.getClientId(context);
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(clientId + "_input");
        if (submittedValue != null && this.isChecked(submittedValue)) {
            uiswitch.setSubmittedValue(true);
        } else {
            uiswitch.setSubmittedValue(false);
        }
    }

    protected boolean isChecked(String value) {
        return value.equalsIgnoreCase("on") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("true");
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        UISwitch uiswitch = (UISwitch)component;
        this.encodeMarkup(context, uiswitch);
        this.encodeScript(context, uiswitch);
        logger.info("Mobile only switch component is deprecated, use p:inputSwitch instead.");
    }

    public void encodeMarkup(FacesContext context, UISwitch uiswitch) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = uiswitch.getClientId(context);
        boolean checked = Boolean.valueOf(ComponentUtils.getValueToRender(context, (UIComponent)uiswitch));
        String inputId = clientId + "_input";
        String onLabel = uiswitch.getOnLabel();
        String offLabel = uiswitch.getOffLabel();
        String style = uiswitch.getStyle();
        String styleClass = uiswitch.getStyleClass();
        styleClass = styleClass == null ? UISwitch.CONTAINER_CLASS : UISwitch.CONTAINER_CLASS + " " + styleClass;
        writer.startElement("div", (UIComponent)uiswitch);
        writer.writeAttribute("id", (Object)clientId, "id");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        writer.startElement("span", (UIComponent)uiswitch);
        writer.writeAttribute("class", (Object)UISwitch.ON_CLASS, null);
        writer.writeText((Object)onLabel, null);
        writer.endElement("span");
        writer.startElement("span", (UIComponent)uiswitch);
        writer.writeAttribute("class", (Object)UISwitch.OFF_CLASS, null);
        writer.writeText((Object)offLabel, null);
        writer.endElement("span");
        writer.startElement("input", (UIComponent)uiswitch);
        writer.writeAttribute("id", (Object)inputId, "id");
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("data-role", (Object)"none", null);
        writer.writeAttribute("type", (Object)"checkbox", null);
        writer.writeAttribute("class", (Object)UISwitch.INPUT_CLASS, null);
        if (checked) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        if (uiswitch.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        this.renderOnchange(context, (UIComponent)uiswitch);
        writer.endElement("input");
        writer.endElement("div");
    }

    public void encodeScript(FacesContext context, UISwitch uiswitch) throws IOException {
        String clientId = uiswitch.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("UISwitch", uiswitch.resolveWidgetVar(), clientId).finish();
    }
}

