/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.expression;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import org.primefaces.expression.ClientIdSearchExpressionResolver;
import org.primefaces.expression.ComponentNotFoundException;
import org.primefaces.expression.MultiSearchExpressionResolver;
import org.primefaces.expression.SearchExpressionResolver;
import org.primefaces.expression.SearchExpressionResolverFactory;
import org.primefaces.util.ComponentTraversalUtils;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.SharedStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchExpressionFacade {
    private static final Logger LOG = Logger.getLogger(SearchExpressionFacade.class.getName());
    private static final String SHARED_EXPRESSION_BUFFER_KEY = SearchExpressionFacade.class.getName() + ".SHARED_EXPRESSION_BUFFER";
    private static final String SHARED_SPLIT_BUFFER_KEY = SearchExpressionFacade.class.getName() + ".SHARED_SPLIT_BUFFER_KEY";
    private static final String SHARED_CLIENT_ID_EXPRESSION_BUFFER_KEY = SearchExpressionFacade.class.getName() + ".SHARED_CLIENT_ID_EXPRESSION_BUFFER_KEY";
    private static final char[] EXPRESSION_SEPARATORS = new char[]{',', ' '};

    public static List<UIComponent> resolveComponents(FacesContext context, UIComponent source, String expressions) {
        return SearchExpressionFacade.resolveComponents(context, source, expressions, 0);
    }

    public static List<UIComponent> resolveComponents(FacesContext context, UIComponent source, String expressions, int options) {
        String[] splittedExpressions;
        ArrayList<UIComponent> components = new ArrayList<UIComponent>();
        if (!ComponentUtils.isValueBlank(expressions) && (splittedExpressions = SearchExpressionFacade.splitExpressions(context, source, expressions)) != null && splittedExpressions.length > 0) {
            char separatorChar = UINamingContainer.getSeparatorChar((FacesContext)context);
            String separatorString = String.valueOf(separatorChar);
            for (String splittedExpression : splittedExpressions) {
                String expression = splittedExpression.trim();
                if (ComponentUtils.isValueBlank(expression)) continue;
                if (expression.contains("@") && expression.contains(separatorString)) {
                    components.addAll(SearchExpressionFacade.resolveComponentsByExpressionChain(context, source, expression, separatorChar, separatorString, options));
                    continue;
                }
                if (expression.contains("@")) {
                    SearchExpressionResolver resolver = SearchExpressionResolverFactory.findResolver(expression);
                    if (resolver instanceof MultiSearchExpressionResolver) {
                        ((MultiSearchExpressionResolver)((Object)resolver)).resolveComponents(context, source, source, expression, components);
                        continue;
                    }
                    UIComponent component = resolver.resolveComponent(context, source, source, expression);
                    if (component == null) {
                        if (SearchExpressionFacade.isOptionSet(options, 2)) continue;
                        SearchExpressionFacade.cannotFindComponent(context, source, expression);
                        continue;
                    }
                    components.add(component);
                    continue;
                }
                UIComponent component = SearchExpressionFacade.resolveComponentById(source, expression, separatorString, context, options);
                if (component == null) {
                    if (SearchExpressionFacade.isOptionSet(options, 2)) continue;
                    SearchExpressionFacade.cannotFindComponent(context, source, expression);
                    continue;
                }
                components.add(component);
            }
        }
        return components;
    }

    public static String resolveClientIds(FacesContext context, UIComponent source, String expressions) {
        return SearchExpressionFacade.resolveClientIds(context, source, expressions, 0);
    }

    public static String resolveClientIds(FacesContext context, UIComponent source, String expressions, int options) {
        if (ComponentUtils.isValueBlank(expressions)) {
            if (SearchExpressionFacade.isOptionSet(options, 3)) {
                return source.getParent().getClientId(context);
            }
            return null;
        }
        String[] splittedExpressions = SearchExpressionFacade.splitExpressions(context, source, expressions);
        if (splittedExpressions != null && splittedExpressions.length > 0) {
            char separatorChar = UINamingContainer.getSeparatorChar((FacesContext)context);
            String separatorString = String.valueOf(separatorChar);
            StringBuilder expressionsBuffer = SharedStringBuilder.get(context, SHARED_EXPRESSION_BUFFER_KEY);
            for (int i = 0; i < splittedExpressions.length; ++i) {
                String expression = splittedExpressions[i].trim();
                if (ComponentUtils.isValueBlank(expression)) continue;
                SearchExpressionFacade.validateExpression(context, source, expression, separatorChar, separatorString);
                if (SearchExpressionFacade.isPassTroughExpression(expression)) {
                    if (expressionsBuffer.length() > 0) {
                        expressionsBuffer.append(" ");
                    }
                    expressionsBuffer.append(expression);
                    continue;
                }
                if (expression.contains("@") && expression.contains(separatorString)) {
                    String clientIds = SearchExpressionFacade.resolveClientIdsByExpressionChain(context, source, expression, separatorChar, separatorString, options);
                    if (ComponentUtils.isValueBlank(clientIds)) continue;
                    if (expressionsBuffer.length() > 0) {
                        expressionsBuffer.append(" ");
                    }
                    expressionsBuffer.append(clientIds);
                    continue;
                }
                if (expression.contains("@")) {
                    SearchExpressionResolver resolver = SearchExpressionResolverFactory.findResolver(expression);
                    if (resolver instanceof ClientIdSearchExpressionResolver) {
                        String clientIds = ((ClientIdSearchExpressionResolver)((Object)resolver)).resolveClientIds(context, source, source, expression);
                        if (ComponentUtils.isValueBlank(clientIds)) continue;
                        if (expressionsBuffer.length() > 0) {
                            expressionsBuffer.append(" ");
                        }
                        expressionsBuffer.append(clientIds);
                        continue;
                    }
                    if (resolver instanceof MultiSearchExpressionResolver) {
                        ArrayList<UIComponent> result = new ArrayList<UIComponent>();
                        ((MultiSearchExpressionResolver)((Object)resolver)).resolveComponents(context, source, source, expression, result);
                        for (int j = 0; j < result.size(); ++j) {
                            UIComponent component = result.get(j);
                            SearchExpressionFacade.validateRenderer(context, source, component, expression, options);
                            if (expressionsBuffer.length() > 0) {
                                expressionsBuffer.append(" ");
                            }
                            expressionsBuffer.append(component.getClientId());
                        }
                        continue;
                    }
                    UIComponent component = resolver.resolveComponent(context, source, source, expression);
                    if (component == null) {
                        if (SearchExpressionFacade.isOptionSet(options, 2)) continue;
                        SearchExpressionFacade.cannotFindComponent(context, source, expression);
                        continue;
                    }
                    SearchExpressionFacade.validateRenderer(context, source, component, expression, options);
                    if (expressionsBuffer.length() > 0) {
                        expressionsBuffer.append(" ");
                    }
                    expressionsBuffer.append(component.getClientId(context));
                    continue;
                }
                UIComponent component = SearchExpressionFacade.resolveComponentById(source, expression, separatorString, context, options);
                if (component == null) {
                    if (SearchExpressionFacade.isOptionSet(options, 2)) continue;
                    SearchExpressionFacade.cannotFindComponent(context, source, expression);
                    continue;
                }
                SearchExpressionFacade.validateRenderer(context, source, component, expression, options);
                if (expressionsBuffer.length() > 0) {
                    expressionsBuffer.append(" ");
                }
                expressionsBuffer.append(component.getClientId(context));
            }
            String clientIds = expressionsBuffer.toString();
            if (!ComponentUtils.isValueBlank(clientIds)) {
                return clientIds;
            }
        }
        return null;
    }

    protected static void validateRenderer(FacesContext context, UIComponent source, UIComponent component, String expression, int options) {
        if (SearchExpressionFacade.isOptionSet(options, 1) && context.isProjectStage(ProjectStage.Development) && ComponentUtils.isValueBlank(component.getRendererType())) {
            LOG.warning("Can not update component \"" + component.getClass().getName() + "\" with id \"" + component.getClientId(context) + "\" without a attached renderer. Expression \"" + expression + "\" referenced from \"" + source.getClientId(context) + "\"");
        }
    }

    public static String resolveClientId(FacesContext context, UIComponent source, String expression) {
        return SearchExpressionFacade.resolveClientId(context, source, expression, 0);
    }

    public static String resolveClientId(FacesContext context, UIComponent source, String expression, int options) {
        UIComponent component;
        if (ComponentUtils.isValueBlank(expression)) {
            return null;
        }
        char separatorChar = UINamingContainer.getSeparatorChar((FacesContext)context);
        String separatorString = String.valueOf(separatorChar);
        expression = expression.trim();
        SearchExpressionFacade.validateExpression(context, source, expression, separatorChar, separatorString);
        if (SearchExpressionFacade.isPassTroughExpression(expression)) {
            return expression;
        }
        if (expression.contains("@") && expression.contains(separatorString)) {
            component = SearchExpressionFacade.resolveComponentByExpressionChain(context, source, expression, separatorChar, separatorString, options);
        } else if (expression.contains("@")) {
            SearchExpressionResolver resolver = SearchExpressionResolverFactory.findResolver(expression);
            if (resolver instanceof ClientIdSearchExpressionResolver) {
                return ((ClientIdSearchExpressionResolver)((Object)resolver)).resolveClientIds(context, source, source, expression);
            }
            component = resolver.resolveComponent(context, source, source, expression);
        } else {
            component = SearchExpressionFacade.resolveComponentById(source, expression, separatorString, context, options);
        }
        if (component == null) {
            if (SearchExpressionFacade.isOptionSet(options, 2)) {
                return null;
            }
            SearchExpressionFacade.cannotFindComponent(context, source, expression);
        }
        SearchExpressionFacade.validateRenderer(context, source, component, expression, options);
        return component.getClientId(context);
    }

    public static UIComponent resolveComponent(FacesContext context, UIComponent source, String expression) {
        return SearchExpressionFacade.resolveComponent(context, source, expression, 0);
    }

    public static UIComponent resolveComponent(FacesContext context, UIComponent source, String expression, int options) {
        UIComponent component;
        if (ComponentUtils.isValueBlank(expression)) {
            if (SearchExpressionFacade.isOptionSet(options, 3)) {
                return source.getParent();
            }
            return null;
        }
        char separatorChar = UINamingContainer.getSeparatorChar((FacesContext)context);
        String separatorString = String.valueOf(separatorChar);
        expression = expression.trim();
        SearchExpressionFacade.validateExpression(context, source, expression, separatorChar, separatorString);
        if (expression.equals("@none")) {
            return null;
        }
        if (ComponentUtils.isValueBlank(expression)) {
            return null;
        }
        if (expression.contains("@") && expression.contains(separatorString)) {
            component = SearchExpressionFacade.resolveComponentByExpressionChain(context, source, expression, separatorChar, separatorString, options);
        } else if (expression.contains("@")) {
            SearchExpressionResolver resolver = SearchExpressionResolverFactory.findResolver(expression);
            component = resolver.resolveComponent(context, source, source, expression);
        } else {
            component = SearchExpressionFacade.resolveComponentById(source, expression, separatorString, context, options);
        }
        if (component == null && !SearchExpressionFacade.isOptionSet(options, 2)) {
            SearchExpressionFacade.cannotFindComponent(context, source, expression);
        }
        return component;
    }

    private static UIComponent resolveComponentByExpressionChain(FacesContext context, UIComponent source, String expression, char separatorChar, String separatorString, int options) {
        boolean startsWithSeperator;
        boolean bl = startsWithSeperator = expression.charAt(0) == separatorChar;
        if (startsWithSeperator) {
            expression = expression.substring(1);
        }
        UIComponent last = source;
        String[] subExpressions = SearchExpressionFacade.split(context, expression, separatorChar);
        if (subExpressions != null && subExpressions.length > 0) {
            for (int j = 0; j < subExpressions.length; ++j) {
                SearchExpressionResolver resolver;
                UIComponent temp;
                String subExpression = subExpressions[j].trim();
                if (ComponentUtils.isValueBlank(subExpression)) continue;
                if (startsWithSeperator && j == 0 && !subExpression.contains("@")) {
                    subExpression = separatorString + subExpression;
                }
                if ((temp = (resolver = SearchExpressionResolverFactory.findResolver(subExpression)).resolveComponent(context, source, last, subExpression)) == null) {
                    if (!SearchExpressionFacade.isOptionSet(options, 2)) {
                        throw new FacesException("Cannot find component for subexpression \"" + subExpression + "\" from component with id \"" + last.getClientId(context) + "\" in full expression \"" + expression + "\" referenced from \"" + source.getClientId(context) + "\".");
                    }
                    return null;
                }
                last = temp;
            }
        }
        return last;
    }

    private static UIComponent resolveComponentById(UIComponent source, String expression, String separatorString, FacesContext context, int options) {
        UIComponent component = ComponentTraversalUtils.firstById(expression, source, separatorString, context, SearchExpressionFacade.isOptionSet(options, 2));
        if (component == null && !SearchExpressionFacade.isOptionSet(options, 2)) {
            SearchExpressionFacade.cannotFindComponent(context, source, expression);
        }
        return component;
    }

    private static ArrayList<UIComponent> resolveComponentsByExpressionChain(FacesContext context, UIComponent source, String expression, char separatorChar, String separatorString, int options) {
        boolean startsWithSeperator;
        boolean bl = startsWithSeperator = expression.charAt(0) == separatorChar;
        if (startsWithSeperator) {
            expression = expression.substring(1);
        }
        ArrayList<UIComponent> lastComponents = new ArrayList<UIComponent>();
        lastComponents.add(source);
        String[] subExpressions = SearchExpressionFacade.split(context, expression, separatorChar);
        if (subExpressions != null && subExpressions.length > 0) {
            ArrayList<UIComponent> tempComponents = new ArrayList<UIComponent>();
            for (int i = 0; i < subExpressions.length; ++i) {
                String subExpression = subExpressions[i].trim();
                if (ComponentUtils.isValueBlank(subExpression)) continue;
                if (startsWithSeperator && i == 0 && !subExpression.contains("@")) {
                    subExpression = separatorString + subExpression;
                }
                SearchExpressionResolver resolver = SearchExpressionResolverFactory.findResolver(subExpression);
                tempComponents.clear();
                for (int j = 0; j < lastComponents.size(); ++j) {
                    UIComponent last = lastComponents.get(j);
                    if (resolver instanceof MultiSearchExpressionResolver) {
                        ((MultiSearchExpressionResolver)((Object)resolver)).resolveComponents(context, source, last, subExpression, tempComponents);
                        continue;
                    }
                    UIComponent temp = resolver.resolveComponent(context, source, last, subExpression);
                    if (temp == null) {
                        if (SearchExpressionFacade.isOptionSet(options, 2)) continue;
                        throw new FacesException("Cannot find component for subexpression \"" + subExpression + "\" from component with id \"" + last.getClientId(context) + "\" in full expression \"" + expression + "\" referenced from \"" + source.getClientId(context) + "\".");
                    }
                    tempComponents.add(temp);
                }
                lastComponents.clear();
                lastComponents.addAll(tempComponents);
                tempComponents.clear();
            }
        }
        return lastComponents;
    }

    private static String resolveClientIdsByExpressionChain(FacesContext context, UIComponent source, String expression, char separatorChar, String separatorString, int options) {
        boolean startsWithSeperator;
        boolean bl = startsWithSeperator = expression.charAt(0) == separatorChar;
        if (startsWithSeperator) {
            expression = expression.substring(1);
        }
        ArrayList<UIComponent> lastComponents = new ArrayList<UIComponent>();
        lastComponents.add(source);
        StringBuilder clientIdsBuilder = null;
        String[] subExpressions = SearchExpressionFacade.split(context, expression, separatorChar);
        if (subExpressions != null && subExpressions.length > 0) {
            ArrayList<UIComponent> tempComponents = new ArrayList<UIComponent>();
            for (int i = 0; i < subExpressions.length; ++i) {
                String subExpression = subExpressions[i].trim();
                if (ComponentUtils.isValueBlank(subExpression)) continue;
                if (startsWithSeperator && i == 0 && !subExpression.contains("@")) {
                    subExpression = separatorString + subExpression;
                }
                SearchExpressionResolver resolver = SearchExpressionResolverFactory.findResolver(subExpression);
                tempComponents.clear();
                for (int j = 0; j < lastComponents.size(); ++j) {
                    UIComponent last = (UIComponent)lastComponents.get(j);
                    if (i == subExpressions.length - 1 && resolver instanceof ClientIdSearchExpressionResolver) {
                        String result = ((ClientIdSearchExpressionResolver)((Object)resolver)).resolveClientIds(context, source, last, subExpression);
                        if (ComponentUtils.isValueBlank(result)) continue;
                        if (clientIdsBuilder == null) {
                            clientIdsBuilder = SharedStringBuilder.get(SHARED_CLIENT_ID_EXPRESSION_BUFFER_KEY);
                        } else if (clientIdsBuilder.length() > 0) {
                            clientIdsBuilder.append(" ");
                        }
                        clientIdsBuilder.append(result);
                        continue;
                    }
                    if (resolver instanceof MultiSearchExpressionResolver) {
                        ((MultiSearchExpressionResolver)((Object)resolver)).resolveComponents(context, source, last, subExpression, tempComponents);
                        continue;
                    }
                    UIComponent temp = resolver.resolveComponent(context, source, last, subExpression);
                    if (temp == null) {
                        if (SearchExpressionFacade.isOptionSet(options, 2)) continue;
                        throw new FacesException("Cannot find component for subexpression \"" + subExpression + "\" from component with id \"" + last.getClientId(context) + "\" in full expression \"" + expression + "\" referenced from \"" + source.getClientId(context) + "\".");
                    }
                    tempComponents.add(temp);
                }
                lastComponents.clear();
                lastComponents.addAll(tempComponents);
                tempComponents.clear();
            }
        }
        if (clientIdsBuilder == null) {
            clientIdsBuilder = SharedStringBuilder.get(SHARED_CLIENT_ID_EXPRESSION_BUFFER_KEY);
            for (int i = 0; i < lastComponents.size(); ++i) {
                UIComponent result = (UIComponent)lastComponents.get(i);
                if (clientIdsBuilder.length() > 0) {
                    clientIdsBuilder.append(" ");
                }
                clientIdsBuilder.append(result.getClientId(context));
            }
        }
        return clientIdsBuilder.toString();
    }

    protected static void cannotFindComponent(FacesContext context, UIComponent source, String expression) {
        throw new ComponentNotFoundException("Cannot find component for expression \"" + expression + "\" referenced from \"" + source.getClientId(context) + "\".");
    }

    protected static String[] splitExpressions(FacesContext context, UIComponent source, String expressions) {
        String[] splittedExpressions = SearchExpressionFacade.split(context, expressions, EXPRESSION_SEPARATORS);
        if (splittedExpressions != null) {
            SearchExpressionFacade.validateExpressions(context, source, expressions, splittedExpressions);
        }
        return splittedExpressions;
    }

    protected static void validateExpression(FacesContext context, UIComponent source, String expression, char separatorChar, String separatorString) {
        if (context.isProjectStage(ProjectStage.Development)) {
            if (expression.startsWith(separatorString + "@")) {
                throw new FacesException("A expression should not start with the separater char and a keyword. Expression: \"" + expression + "\" referenced from \"" + source.getClientId(context) + "\"");
            }
            String[] subExpressions = SearchExpressionFacade.split(context, expression, separatorChar);
            if (subExpressions != null && subExpressions.length > 1) {
                for (String subExpression : subExpressions) {
                    if (SearchExpressionFacade.isNestable(subExpression = subExpression.trim())) continue;
                    throw new FacesException("Subexpression \"" + subExpression + "\" in full expression \"" + expression + "\" from \"" + source.getClientId(context) + "\" can not be nested.");
                }
            }
        }
    }

    protected static void validateExpressions(FacesContext context, UIComponent source, String expressions, String[] splittedExpressions) {
        if (context.isProjectStage(ProjectStage.Development) && splittedExpressions.length > 1 && (expressions.contains("@none") || expressions.contains("@all"))) {
            throw new FacesException("It's not possible to use @none or @all combined with other expressions. Expressions: \"" + expressions + "\" referenced from \"" + source.getClientId(context) + "\"");
        }
    }

    protected static String[] split(FacesContext context, String value, char ... separators) {
        char[] charArray;
        if (value == null) {
            return null;
        }
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder buffer = SharedStringBuilder.get(context, SHARED_SPLIT_BUFFER_KEY);
        int parenthesesCounter = 0;
        for (char c : charArray = value.toCharArray()) {
            if (c == '(') {
                ++parenthesesCounter;
            }
            if (c == ')') {
                --parenthesesCounter;
            }
            if (parenthesesCounter == 0) {
                boolean isSeparator = false;
                for (char separator : separators) {
                    if (c != separator) continue;
                    isSeparator = true;
                }
                if (isSeparator) {
                    tokens.add(buffer.toString());
                    buffer.delete(0, buffer.length());
                    continue;
                }
                buffer.append(c);
                continue;
            }
            buffer.append(c);
        }
        tokens.add(buffer.toString());
        return tokens.toArray(new String[tokens.size()]);
    }

    protected static boolean isPassTroughExpression(String expression) {
        return expression.contains("@(");
    }

    protected static boolean isNestable(String expression) {
        return !expression.contains("@all") && !expression.contains("@none") && !expression.contains("@(");
    }

    protected static boolean isOptionSet(int options, int option) {
        return (options & option) != 0;
    }

    public class Options {
        public static final int NONE = 0;
        public static final int VALIDATE_RENDERER = 1;
        public static final int IGNORE_NO_RESULT = 2;
        public static final int PARENT_FALLBACK = 3;
    }
}

