/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.context;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.NamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import javax.faces.context.ResponseWriter;
import javax.faces.event.AbortProcessingException;
import org.primefaces.context.RequestContext;
import org.primefaces.json.JSONArray;
import org.primefaces.json.JSONException;
import org.primefaces.json.JSONObject;
import org.primefaces.util.ComponentUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimePartialResponseWriter
extends PartialResponseWriter {
    private static final Map<String, String> CALLBACK_EXTENSION_PARAMS = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put("ln", "primefaces");
            this.put("type", "args");
        }
    });
    private final PartialResponseWriter wrapped;

    public PrimePartialResponseWriter(PartialResponseWriter wrapped) {
        super((ResponseWriter)wrapped);
        this.wrapped = wrapped;
    }

    public void encodeJSONObject(String paramName, JSONObject jsonObject) throws IOException, JSONException {
        String json = jsonObject.toString();
        json = ComponentUtils.escapeXml(json);
        this.getWrapped().write("\"");
        this.getWrapped().write(paramName);
        this.getWrapped().write("\":");
        this.getWrapped().write(json);
    }

    public void encodeJSONArray(String paramName, JSONArray jsonArray) throws IOException, JSONException {
        String json = jsonArray.toString();
        json = ComponentUtils.escapeXml(json);
        this.getWrapped().write("\"");
        this.getWrapped().write(paramName);
        this.getWrapped().write("\":");
        this.getWrapped().write(json);
    }

    public void encodeJSONValue(String paramName, Object paramValue) throws IOException, JSONException {
        String json = new JSONObject().put(paramName, paramValue).toString();
        json = ComponentUtils.escapeXml(json);
        this.getWrapped().write(json.substring(1, json.length() - 1));
    }

    public void encodeCallbackParams(Map<String, Object> params) throws IOException, JSONException {
        if (params != null && !params.isEmpty()) {
            this.startExtension(CALLBACK_EXTENSION_PARAMS);
            this.getWrapped().write("{");
            Iterator<String> it = params.keySet().iterator();
            while (it.hasNext()) {
                String paramName = it.next();
                Object paramValue = params.get(paramName);
                if (paramValue instanceof JSONObject) {
                    this.encodeJSONObject(paramName, (JSONObject)paramValue);
                } else if (paramValue instanceof JSONArray) {
                    this.encodeJSONArray(paramName, (JSONArray)paramValue);
                } else if (this.isBean(paramValue)) {
                    this.encodeJSONObject(paramName, (JSONObject)paramValue);
                } else {
                    this.encodeJSONValue(paramName, paramValue);
                }
                if (!it.hasNext()) continue;
                this.getWrapped().write(",");
            }
            this.getWrapped().write("}");
            this.endExtension();
        }
    }

    public void encodeScripts(RequestContext requestContext) throws IOException {
        List<String> scripts = requestContext.getScriptsToExecute();
        if (!scripts.isEmpty()) {
            this.startEval();
            for (int i = 0; i < scripts.size(); ++i) {
                this.getWrapped().write(scripts.get(i));
                this.getWrapped().write(59);
            }
            this.endEval();
        }
    }

    public void delete(String targetId) throws IOException {
        this.wrapped.delete(targetId);
    }

    public void endError() throws IOException {
        this.wrapped.endError();
    }

    public void endEval() throws IOException {
        this.wrapped.endEval();
    }

    public void endExtension() throws IOException {
        this.wrapped.endExtension();
    }

    public void endInsert() throws IOException {
        this.wrapped.endInsert();
    }

    public void endUpdate() throws IOException {
        this.wrapped.endUpdate();
    }

    public void redirect(String url) throws IOException {
        this.wrapped.redirect(url);
    }

    public void startDocument() throws IOException {
        this.wrapped.startDocument();
        RequestContext requestContext = RequestContext.getCurrentInstance();
        if (requestContext != null) {
            try {
                FacesContext context = FacesContext.getCurrentInstance();
                if (context.getViewRoot() instanceof NamingContainer) {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("parameterNamespace", context.getViewRoot().getContainerClientId(context));
                    this.encodeCallbackParams(params);
                }
            }
            catch (Exception e) {
                throw new AbortProcessingException((Throwable)e);
            }
        }
    }

    public void endDocument() throws IOException {
        RequestContext requestContext = RequestContext.getCurrentInstance();
        if (requestContext != null) {
            try {
                FacesContext context = FacesContext.getCurrentInstance();
                if (context.isValidationFailed()) {
                    requestContext.addCallbackParam("validationFailed", true);
                }
                this.encodeCallbackParams(requestContext.getCallbackParams());
                this.encodeScripts(requestContext);
            }
            catch (Exception exception) {
                throw new AbortProcessingException((Throwable)exception);
            }
        }
        this.wrapped.endDocument();
    }

    public void startError(String errorName) throws IOException {
        this.wrapped.startError(errorName);
    }

    public void startEval() throws IOException {
        this.wrapped.startEval();
    }

    public void startExtension(Map<String, String> attributes) throws IOException {
        this.wrapped.startExtension(attributes);
    }

    public void startInsertAfter(String targetId) throws IOException {
        this.wrapped.startInsertAfter(targetId);
    }

    public void startInsertBefore(String targetId) throws IOException {
        this.wrapped.startInsertBefore(targetId);
    }

    public void startUpdate(String targetId) throws IOException {
        this.wrapped.startUpdate(targetId);
    }

    public void updateAttributes(String targetId, Map<String, String> attributes) throws IOException {
        this.wrapped.updateAttributes(targetId, attributes);
    }

    private boolean isBean(Object value) {
        if (value == null) {
            return false;
        }
        return !(value instanceof Boolean) && !(value instanceof String) && !(value instanceof Number);
    }
}

