/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.treetable;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.el.MethodExpression;
import javax.faces.FacesException;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.api.UITree;
import org.primefaces.component.api.Widget;
import org.primefaces.component.column.Column;
import org.primefaces.component.columngroup.ColumnGroup;
import org.primefaces.component.columns.Columns;
import org.primefaces.event.ColumnResizeEvent;
import org.primefaces.event.NodeCollapseEvent;
import org.primefaces.event.NodeExpandEvent;
import org.primefaces.event.NodeSelectEvent;
import org.primefaces.event.NodeUnselectEvent;
import org.primefaces.model.TreeNode;
import org.primefaces.util.ComponentUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="primefaces.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="primefaces.js")})
public class TreeTable
extends UITree
implements Widget,
ClientBehaviorHolder {
    public static final String COMPONENT_TYPE = "org.primefaces.component.TreeTable";
    public static final String COMPONENT_FAMILY = "org.primefaces.component";
    private static final String DEFAULT_RENDERER = "org.primefaces.component.TreeTableRenderer";
    public static final String CONTAINER_CLASS = "ui-treetable ui-widget";
    public static final String RESIZABLE_CONTAINER_CLASS = "ui-treetable ui-treetable-resizable ui-widget";
    public static final String HEADER_CLASS = "ui-treetable-header ui-widget-header ui-corner-top";
    public static final String DATA_CLASS = "ui-treetable-data ui-widget-content";
    public static final String FOOTER_CLASS = "ui-treetable-footer ui-widget-header ui-corner-bottom";
    public static final String COLUMN_HEADER_CLASS = "ui-state-default";
    public static final String SORTABLE_COLUMN_HEADER_CLASS = "ui-state-default ui-sortable-column";
    public static final String ROW_CLASS = "ui-widget-content";
    public static final String SELECTED_ROW_CLASS = "ui-widget-content ui-state-highlight ui-selected";
    public static final String COLUMN_CONTENT_WRAPPER = "ui-tt-c";
    public static final String EXPAND_ICON = "ui-treetable-toggler ui-icon ui-icon-triangle-1-e ui-c";
    public static final String COLLAPSE_ICON = "ui-treetable-toggler ui-icon ui-icon-triangle-1-s ui-c";
    public static final String SCROLLABLE_CONTAINER_CLASS = "ui-treetable-scrollable";
    public static final String SCROLLABLE_HEADER_CLASS = "ui-widget-header ui-treetable-scrollable-header";
    public static final String SCROLLABLE_HEADER_BOX_CLASS = "ui-treetable-scrollable-header-box";
    public static final String SCROLLABLE_BODY_CLASS = "ui-treetable-scrollable-body";
    public static final String SCROLLABLE_FOOTER_CLASS = "ui-widget-header ui-treetable-scrollable-footer";
    public static final String SCROLLABLE_FOOTER_BOX_CLASS = "ui-treetable-scrollable-footer-box";
    public static final String SELECTABLE_NODE_CLASS = "ui-treetable-selectable-node";
    public static final String RESIZABLE_COLUMN_CLASS = "ui-resizable-column";
    public static final String INDENT_CLASS = "ui-treetable-indent";
    public static final String EMPTY_MESSAGE_ROW_CLASS = "ui-widget-content ui-treetable-empty-message";
    public static final String PARTIAL_SELECTED_CLASS = "ui-treetable-partialselected";
    public static final String SORTABLE_COLUMN_ICON_CLASS = "ui-sortable-column-icon ui-icon ui-icon-carat-2-n-s";
    public static final String SORTABLE_COLUMN_ASCENDING_ICON_CLASS = "ui-sortable-column-icon ui-icon ui-icon ui-icon-carat-2-n-s ui-icon-triangle-1-n";
    public static final String SORTABLE_COLUMN_DESCENDING_ICON_CLASS = "ui-sortable-column-icon ui-icon ui-icon ui-icon-carat-2-n-s ui-icon-triangle-1-s";
    public static final String REFLOW_CLASS = "ui-treetable-reflow";
    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList("select", "unselect", "expand", "collapse", "colResize"));
    private List<String> selectedRowKeys = new ArrayList<String>();
    private int columnsCount = -1;
    private UIColumn sortColumn;
    private List<UIColumn> columns;
    private Columns dynamicColumns;

    public TreeTable() {
        this.setRendererType(DEFAULT_RENDERER);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getWidgetVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.widgetVar), null);
    }

    public void setWidgetVar(String _widgetVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.widgetVar), (Object)_widgetVar);
    }

    public String getStyle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.style), null);
    }

    public void setStyle(String _style) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.style), (Object)_style);
    }

    public String getStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.styleClass), null);
    }

    public void setStyleClass(String _styleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.styleClass), (Object)_styleClass);
    }

    public boolean isScrollable() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.scrollable), (Object)false);
    }

    public void setScrollable(boolean _scrollable) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.scrollable), (Object)_scrollable);
    }

    public String getScrollHeight() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.scrollHeight), null);
    }

    public void setScrollHeight(String _scrollHeight) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.scrollHeight), (Object)_scrollHeight);
    }

    public String getScrollWidth() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.scrollWidth), null);
    }

    public void setScrollWidth(String _scrollWidth) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.scrollWidth), (Object)_scrollWidth);
    }

    public String getTableStyle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.tableStyle), null);
    }

    public void setTableStyle(String _tableStyle) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.tableStyle), (Object)_tableStyle);
    }

    public String getTableStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.tableStyleClass), null);
    }

    public void setTableStyleClass(String _tableStyleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.tableStyleClass), (Object)_tableStyleClass);
    }

    public String getEmptyMessage() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.emptyMessage), (Object)"No records found.");
    }

    public void setEmptyMessage(String _emptyMessage) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.emptyMessage), (Object)_emptyMessage);
    }

    public boolean isResizableColumns() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.resizableColumns), (Object)false);
    }

    public void setResizableColumns(boolean _resizableColumns) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.resizableColumns), (Object)_resizableColumns);
    }

    public String getRowStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.rowStyleClass), null);
    }

    public void setRowStyleClass(String _rowStyleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.rowStyleClass), (Object)_rowStyleClass);
    }

    public boolean isLiveResize() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.liveResize), (Object)false);
    }

    public void setLiveResize(boolean _liveResize) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.liveResize), (Object)_liveResize);
    }

    public Object getSortBy() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.sortBy), null);
    }

    public void setSortBy(Object _sortBy) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.sortBy), _sortBy);
    }

    public String getSortOrder() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.sortOrder), (Object)"ascending");
    }

    public void setSortOrder(String _sortOrder) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.sortOrder), (Object)_sortOrder);
    }

    public MethodExpression getSortFunction() {
        return (MethodExpression)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.sortFunction), null);
    }

    public void setSortFunction(MethodExpression _sortFunction) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.sortFunction), (Object)_sortFunction);
    }

    public boolean isNativeElements() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.nativeElements), (Object)false);
    }

    public void setNativeElements(boolean _nativeElements) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.nativeElements), (Object)_nativeElements);
    }

    public Object getDataLocale() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.dataLocale), null);
    }

    public void setDataLocale(Object _dataLocale) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.dataLocale), _dataLocale);
    }

    public boolean isCaseSensitiveSort() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.caseSensitiveSort), (Object)false);
    }

    public void setCaseSensitiveSort(boolean _caseSensitiveSort) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.caseSensitiveSort), (Object)_caseSensitiveSort);
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    private boolean isRequestSource(FacesContext context) {
        return this.getClientId(context).equals(context.getExternalContext().getRequestParameterMap().get("javax.faces.source"));
    }

    public boolean isSelectionRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_instantSelection");
    }

    public boolean isSortRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_sorting");
    }

    @Override
    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        if (this.isRequestSource(context) && event instanceof AjaxBehaviorEvent) {
            Map params = context.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("javax.faces.behavior.event");
            String clientId = this.getClientId(context);
            AjaxBehaviorEvent wrapperEvent = null;
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            if (eventName.equals("expand")) {
                String nodeKey = (String)params.get(clientId + "_expand");
                this.setRowKey(nodeKey);
                TreeNode node = this.getRowNode();
                wrapperEvent = new NodeExpandEvent((UIComponent)this, behaviorEvent.getBehavior(), node);
                wrapperEvent.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else if (eventName.equals("collapse")) {
                String nodeKey = (String)params.get(clientId + "_collapse");
                this.setRowKey(nodeKey);
                TreeNode node = this.getRowNode();
                node.setExpanded(false);
                wrapperEvent = new NodeCollapseEvent((UIComponent)this, behaviorEvent.getBehavior(), node);
                wrapperEvent.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else if (eventName.equals("select")) {
                String nodeKey = (String)params.get(clientId + "_instantSelection");
                this.setRowKey(nodeKey);
                TreeNode node = this.getRowNode();
                wrapperEvent = new NodeSelectEvent((UIComponent)this, behaviorEvent.getBehavior(), node);
                wrapperEvent.setPhaseId(behaviorEvent.getPhaseId());
            } else if (eventName.equals("unselect")) {
                String nodeKey = (String)params.get(clientId + "_instantUnselection");
                this.setRowKey(nodeKey);
                TreeNode node = this.getRowNode();
                wrapperEvent = new NodeUnselectEvent((UIComponent)this, behaviorEvent.getBehavior(), node);
                wrapperEvent.setPhaseId(behaviorEvent.getPhaseId());
            } else if (eventName.equals("colResize")) {
                String columnId = (String)params.get(clientId + "_columnId");
                int width = Integer.parseInt((String)params.get(clientId + "_width"));
                int height = Integer.parseInt((String)params.get(clientId + "_height"));
                wrapperEvent = new ColumnResizeEvent((UIComponent)this, behaviorEvent.getBehavior(), width, height, this.findColumn(columnId));
            }
            super.queueEvent((FacesEvent)wrapperEvent);
        } else {
            super.queueEvent(event);
        }
    }

    @Override
    public void processDecodes(FacesContext context) {
        if (this.isToggleRequest(context)) {
            this.decode(context);
        } else {
            super.processDecodes(context);
        }
    }

    public UIColumn findColumn(String clientId) {
        for (UIColumn column : this.getColumns()) {
            if (!column.getColumnKey().equals(clientId)) continue;
            return column;
        }
        FacesContext context = this.getFacesContext();
        ColumnGroup headerGroup = this.getColumnGroup("header");
        for (UIComponent row : headerGroup.getChildren()) {
            for (UIComponent col : row.getChildren()) {
                if (!col.getClientId(context).equals(clientId)) continue;
                return (UIColumn)col;
            }
        }
        throw new FacesException("Cannot find column with key: " + clientId);
    }

    public boolean hasFooterColumn() {
        for (UIComponent child : this.getChildren()) {
            Column column;
            if (!(child instanceof Column) || !child.isRendered() || (column = (Column)child).getFacet("footer") == null && column.getFooterText() == null) continue;
            return true;
        }
        return false;
    }

    private boolean isToggleRequest(FacesContext context) {
        String clientId;
        Map params = context.getExternalContext().getRequestParameterMap();
        return params.get((clientId = this.getClientId(context)) + "_expand") != null || params.get(clientId + "_collapse") != null;
    }

    public boolean isResizeRequest(FacesContext context) {
        String clientId;
        Map params = context.getExternalContext().getRequestParameterMap();
        return params.get((clientId = this.getClientId(context)) + "_colResize") != null;
    }

    public int getColumnsCount() {
        if (this.columnsCount == -1) {
            this.columnsCount = 0;
            for (UIComponent kid : this.getChildren()) {
                if (!kid.isRendered() || !(kid instanceof Column)) continue;
                ++this.columnsCount;
            }
        }
        return this.columnsCount;
    }

    public String getScrollState() {
        String name;
        Map params = this.getFacesContext().getExternalContext().getRequestParameterMap();
        String value = (String)params.get(name = this.getClientId() + "_scrollState");
        return value == null ? "0,0" : value;
    }

    public boolean isCheckboxSelection() {
        String selectionMode = this.getSelectionMode();
        return selectionMode != null && selectionMode.equals("checkbox");
    }

    public void setSortColumn(UIColumn column) {
        this.sortColumn = column;
    }

    public UIColumn getSortColumn() {
        return this.sortColumn;
    }

    public void clearDefaultSorted() {
        this.getStateHelper().remove((Serializable)((Object)"defaultSorted"));
    }

    public void setDefaultSorted() {
        this.getStateHelper().put((Serializable)((Object)"defaultSorted"), (Object)"defaultSorted");
    }

    public boolean isDefaultSorted() {
        return this.getStateHelper().get((Serializable)((Object)"defaultSorted")) != null;
    }

    public Locale resolveDataLocale() {
        FacesContext context = this.getFacesContext();
        Object userLocale = this.getDataLocale();
        if (userLocale != null) {
            if (userLocale instanceof String) {
                return ComponentUtils.toLocale((String)userLocale);
            }
            if (userLocale instanceof Locale) {
                return (Locale)userLocale;
            }
            throw new IllegalArgumentException("Type:" + userLocale.getClass() + " is not a valid locale type for datatable:" + this.getClientId(context));
        }
        return context.getViewRoot().getLocale();
    }

    public ColumnGroup getColumnGroup(String target) {
        for (UIComponent child : this.getChildren()) {
            ColumnGroup colGroup;
            String type;
            if (!(child instanceof ColumnGroup) || (type = (colGroup = (ColumnGroup)child).getType()) == null || !type.equals(target)) continue;
            return colGroup;
        }
        return null;
    }

    public List<UIColumn> getColumns() {
        if (this.columns == null) {
            this.columns = new ArrayList<UIColumn>();
            FacesContext context = this.getFacesContext();
            char separator = UINamingContainer.getSeparatorChar((FacesContext)context);
            for (UIComponent child : this.getChildren()) {
                if (child instanceof Column) {
                    this.columns.add((UIColumn)child);
                    continue;
                }
                if (!(child instanceof Columns)) continue;
                Columns uiColumns = (Columns)child;
                String uiColumnsClientId = uiColumns.getClientId(context);
                for (int i = 0; i < uiColumns.getRowCount(); ++i) {
                    DynamicColumn dynaColumn = new DynamicColumn(i, uiColumns);
                    dynaColumn.setColumnKey(uiColumnsClientId + separator + i);
                    this.columns.add(dynaColumn);
                }
            }
        }
        return this.columns;
    }

    public void setDynamicColumns(Columns value) {
        this.dynamicColumns = value;
    }

    public Columns getDynamicColumns() {
        return this.dynamicColumns;
    }

    public Object saveState(FacesContext context) {
        if (this.dynamicColumns != null) {
            this.dynamicColumns.setRowIndex(-1);
        }
        return super.saveState(context);
    }

    @Override
    public String resolveWidgetVar() {
        FacesContext context = this.getFacesContext();
        String userWidgetVar = (String)this.getAttributes().get("widgetVar");
        if (userWidgetVar != null) {
            return userWidgetVar;
        }
        return "widget_" + this.getClientId(context).replaceAll("-|" + UINamingContainer.getSeparatorChar((FacesContext)context), "_");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum PropertyKeys {
        widgetVar,
        style,
        styleClass,
        scrollable,
        scrollHeight,
        scrollWidth,
        tableStyle,
        tableStyleClass,
        emptyMessage,
        resizableColumns,
        rowStyleClass,
        liveResize,
        sortBy,
        sortOrder,
        sortFunction,
        nativeElements,
        dataLocale,
        caseSensitiveSort;

        String toString;

        private PropertyKeys(String toString) {
            this.toString = toString;
        }

        private PropertyKeys() {
        }

        public String toString() {
            return this.toString != null ? this.toString : super.toString();
        }
    }
}

