/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.signature;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.signature.Signature;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class SignatureRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        Signature signature = (Signature)component;
        Map params = context.getExternalContext().getRequestParameterMap();
        String value = (String)params.get(signature.getClientId(context) + "_value");
        signature.setSubmittedValue(value);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Signature signature = (Signature)component;
        this.encodeMarkup(facesContext, signature);
        this.encodeScript(facesContext, signature);
    }

    protected void encodeMarkup(FacesContext context, Signature signature) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = signature.getClientId(context);
        String style = signature.getStyle();
        String styleClass = signature.getStyleClass();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
        this.encodeInputField(context, signature);
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, Signature signature) throws IOException {
        String clientId = signature.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.initWithDomReady("Signature", signature.resolveWidgetVar(), clientId, "signature").attr("background", signature.getBackgroundColor(), null).attr("color", signature.getColor(), null).attr("thickness", signature.getThickness(), 2).attr("disabled", signature.isReadonly(), false).attr("guideline", signature.isGuideline(), false).attr("guidelineColor", signature.getGuidelineColor(), null).attr("guidelineOffset", signature.getGuidelineOffset(), 25).attr("guidelineIndent", signature.getGuidelineIndent(), 10).callback("change", "function()", signature.getOnchange());
        wb.finish();
    }

    protected void encodeInputField(FacesContext context, Signature signature) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String inputId = signature.getClientId(context) + "_value";
        Object value = signature.getValue();
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)inputId, null);
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        if (value != null) {
            writer.writeAttribute("value", value, null);
        }
        writer.endElement("input");
    }
}

