/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.multiselectlistbox;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UISelectOne;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.primefaces.component.multiselectlistbox.MultiSelectListbox;
import org.primefaces.renderkit.SelectOneRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.WidgetBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiSelectListboxRenderer
extends SelectOneRenderer {
    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        return context.getRenderKit().getRenderer("javax.faces.SelectOne", "javax.faces.Listbox").getConvertedValue(context, component, submittedValue);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        MultiSelectListbox listbox = (MultiSelectListbox)component;
        this.encodeMarkup(context, listbox);
        this.encodeScript(context, listbox);
    }

    protected void encodeMarkup(FacesContext context, MultiSelectListbox listbox) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = listbox.getClientId(context);
        List<SelectItem> selectItems = this.getSelectItems(context, (UIInput)listbox);
        String style = listbox.getStyle();
        String styleClass = listbox.getStyleClass();
        styleClass = styleClass == null ? MultiSelectListbox.CONTAINER_CLASS : MultiSelectListbox.CONTAINER_CLASS + " " + styleClass;
        styleClass = listbox.isDisabled() ? styleClass + " ui-state-disabled" : styleClass;
        styleClass = !listbox.isValid() ? styleClass + " ui-state-error" : styleClass;
        writer.startElement("div", (UIComponent)listbox);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        this.encodeInput(context, listbox);
        this.encodeLists(context, listbox, selectItems);
        writer.endElement("div");
    }

    protected void encodeLists(FacesContext context, MultiSelectListbox listbox, List<SelectItem> itemList) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        SelectItem[] items = itemList == null ? null : itemList.toArray(new SelectItem[itemList.size()]);
        String header = listbox.getHeader();
        String listStyleClass = MultiSelectListbox.LIST_CLASS;
        writer.startElement("div", (UIComponent)listbox);
        writer.writeAttribute("class", (Object)MultiSelectListbox.LIST_CONTAINER_CLASS, null);
        if (header != null) {
            listStyleClass = listStyleClass + " ui-corner-bottom";
            writer.startElement("div", (UIComponent)listbox);
            writer.writeAttribute("class", (Object)MultiSelectListbox.LIST_HEADER_CLASS, null);
            writer.writeText((Object)header, null);
            writer.endElement("div");
        } else {
            listStyleClass = listStyleClass + " ui-corner-all";
        }
        writer.startElement("ul", (UIComponent)listbox);
        writer.writeAttribute("class", (Object)listStyleClass, null);
        if (items != null) {
            this.encodeListItems(context, listbox, items);
        }
        writer.endElement("ul");
        writer.endElement("div");
    }

    protected void encodeListItems(FacesContext context, MultiSelectListbox listbox, SelectItem[] items) throws IOException {
        if (items != null && items.length > 0) {
            ResponseWriter writer = context.getResponseWriter();
            Converter converter = ComponentUtils.getConverter(context, (UIComponent)listbox);
            String itemValue = null;
            for (int i = 0; i < items.length; ++i) {
                SelectItemGroup group;
                SelectItem[] groupItems;
                SelectItem item = items[i];
                itemValue = converter != null ? converter.getAsString(context, (UIComponent)listbox, item.getValue()) : String.valueOf(item.getValue());
                writer.startElement("li", null);
                writer.writeAttribute("class", (Object)MultiSelectListbox.ITEM_CLASS, null);
                writer.writeAttribute("data-value", (Object)itemValue, null);
                writer.startElement("span", (UIComponent)listbox);
                writer.writeText((Object)item.getLabel(), null);
                writer.endElement("span");
                if (item instanceof SelectItemGroup && (groupItems = (group = (SelectItemGroup)item).getSelectItems()) != null && groupItems.length > 0) {
                    this.encodeGroupItems(context, listbox, group.getSelectItems());
                }
                writer.endElement("li");
            }
        }
    }

    protected void encodeGroupItems(FacesContext context, MultiSelectListbox listbox, SelectItem[] selectItems) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("ul", (UIComponent)listbox);
        writer.writeAttribute("class", (Object)"ui-helper-hidden", null);
        this.encodeListItems(context, listbox, selectItems);
        writer.endElement("ul");
    }

    protected void encodeScript(FacesContext context, MultiSelectListbox listbox) throws IOException {
        String clientId = listbox.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("MultiSelectListbox", listbox.resolveWidgetVar(), clientId).attr("effect", listbox.getEffect(), null).attr("showHeaders", listbox.isShowHeaders(), false).finish();
    }

    protected void encodeInput(FacesContext context, MultiSelectListbox listbox) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String inputId = listbox.getClientId(context) + "_input";
        String valueToRender = ComponentUtils.getValueToRender(context, (UIComponent)listbox);
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)inputId, null);
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        if (valueToRender != null) {
            writer.writeAttribute("value", (Object)valueToRender, null);
        }
        writer.endElement("input");
    }

    @Override
    protected String getSubmitParam(FacesContext context, UISelectOne selectOne) {
        return selectOne.getClientId(context) + "_input";
    }
}

