/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.gmap;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UINamingContainer;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.component.api.Widget;
import org.primefaces.component.gmap.GMapInfoWindow;
import org.primefaces.context.RequestContext;
import org.primefaces.event.map.GeocodeEvent;
import org.primefaces.event.map.MarkerDragEvent;
import org.primefaces.event.map.OverlaySelectEvent;
import org.primefaces.event.map.PointSelectEvent;
import org.primefaces.event.map.ReverseGeocodeEvent;
import org.primefaces.event.map.StateChangeEvent;
import org.primefaces.model.map.GeocodeResult;
import org.primefaces.model.map.LatLng;
import org.primefaces.model.map.LatLngBounds;
import org.primefaces.model.map.MapModel;
import org.primefaces.model.map.Marker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="primefaces.js"), @ResourceDependency(library="primefaces", name="gmap/gmap.js")})
public class GMap
extends UIComponentBase
implements Widget,
ClientBehaviorHolder {
    public static final String COMPONENT_TYPE = "org.primefaces.component.GMap";
    public static final String COMPONENT_FAMILY = "org.primefaces.component";
    private static final String DEFAULT_RENDERER = "org.primefaces.component.GMapRenderer";
    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList("overlaySelect", "stateChange", "pointSelect", "markerDrag", "geocode", "reverseGeocode"));

    public GMap() {
        this.setRendererType(DEFAULT_RENDERER);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getWidgetVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.widgetVar), null);
    }

    public void setWidgetVar(String _widgetVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.widgetVar), (Object)_widgetVar);
    }

    public MapModel getModel() {
        return (MapModel)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.model), null);
    }

    public void setModel(MapModel _model) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.model), (Object)_model);
    }

    public String getStyle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.style), null);
    }

    public void setStyle(String _style) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.style), (Object)_style);
    }

    public String getStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.styleClass), null);
    }

    public void setStyleClass(String _styleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.styleClass), (Object)_styleClass);
    }

    public String getType() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.type), null);
    }

    public void setType(String _type) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.type), (Object)_type);
    }

    public String getCenter() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.center), null);
    }

    public void setCenter(String _center) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.center), (Object)_center);
    }

    public int getZoom() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.zoom), (Object)8);
    }

    public void setZoom(int _zoom) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.zoom), (Object)_zoom);
    }

    public boolean isStreetView() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.streetView), (Object)false);
    }

    public void setStreetView(boolean _streetView) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.streetView), (Object)_streetView);
    }

    public boolean isDisableDefaultUI() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.disableDefaultUI), (Object)false);
    }

    public void setDisableDefaultUI(boolean _disableDefaultUI) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.disableDefaultUI), (Object)_disableDefaultUI);
    }

    public boolean isNavigationControl() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.navigationControl), (Object)true);
    }

    public void setNavigationControl(boolean _navigationControl) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.navigationControl), (Object)_navigationControl);
    }

    public boolean isMapTypeControl() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.mapTypeControl), (Object)true);
    }

    public void setMapTypeControl(boolean _mapTypeControl) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.mapTypeControl), (Object)_mapTypeControl);
    }

    public boolean isDraggable() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.draggable), (Object)true);
    }

    public void setDraggable(boolean _draggable) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.draggable), (Object)_draggable);
    }

    public boolean isDisableDoubleClickZoom() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.disableDoubleClickZoom), (Object)false);
    }

    public void setDisableDoubleClickZoom(boolean _disableDoubleClickZoom) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.disableDoubleClickZoom), (Object)_disableDoubleClickZoom);
    }

    public String getOnPointClick() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onPointClick), null);
    }

    public void setOnPointClick(String _onPointClick) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onPointClick), (Object)_onPointClick);
    }

    public boolean isFitBounds() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.fitBounds), (Object)false);
    }

    public void setFitBounds(boolean _fitBounds) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.fitBounds), (Object)_fitBounds);
    }

    public boolean isScrollWheel() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.scrollWheel), (Object)true);
    }

    public void setScrollWheel(boolean _scrollWheel) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.scrollWheel), (Object)_scrollWheel);
    }

    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        Map params = context.getExternalContext().getRequestParameterMap();
        String eventName = (String)params.get("javax.faces.behavior.event");
        String clientId = this.getClientId(context);
        if (this.isSelfRequest(context)) {
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            AjaxBehaviorEvent wrapperEvent = null;
            if (eventName.equals("overlaySelect")) {
                wrapperEvent = new OverlaySelectEvent((UIComponent)this, behaviorEvent.getBehavior(), this.getModel().findOverlay((String)params.get(clientId + "_overlayId")));
                GMapInfoWindow infoWindow = this.getInfoWindow();
                if (infoWindow != null) {
                    RequestContext.getCurrentInstance().update(infoWindow.getClientId(context));
                }
            } else if (eventName.equals("stateChange")) {
                String[] centerLoc = ((String)params.get(clientId + "_center")).split(",");
                String[] northeastLoc = ((String)params.get(clientId + "_northeast")).split(",");
                String[] southwestLoc = ((String)params.get(clientId + "_southwest")).split(",");
                int zoomLevel = Integer.valueOf((String)params.get(clientId + "_zoom"));
                LatLng center = new LatLng(Double.valueOf(centerLoc[0]), Double.valueOf(centerLoc[1]));
                LatLng northeast = new LatLng(Double.valueOf(northeastLoc[0]), Double.valueOf(northeastLoc[1]));
                LatLng southwest = new LatLng(Double.valueOf(southwestLoc[0]), Double.valueOf(southwestLoc[1]));
                wrapperEvent = new StateChangeEvent((UIComponent)this, behaviorEvent.getBehavior(), new LatLngBounds(northeast, southwest), zoomLevel, center);
            } else if (eventName.equals("pointSelect")) {
                String[] latlng = ((String)params.get(clientId + "_pointLatLng")).split(",");
                LatLng position = new LatLng(Double.valueOf(latlng[0]), Double.valueOf(latlng[1]));
                wrapperEvent = new PointSelectEvent((UIComponent)this, behaviorEvent.getBehavior(), position);
            } else if (eventName.equals("markerDrag")) {
                Marker marker = (Marker)this.getModel().findOverlay((String)params.get(clientId + "_markerId"));
                double lat = Double.valueOf((String)params.get(clientId + "_lat"));
                double lng = Double.valueOf((String)params.get(clientId + "_lng"));
                marker.setLatlng(new LatLng(lat, lng));
                wrapperEvent = new MarkerDragEvent((UIComponent)this, behaviorEvent.getBehavior(), marker);
            } else if (eventName.equals("geocode")) {
                ArrayList<GeocodeResult> results = new ArrayList<GeocodeResult>();
                String query = (String)params.get(clientId + "_query");
                String[] addresses = ((String)params.get(clientId + "_addresses")).split("_primefaces_");
                String[] lats = ((String)params.get(clientId + "_lat")).split(",");
                String[] lngs = ((String)params.get(clientId + "_lng")).split(",");
                for (int i = 0; i < addresses.length; ++i) {
                    results.add(new GeocodeResult(addresses[i], new LatLng(Double.valueOf(lats[i]), Double.valueOf(lngs[i]))));
                }
                wrapperEvent = new GeocodeEvent((UIComponent)this, behaviorEvent.getBehavior(), query, results);
            } else if (eventName.equals("reverseGeocode")) {
                ArrayList<String> addresses = new ArrayList<String>();
                String[] results = ((String)params.get(clientId + "_address")).split("_primefaces_");
                for (int i = 0; i < results.length; ++i) {
                    addresses.add(results[i]);
                }
                double lat = Double.valueOf((String)params.get(clientId + "_lat"));
                double lng = Double.valueOf((String)params.get(clientId + "_lng"));
                LatLng coord = new LatLng(lat, lng);
                wrapperEvent = new ReverseGeocodeEvent((UIComponent)this, behaviorEvent.getBehavior(), coord, addresses);
            }
            wrapperEvent.setPhaseId(behaviorEvent.getPhaseId());
            super.queueEvent((FacesEvent)wrapperEvent);
        } else {
            super.queueEvent(event);
        }
    }

    public GMapInfoWindow getInfoWindow() {
        for (UIComponent kid : this.getChildren()) {
            if (!(kid instanceof GMapInfoWindow)) continue;
            return (GMapInfoWindow)kid;
        }
        return null;
    }

    private boolean isSelfRequest(FacesContext context) {
        return this.getClientId(context).equals(context.getExternalContext().getRequestParameterMap().get("javax.faces.source"));
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    @Override
    public String resolveWidgetVar() {
        FacesContext context = this.getFacesContext();
        String userWidgetVar = (String)this.getAttributes().get("widgetVar");
        if (userWidgetVar != null) {
            return userWidgetVar;
        }
        return "widget_" + this.getClientId(context).replaceAll("-|" + UINamingContainer.getSeparatorChar((FacesContext)context), "_");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum PropertyKeys {
        widgetVar,
        model,
        style,
        styleClass,
        type,
        center,
        zoom,
        streetView,
        disableDefaultUI,
        navigationControl,
        mapTypeControl,
        draggable,
        disableDoubleClickZoom,
        onPointClick,
        fitBounds,
        scrollWheel;

        String toString;

        private PropertyKeys(String toString) {
            this.toString = toString;
        }

        private PropertyKeys() {
        }

        public String toString() {
            return this.toString != null ? this.toString : super.toString();
        }
    }
}

