/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.export;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import javax.el.MethodExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.export.Exporter;
import org.primefaces.util.XMLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLExporter
extends Exporter {
    @Override
    public void export(FacesContext context, DataTable table, String filename, boolean pageOnly, boolean selectionOnly, String encodingType, MethodExpression preProcessor, MethodExpression postProcessor) throws IOException {
        ExternalContext externalContext = context.getExternalContext();
        this.configureResponse(externalContext, filename);
        OutputStream os = externalContext.getResponseOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter(os, encodingType);
        PrintWriter writer = new PrintWriter(osw);
        writer.write("<?xml version=\"1.0\"?>\n");
        writer.write("<" + table.getId() + ">\n");
        if (pageOnly) {
            this.exportPageOnly(context, table, writer);
        } else if (selectionOnly) {
            this.exportSelectionOnly(context, table, writer);
        } else {
            this.exportAll(context, table, writer);
        }
        writer.write("</" + table.getId() + ">");
        table.setRowIndex(-1);
        writer.flush();
        writer.close();
        externalContext.responseFlushBuffer();
    }

    @Override
    protected void preRowExport(DataTable table, Object document) {
        ((PrintWriter)document).write("\t<" + table.getVar() + ">\n");
    }

    @Override
    protected void postRowExport(DataTable table, Object document) {
        ((PrintWriter)document).write("\t</" + table.getVar() + ">\n");
    }

    @Override
    protected void exportCells(DataTable table, Object document) {
        PrintWriter writer = (PrintWriter)document;
        for (UIColumn col : table.getColumns()) {
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyStatelessModel();
            }
            if (!col.isRendered() || !col.isExportable()) continue;
            String columnTag = this.getColumnTag(col);
            try {
                this.addColumnValue(writer, col.getChildren(), columnTag);
            }
            catch (IOException ex) {
                throw new FacesException((Throwable)ex);
            }
        }
    }

    protected String getColumnTag(UIColumn column) {
        String columnTag;
        String headerText = column.getHeaderText();
        UIComponent facet = column.getFacet("header");
        if (headerText != null) {
            columnTag = headerText.toLowerCase();
        } else if (facet != null) {
            columnTag = this.exportValue(FacesContext.getCurrentInstance(), facet).toLowerCase();
        } else {
            throw new FacesException("No suitable xml tag found for " + column);
        }
        return XMLUtils.escapeTag(columnTag);
    }

    protected void addColumnValue(Writer writer, List<UIComponent> components, String tag) throws IOException {
        FacesContext context = FacesContext.getCurrentInstance();
        writer.write("\t\t<" + tag + ">");
        for (UIComponent component : components) {
            if (!component.isRendered()) continue;
            String value = this.exportValue(context, component);
            writer.write(value);
        }
        writer.write("</" + tag + ">\n");
    }

    protected void configureResponse(ExternalContext externalContext, String filename) {
        externalContext.setResponseContentType("text/xml");
        externalContext.setResponseHeader("Expires", "0");
        externalContext.setResponseHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        externalContext.setResponseHeader("Pragma", "public");
        externalContext.setResponseHeader("Content-disposition", "attachment;filename=" + filename + ".xml");
        externalContext.addResponseCookie("primefaces.download", "true", Collections.emptyMap());
    }
}

