/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.export;

import javax.faces.FacesException;
import org.primefaces.component.export.CSVExporter;
import org.primefaces.component.export.ExcelExporter;
import org.primefaces.component.export.ExcelXExporter;
import org.primefaces.component.export.Exporter;
import org.primefaces.component.export.ExporterType;
import org.primefaces.component.export.PDFExporter;
import org.primefaces.component.export.XMLExporter;

public class ExporterFactory {
    public static Exporter getExporterForType(String type) {
        Exporter exporter = null;
        try {
            ExporterType exporterType = ExporterType.valueOf(type.toUpperCase());
            switch (exporterType) {
                case XLS: {
                    exporter = new ExcelExporter();
                    break;
                }
                case PDF: {
                    exporter = new PDFExporter();
                    break;
                }
                case CSV: {
                    exporter = new CSVExporter();
                    break;
                }
                case XML: {
                    exporter = new XMLExporter();
                    break;
                }
                case XLSX: {
                    exporter = new ExcelXExporter();
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new FacesException((Throwable)e);
        }
        return exporter;
    }
}

