/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.barcode;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.application.resource.DynamicContentType;
import org.primefaces.component.barcode.Barcode;
import org.primefaces.context.RequestContext;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.HTML;
import org.primefaces.util.SharedStringBuilder;
import org.primefaces.util.StringEncrypter;

public class BarcodeRenderer
extends CoreRenderer {
    private static final String SB_BUILD = BarcodeRenderer.class.getName() + "#build";

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        DynamicContentType dynamicContentType;
        ResponseWriter writer = context.getResponseWriter();
        Barcode barcode = (Barcode)component;
        String clientId = barcode.getClientId(context);
        String styleClass = barcode.getStyleClass();
        String src = null;
        Object value = barcode.getValue();
        String type = barcode.getType();
        DynamicContentType dynamicContentType2 = dynamicContentType = type.equals("qr") ? DynamicContentType.QR_CODE : DynamicContentType.BARCODE;
        if (value == null) {
            return;
        }
        try {
            Resource resource = context.getApplication().getResourceHandler().createResource("dynamiccontent.properties", "primefaces", "image/png");
            String resourcePath = resource.getRequestPath();
            StringEncrypter encrypter = RequestContext.getCurrentInstance().getEncrypter();
            String rid = encrypter.encrypt((String)value);
            StringBuilder builder = SharedStringBuilder.get(context, SB_BUILD);
            src = builder.append(resourcePath).append("&").append("pfdrid").append("=").append(URLEncoder.encode(rid, "UTF-8")).append("&").append("pfdrt").append("=").append(dynamicContentType.toString()).append("&gen=").append(type).append("&fmt=").append(barcode.getFormat()).append("&").append("pfdrid_c").append("=").append(barcode.isCache()).append("&ori=").append(barcode.getOrientation()).toString();
        }
        catch (UnsupportedEncodingException ex) {
            throw new IOException(ex);
        }
        writer.startElement("img", (UIComponent)barcode);
        if (this.shouldWriteId(component)) {
            writer.writeAttribute("id", (Object)clientId, "id");
        }
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        writer.writeAttribute("src", (Object)src, null);
        this.renderPassThruAttributes(context, (UIComponent)barcode, HTML.IMG_ATTRS);
        writer.endElement("img");
    }
}

