/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.autocomplete;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.event.PhaseId;
import org.primefaces.component.autocomplete.AutoComplete;
import org.primefaces.component.column.Column;
import org.primefaces.context.RequestContext;
import org.primefaces.event.AutoCompleteEvent;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.WidgetBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoCompleteRenderer
extends InputRenderer {
    private static final Logger LOG = Logger.getLogger(AutoCompleteRenderer.class.getName());

    public void decode(FacesContext context, UIComponent component) {
        AutoComplete ac = (AutoComplete)component;
        String clientId = ac.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        if (ac.isDisabled() || ac.isReadonly()) {
            return;
        }
        if (ac.isMultiple()) {
            this.decodeMultiple(context, ac);
        } else {
            this.decodeSingle(context, ac);
        }
        this.decodeBehaviors(context, (UIComponent)ac);
        String query = (String)params.get(clientId + "_query");
        if (query != null) {
            AutoCompleteEvent autoCompleteEvent = new AutoCompleteEvent((UIComponent)ac, query);
            autoCompleteEvent.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            ac.queueEvent(autoCompleteEvent);
        }
    }

    protected void decodeSingle(FacesContext context, AutoComplete ac) {
        Map params = context.getExternalContext().getRequestParameterMap();
        String clientId = ac.getClientId(context);
        String valueParam = ac.getVar() != null ? clientId + "_hinput" : clientId + "_input";
        String submittedValue = (String)params.get(valueParam);
        if (submittedValue != null) {
            ac.setSubmittedValue(submittedValue);
        }
    }

    protected void decodeMultiple(FacesContext context, AutoComplete ac) {
        String clientId;
        Map params = context.getExternalContext().getRequestParameterValuesMap();
        String[] submittedValues = (String[])params.get((clientId = ac.getClientId(context)) + "_hinput");
        if (submittedValues != null) {
            ac.setSubmittedValue(submittedValues);
        } else {
            ac.setSubmittedValue("");
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        AutoComplete autoComplete = (AutoComplete)component;
        Map params = context.getExternalContext().getRequestParameterMap();
        String query = (String)params.get(autoComplete.getClientId(context) + "_query");
        if (query != null) {
            this.encodeResults(context, component, query);
        } else {
            this.encodeMarkup(context, autoComplete);
            this.encodeScript(context, autoComplete);
        }
    }

    public void encodeResults(FacesContext context, UIComponent component, String query) throws IOException {
        AutoComplete ac = (AutoComplete)component;
        List results = ac.getSuggestions();
        int maxResults = ac.getMaxResults();
        if (maxResults != Integer.MAX_VALUE && results != null && results.size() > maxResults) {
            results = results.subList(0, ac.getMaxResults());
        }
        this.encodeSuggestions(context, ac, results);
    }

    protected void encodeMarkup(FacesContext context, AutoComplete ac) throws IOException {
        if (ac.isMultiple()) {
            this.encodeMultipleMarkup(context, ac);
        } else {
            this.encodeSingleMarkup(context, ac);
        }
    }

    protected void encodeSingleMarkup(FacesContext context, AutoComplete ac) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = ac.getClientId(context);
        String styleClass = ac.getStyleClass();
        styleClass = styleClass == null ? "ui-autocomplete" : "ui-autocomplete " + styleClass;
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (ac.getStyle() != null) {
            writer.writeAttribute("style", (Object)ac.getStyle(), null);
        }
        this.encodeInput(context, ac, clientId);
        if (ac.getVar() != null) {
            this.encodeHiddenInput(context, ac, clientId);
        }
        if (ac.isDropdown()) {
            this.encodeDropDown(context, ac);
        }
        this.encodePanel(context, ac);
        writer.endElement("span");
    }

    protected void encodeInput(FacesContext context, AutoComplete ac, String clientId) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        boolean disabled = ac.isDisabled();
        String var = ac.getVar();
        String defaultStyleClass = ac.isDropdown() ? "ui-autocomplete-input ui-inputfield ui-widget ui-state-default ui-corner-left" : "ui-autocomplete-input ui-inputfield ui-widget ui-state-default ui-corner-all";
        String styleClass = disabled ? defaultStyleClass + " ui-state-disabled" : defaultStyleClass;
        styleClass = ac.isValid() ? styleClass : styleClass + " ui-state-error";
        String inputStyle = ac.getInputStyle();
        String inputStyleClass = ac.getInputStyleClass();
        inputStyleClass = inputStyleClass == null ? styleClass : styleClass + " " + inputStyleClass;
        String labelledBy = ac.getLabelledBy();
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)(clientId + "_input"), null);
        writer.writeAttribute("name", (Object)(clientId + "_input"), null);
        writer.writeAttribute("type", (Object)ac.getType(), null);
        writer.writeAttribute("class", (Object)inputStyleClass, null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        if (labelledBy != null) {
            writer.writeAttribute("aria-labelledby", (Object)labelledBy, null);
        }
        if (inputStyle != null) {
            writer.writeAttribute("style", (Object)inputStyle, null);
        }
        this.renderPassThruAttributes(context, (UIComponent)ac, HTML.INPUT_TEXT_ATTRS_WITHOUT_EVENTS);
        this.renderDomEvents(context, (UIComponent)ac, HTML.INPUT_TEXT_EVENTS);
        if (var == null) {
            String itemLabel = ComponentUtils.getValueToRender(context, (UIComponent)ac);
            if (itemLabel != null) {
                writer.writeAttribute("value", (Object)itemLabel, null);
            }
        } else {
            String itemLabel;
            Map requestMap = context.getExternalContext().getRequestMap();
            if (ac.isValid()) {
                requestMap.put(var, ac.getValue());
                itemLabel = ac.getItemLabel();
            } else {
                Object submittedValue = ac.getSubmittedValue();
                itemLabel = submittedValue == null ? null : String.valueOf(submittedValue);
                Object value = ac.getValue();
                if (itemLabel == null && value != null) {
                    requestMap.put(var, value);
                    itemLabel = ac.getItemLabel();
                }
            }
            if (itemLabel != null) {
                writer.writeAttribute("value", (Object)itemLabel, null);
            }
            requestMap.remove(var);
        }
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (ac.isReadonly()) {
            writer.writeAttribute("readonly", (Object)"readonly", null);
        }
        if (ac.isRequired()) {
            writer.writeAttribute("aria-required", (Object)"true", null);
        }
        if (RequestContext.getCurrentInstance().getApplicationContext().getConfig().isClientSideValidationEnabled()) {
            this.renderValidationMetadata(context, (EditableValueHolder)ac);
        }
        writer.endElement("input");
    }

    protected void encodeHiddenInput(FacesContext context, AutoComplete ac, String clientId) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String valueToRender = ComponentUtils.getValueToRender(context, (UIComponent)ac);
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)(clientId + "_hinput"), null);
        writer.writeAttribute("name", (Object)(clientId + "_hinput"), null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        if (valueToRender != null) {
            writer.writeAttribute("value", (Object)valueToRender, null);
        }
        writer.endElement("input");
    }

    protected void encodeHiddenSelect(FacesContext context, AutoComplete ac, String clientId, List<String> values) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String id = clientId + "_hinput";
        writer.startElement("select", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.writeAttribute("multiple", (Object)"multiple", null);
        writer.writeAttribute("class", (Object)"ui-helper-hidden", null);
        if (ac.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", "disabled");
        }
        for (String value : values) {
            writer.startElement("option", null);
            writer.writeAttribute("value", (Object)value, null);
            writer.writeAttribute("selected", (Object)"selected", null);
            writer.endElement("option");
        }
        writer.endElement("select");
    }

    protected void encodeDropDown(FacesContext context, AutoComplete ac) throws IOException {
        boolean disabled;
        ResponseWriter writer = context.getResponseWriter();
        String dropdownClass = "ui-autocomplete-dropdown ui-button ui-widget ui-state-default ui-corner-right ui-button-icon-only";
        boolean bl = disabled = ac.isDisabled() || ac.isReadonly();
        if (disabled) {
            dropdownClass = dropdownClass + " ui-state-disabled";
        }
        writer.startElement("button", (UIComponent)ac);
        writer.writeAttribute("class", (Object)dropdownClass, null);
        writer.writeAttribute("type", (Object)"button", null);
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (ac.getTabindex() != null) {
            writer.writeAttribute("tabindex", (Object)ac.getTabindex(), null);
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-icon-primary ui-icon ui-icon-triangle-1-s", null);
        writer.endElement("span");
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text", null);
        writer.write("&nbsp;");
        writer.endElement("span");
        writer.endElement("button");
    }

    protected void encodePanel(FacesContext context, AutoComplete ac) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String styleClass = ac.getPanelStyleClass();
        styleClass = styleClass == null ? "ui-autocomplete-panel ui-widget-content ui-corner-all ui-helper-hidden ui-shadow" : "ui-autocomplete-panel ui-widget-content ui-corner-all ui-helper-hidden ui-shadow " + styleClass;
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(ac.getClientId(context) + "_panel"), null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (ac.getPanelStyle() != null) {
            writer.writeAttribute("style", (Object)ac.getPanelStyle(), null);
        }
        writer.endElement("div");
    }

    protected void encodeMultipleMarkup(FacesContext context, AutoComplete ac) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = ac.getClientId(context);
        String inputId = clientId + "_input";
        List values = (List)ac.getValue();
        ArrayList<String> stringValues = new ArrayList<String>();
        boolean disabled = ac.isDisabled();
        String styleClass = ac.getStyleClass();
        styleClass = styleClass == null ? "ui-autocomplete ui-autocomplete-multiple" : "ui-autocomplete ui-autocomplete-multiple " + styleClass;
        String listClass = disabled ? "ui-autocomplete-multiple-container ui-widget ui-inputfield ui-state-default ui-corner-all ui-state-disabled" : "ui-autocomplete-multiple-container ui-widget ui-inputfield ui-state-default ui-corner-all";
        listClass = ac.isValid() ? listClass : listClass + " ui-state-error";
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (ac.getStyle() != null) {
            writer.writeAttribute("style", (Object)ac.getStyle(), null);
        }
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)listClass, null);
        if (values != null && !values.isEmpty()) {
            Converter converter = ComponentUtils.getConverter(context, (UIComponent)ac);
            String var = ac.getVar();
            boolean pojo = var != null;
            for (Object value : values) {
                Object itemValue = null;
                String itemLabel = null;
                if (pojo) {
                    context.getExternalContext().getRequestMap().put(var, value);
                    itemValue = ac.getItemValue();
                    itemLabel = ac.getItemLabel();
                } else {
                    itemValue = value;
                    itemLabel = String.valueOf(value);
                }
                String tokenValue = converter != null ? converter.getAsString(context, (UIComponent)ac, itemValue) : String.valueOf(itemValue);
                writer.startElement("li", null);
                writer.writeAttribute("data-token-value", (Object)tokenValue, null);
                writer.writeAttribute("class", (Object)"ui-autocomplete-token ui-state-active ui-corner-all", null);
                writer.startElement("span", null);
                writer.writeAttribute("class", (Object)"ui-autocomplete-token-label", null);
                writer.writeText((Object)itemLabel, null);
                writer.endElement("span");
                writer.startElement("span", null);
                writer.writeAttribute("class", (Object)"ui-autocomplete-token-icon ui-icon ui-icon-close", null);
                writer.endElement("span");
                writer.endElement("li");
                stringValues.add(tokenValue);
            }
        }
        writer.startElement("li", null);
        writer.writeAttribute("class", (Object)"ui-autocomplete-input-token", null);
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"text", null);
        writer.writeAttribute("id", (Object)inputId, null);
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", "disabled");
        }
        this.renderPassThruAttributes(context, (UIComponent)ac, HTML.INPUT_TEXT_ATTRS_WITHOUT_EVENTS);
        this.renderDomEvents(context, (UIComponent)ac, HTML.INPUT_TEXT_EVENTS);
        writer.endElement("input");
        writer.endElement("li");
        writer.endElement("ul");
        if (ac.isDropdown()) {
            this.encodeDropDown(context, ac);
        }
        this.encodePanel(context, ac);
        this.encodeHiddenSelect(context, ac, clientId, stringValues);
        writer.endElement("div");
    }

    protected void encodeSuggestions(FacesContext context, AutoComplete ac, List items) throws IOException {
        boolean customContent = ac.getColums().size() > 0;
        Converter converter = ComponentUtils.getConverter(context, (UIComponent)ac);
        if (customContent) {
            this.encodeSuggestionsAsTable(context, ac, items, converter);
        } else {
            this.encodeSuggestionsAsList(context, ac, items, converter);
        }
    }

    protected void encodeSuggestionsAsTable(FacesContext context, AutoComplete ac, List items, Converter converter) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String var = ac.getVar();
        Map requestMap = context.getExternalContext().getRequestMap();
        boolean pojo = var != null;
        UIComponent itemtip = ac.getFacet("itemtip");
        boolean hasHeader = false;
        boolean hasGroupByTooltip = ac.getValueExpression("groupByTooltip") != null;
        for (Column column : ac.getColums()) {
            if (!column.isRendered() || column.getHeaderText() == null && column.getFacet("header") == null) continue;
            hasHeader = true;
            break;
        }
        writer.startElement("table", (UIComponent)ac);
        writer.writeAttribute("class", (Object)"ui-autocomplete-items ui-autocomplete-table ui-widget-content ui-widget ui-corner-all ui-helper-reset", null);
        if (hasHeader) {
            writer.startElement("thead", (UIComponent)ac);
            for (Column column : ac.getColums()) {
                if (!column.isRendered()) continue;
                String headerText = column.getHeaderText();
                UIComponent headerFacet = column.getFacet("header");
                String styleClass = column.getStyleClass() == null ? "ui-state-default" : "ui-state-default " + column.getStyleClass();
                writer.startElement("th", null);
                writer.writeAttribute("class", (Object)styleClass, null);
                if (column.getStyle() != null) {
                    writer.writeAttribute("style", (Object)column.getStyle(), null);
                }
                if (headerFacet != null) {
                    headerFacet.encodeAll(context);
                } else if (headerText != null) {
                    writer.write(headerText);
                }
                writer.endElement("th");
            }
            writer.endElement("thead");
        }
        writer.startElement("tbody", (UIComponent)ac);
        if (items != null) {
            for (Column item : items) {
                writer.startElement("tr", null);
                writer.writeAttribute("class", (Object)"ui-autocomplete-item ui-autocomplete-row ui-widget-content ui-corner-all", null);
                if (pojo) {
                    requestMap.put(var, item);
                    String value = converter == null ? (String)ac.getItemValue() : converter.getAsString(context, (UIComponent)ac, ac.getItemValue());
                    writer.writeAttribute("data-item-value", (Object)value, null);
                    writer.writeAttribute("data-item-label", (Object)ac.getItemLabel(), null);
                    writer.writeAttribute("data-item-group", ac.getGroupBy(), null);
                    if (hasGroupByTooltip) {
                        writer.writeAttribute("data-item-group-tooltip", (Object)ac.getGroupByTooltip(), null);
                    }
                }
                for (Column column : ac.getColums()) {
                    if (!column.isRendered()) continue;
                    writer.startElement("td", null);
                    if (column.getStyle() != null) {
                        writer.writeAttribute("style", (Object)column.getStyle(), null);
                    }
                    if (column.getStyleClass() != null) {
                        writer.writeAttribute("class", (Object)column.getStyleClass(), null);
                    }
                    column.encodeAll(context);
                    writer.endElement("td");
                }
                if (itemtip != null && itemtip.isRendered()) {
                    writer.startElement("td", null);
                    writer.writeAttribute("class", (Object)"ui-autocomplete-itemtip-content", null);
                    itemtip.encodeAll(context);
                    writer.endElement("td");
                }
                writer.endElement("tr");
            }
        }
        writer.endElement("tbody");
        writer.endElement("table");
    }

    protected void encodeSuggestionsAsList(FacesContext context, AutoComplete ac, List items, Converter converter) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String var = ac.getVar();
        Map requestMap = context.getExternalContext().getRequestMap();
        boolean pojo = var != null;
        UIComponent itemtip = ac.getFacet("itemtip");
        boolean hasGroupByTooltip = ac.getValueExpression("groupByTooltip") != null;
        writer.startElement("ul", (UIComponent)ac);
        writer.writeAttribute("class", (Object)"ui-autocomplete-items ui-autocomplete-list ui-widget-content ui-widget ui-corner-all ui-helper-reset", null);
        if (items != null) {
            for (Object item : items) {
                writer.startElement("li", null);
                writer.writeAttribute("class", (Object)"ui-autocomplete-item ui-autocomplete-list-item ui-corner-all", null);
                if (pojo) {
                    requestMap.put(var, item);
                    String value = converter == null ? (String)ac.getItemValue() : converter.getAsString(context, (UIComponent)ac, ac.getItemValue());
                    writer.writeAttribute("data-item-value", (Object)value, null);
                    writer.writeAttribute("data-item-label", (Object)ac.getItemLabel(), null);
                    writer.writeAttribute("data-item-group", ac.getGroupBy(), null);
                    if (hasGroupByTooltip) {
                        writer.writeAttribute("data-item-group-tooltip", (Object)ac.getGroupByTooltip(), null);
                    }
                    writer.writeText((Object)ac.getItemLabel(), null);
                } else {
                    writer.writeAttribute("data-item-label", item, null);
                    writer.writeAttribute("data-item-value", item, null);
                    writer.writeText(item, null);
                }
                writer.endElement("li");
                if (itemtip == null || !itemtip.isRendered()) continue;
                writer.startElement("li", null);
                writer.writeAttribute("class", (Object)"ui-autocomplete-itemtip-content", null);
                itemtip.encodeAll(context);
                writer.endElement("li");
            }
        }
        writer.endElement("ul");
        if (pojo) {
            requestMap.remove(var);
        }
    }

    protected void encodeScript(FacesContext context, AutoComplete ac) throws IOException {
        String effect;
        String clientId = ac.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.initWithDomReady("AutoComplete", ac.resolveWidgetVar(), clientId);
        wb.attr("minLength", ac.getMinQueryLength(), 1).attr("delay", ac.getQueryDelay()).attr("forceSelection", ac.isForceSelection(), false).attr("scrollHeight", ac.getScrollHeight(), Integer.MAX_VALUE).attr("multiple", ac.isMultiple(), false).attr("appendTo", SearchExpressionFacade.resolveClientId(context, (UIComponent)ac, ac.getAppendTo()), null).attr("grouping", ac.getValueExpression("groupBy") != null, false).attr("queryEvent", ac.getQueryEvent(), null).attr("dropdownMode", ac.getDropdownMode(), null).attr("autoHighlight", ac.isAutoHighlight(), true).attr("myPos", ac.getMy(), null).attr("atPos", ac.getAt(), null).attr("active", ac.isActive(), true);
        if (ac.isCache()) {
            wb.attr("cache", true).attr("cacheTimeout", ac.getCacheTimeout());
        }
        if ((effect = ac.getEffect()) != null) {
            wb.attr("effect", effect, null).attr("effectDuration", ac.getEffectDuration(), Integer.MAX_VALUE);
        }
        wb.attr("emptyMessage", ac.getEmptyMessage(), null).attr("resultsMesage", ac.getResultsMessage(), null);
        if (ac.getFacet("itemtip") != null) {
            wb.attr("itemtip", true, false).attr("itemtipMyPosition", ac.getItemtipMyPosition(), null).attr("itemtipAtPosition", ac.getItemtipAtPosition(), null);
        }
        if (ac.isMultiple()) {
            wb.attr("selectLimit", ac.getSelectLimit(), Integer.MAX_VALUE);
        }
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)ac);
        wb.finish();
    }

    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        if (submittedValue == null || submittedValue.equals("")) {
            return null;
        }
        AutoComplete ac = (AutoComplete)component;
        Converter converter = ComponentUtils.getConverter(context, component);
        if (ac.isMultiple()) {
            String[] values = (String[])submittedValue;
            ArrayList<String> list = new ArrayList<String>();
            for (String value : values) {
                String convertedValue;
                if (this.isValueBlank(value)) continue;
                String string = convertedValue = converter != null ? converter.getAsObject(context, (UIComponent)ac, value) : value;
                if (convertedValue == null) continue;
                list.add(convertedValue);
            }
            return list;
        }
        if (converter != null) {
            return converter.getAsObject(context, component, (String)submittedValue);
        }
        return submittedValue;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

