/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.behavior.confirm;

import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.context.FacesContext;
import org.primefaces.behavior.base.AbstractBehavior;
import org.primefaces.component.api.Confirmable;
import org.primefaces.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfirmBehavior
extends AbstractBehavior {
    public static final String BEHAVIOR_ID = "org.primefaces.behavior.ConfirmBehavior";

    public String getScript(ClientBehaviorContext behaviorContext) {
        FacesContext context = behaviorContext.getFacesContext();
        UIComponent component = behaviorContext.getComponent();
        String source = component.getClientId(context);
        String headerText = JSONObject.quote(this.getHeader());
        String messageText = JSONObject.quote(this.getMessage());
        if (component instanceof Confirmable) {
            String sourceProperty = source == null ? "source:this" : "source:\"" + source + "\"";
            String script = "PrimeFaces.confirm({" + sourceProperty + ",header:" + headerText + ",message:" + messageText + ",icon:\"" + this.getIcon() + "\"});return false;";
            ((Confirmable)component).setConfirmationScript(script);
            return null;
        }
        throw new FacesException("Component " + source + " is not a Confirmable. ConfirmBehavior can only be attached to components that implement org.primefaces.component.api.Confirmable interface");
    }

    @Override
    protected Enum<?>[] getAllProperties() {
        return PropertyKeys.values();
    }

    public String getHeader() {
        return this.eval(PropertyKeys.header, null);
    }

    public void setHeader(String header) {
        this.setLiteral(PropertyKeys.header, (Object)header);
    }

    public String getMessage() {
        return this.eval(PropertyKeys.message, null);
    }

    public void setMessage(String message) {
        this.setLiteral(PropertyKeys.message, (Object)message);
    }

    public String getIcon() {
        return this.eval(PropertyKeys.icon, null);
    }

    public void setIcon(String icon) {
        this.setLiteral(PropertyKeys.icon, (Object)icon);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PropertyKeys {
        header(String.class),
        message(String.class),
        icon(String.class);

        final Class<?> expectedType;

        private PropertyKeys(Class<?> expectedType) {
            this.expectedType = expectedType;
        }
    }
}

