/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.application.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.primefaces.application.resource.BaseDynamicContentHandler;
import org.primefaces.context.RequestContext;
import org.primefaces.model.StreamedContent;
import org.primefaces.util.StringEncrypter;

public class StreamedContentHandler
extends BaseDynamicContentHandler {
    private static final Logger logger = Logger.getLogger(StreamedContentHandler.class.getName());

    public void handle(FacesContext context) throws IOException {
        Map params = context.getExternalContext().getRequestParameterMap();
        String library = (String)params.get("ln");
        String dynamicContentId = (String)params.get("pfdrid");
        StringEncrypter strEn = RequestContext.getCurrentInstance().getEncrypter();
        if (dynamicContentId != null && library != null && library.equals("primefaces")) {
            StreamedContent streamedContent = null;
            boolean cache = Boolean.valueOf((String)params.get("pfdrid_c"));
            try {
                dynamicContentId = dynamicContentId.replaceAll(" ", "+");
                String dynamicContentEL = strEn.decrypt(dynamicContentId);
                ExternalContext externalContext = context.getExternalContext();
                if (dynamicContentEL != null) {
                    int length;
                    ELContext eLContext = context.getELContext();
                    ValueExpression ve = context.getApplication().getExpressionFactory().createValueExpression(context.getELContext(), dynamicContentEL, StreamedContent.class);
                    streamedContent = (StreamedContent)ve.getValue(eLContext);
                    if (streamedContent == null || streamedContent.getStream() == null) {
                        if (externalContext.getRequest() instanceof HttpServletRequest) {
                            externalContext.responseSendError(404, ((HttpServletRequest)externalContext.getRequest()).getRequestURI());
                        } else {
                            externalContext.responseSendError(404, null);
                        }
                        return;
                    }
                    externalContext.setResponseStatus(200);
                    externalContext.setResponseContentType(streamedContent.getContentType());
                    this.handleCache(externalContext, cache);
                    if (streamedContent.getContentEncoding() != null) {
                        externalContext.setResponseHeader("Content-Encoding", streamedContent.getContentEncoding());
                    }
                    byte[] buffer = new byte[2048];
                    InputStream inputStream = streamedContent.getStream();
                    while ((length = inputStream.read(buffer)) >= 0) {
                        externalContext.getResponseOutputStream().write(buffer, 0, length);
                    }
                }
                externalContext.responseFlushBuffer();
                context.responseComplete();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error in streaming dynamic resource. {0}", new Object[]{e.getMessage()});
                throw new IOException(e);
            }
            finally {
                if (streamedContent != null && streamedContent.getStream() != null) {
                    streamedContent.getStream().close();
                }
            }
        }
    }
}

