/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.interpreter.operations;

import java.io.DataInput;
import java.io.IOException;
import nl.tudelft.simulation.dsol.interpreter.LocalVariable;
import nl.tudelft.simulation.dsol.interpreter.OperandStack;
import nl.tudelft.simulation.dsol.interpreter.classfile.Constant;
import nl.tudelft.simulation.dsol.interpreter.classfile.ConstantFloat;
import nl.tudelft.simulation.dsol.interpreter.classfile.ConstantInteger;
import nl.tudelft.simulation.dsol.interpreter.classfile.ConstantString;
import nl.tudelft.simulation.dsol.interpreter.operations.VoidOperation;

public class LDC
extends VoidOperation {
    public static final int OP = 18;
    private int index = -1;

    public LDC(DataInput dataInput) throws IOException {
        this.index = dataInput.readUnsignedByte();
    }

    public void execute(OperandStack stack, Constant[] constantPool, LocalVariable[] localVariables) {
        Constant constant = constantPool[this.index];
        if (constant instanceof ConstantInteger) {
            stack.push(new Integer(((ConstantInteger)constant).getValue()));
        } else if (constant instanceof ConstantFloat) {
            stack.push(new Float(((ConstantFloat)constant).getValue()));
        } else if (constant instanceof ConstantString) {
            stack.push(((ConstantString)constant).getValue());
        }
    }

    public int getByteLength() {
        return 2;
    }

    public int getOpcode() {
        return 18;
    }
}

