/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestNGUtil {
    static final double EPSILON = 1.0E-300;

    public static Object[][] generateDataProvider(TestNGParameterizable[] testcases) {
        return TestNGUtil.generateDataProvider(Arrays.asList(testcases));
    }

    public static Object[][] generateDataProvider(Iterable<? extends TestNGParameterizable> testcases) {
        Iterator<? extends TestNGParameterizable> i = testcases.iterator();
        LinkedList<Object[]> parameterList = new LinkedList<Object[]>();
        while (i.hasNext()) {
            parameterList.add(i.next().toObjectArray());
        }
        Object[][] parameterArray = new Object[parameterList.size()][];
        for (int j = 0; j < parameterList.size(); ++j) {
            parameterArray[j] = (Object[])parameterList.get(j);
        }
        return parameterArray;
    }

    public static boolean compareDoubleWithAccuracy(double lhs, double rhs, double accuracy) {
        if (accuracy <= 0.0) {
            throw new IllegalArgumentException("Accuracy must be positive.");
        }
        return Math.abs(lhs - rhs) / (Math.abs(lhs) + Math.abs(rhs) + 1.0E-300) < accuracy;
    }

    public static void assertEqualDoubleArrays(double[] lhs, double[] rhs, double accuracy) {
        Assert.assertNotNull((Object)lhs);
        Assert.assertNotNull((Object)rhs);
        if (accuracy <= 0.0) {
            throw new IllegalArgumentException("Accuracy must be positive.");
        }
        Assert.assertEquals((int)lhs.length, (int)rhs.length, (String)("Arrays not same length: " + lhs.length + " vs. " + rhs.length));
        for (int i = 0; i < lhs.length; ++i) {
            Assert.assertTrue((boolean)TestNGUtil.compareDoubleWithAccuracy(lhs[i], rhs[i], accuracy), (String)("Arrays disagree at position " + i + ":  " + lhs[i] + " vs. " + rhs[i] + ". "));
        }
    }

    public static class TestNGParameterizable {
        public Object[] toObjectArray() {
            return new Object[]{this};
        }
    }

    public static abstract class SingleTestUnitTest<TestClazz extends TestNGParameterizable> {
        @DataProvider(name="testcases")
        Object[][] getParams() {
            return TestNGUtil.generateDataProvider(this.getTestcases());
        }

        @Test(dataProvider="testcases")
        public void doMetaTest(TestClazz testcase) {
            this.doTest(testcase);
        }

        public abstract Iterable<TestClazz> getTestcases();

        public abstract void doTest(TestClazz var1);
    }
}

