/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.IterableAdapter;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import picard.PicardException;
import picard.illumina.parser.IlluminaMetricsCode;
import picard.illumina.parser.ReadStructure;
import picard.illumina.parser.ReadType;
import picard.illumina.parser.Tile;
import picard.illumina.parser.TilePhasingValue;
import picard.illumina.parser.TileTemplateRead;
import picard.illumina.parser.readers.TileMetricsOutReader;

public class TileMetricsUtil {
    public static String INTEROP_SUBDIRECTORY_NAME = "InterOp";
    public static String TILE_METRICS_OUT_FILE_NAME = "TileMetricsOut.bin";

    public static File renderTileMetricsFileFromBasecallingDirectory(File illuminaRunDirectory) {
        return new File(new File(illuminaRunDirectory, INTEROP_SUBDIRECTORY_NAME), TILE_METRICS_OUT_FILE_NAME);
    }

    public static Collection<Tile> parseTileMetrics(File tileMetricsOutFile, ReadStructure readStructure) throws FileNotFoundException {
        Collection<TileMetricsOutReader.IlluminaTileMetrics> tileMetrics = TileMetricsUtil.determineLastValueForLaneTileMetricsCode(new TileMetricsOutReader(tileMetricsOutFile));
        Map<String, Collection<TileMetricsOutReader.IlluminaTileMetrics>> locationToMetricsMap = TileMetricsUtil.partitionTileMetricsByLocation(tileMetrics);
        LinkedList<Tile> tiles = new LinkedList<Tile>();
        for (Map.Entry<String, Collection<TileMetricsOutReader.IlluminaTileMetrics>> entry : locationToMetricsMap.entrySet()) {
            Collection<TileMetricsOutReader.IlluminaTileMetrics> tileRecords = entry.getValue();
            Map<Integer, Collection<TileMetricsOutReader.IlluminaTileMetrics>> codeMetricsMap = TileMetricsUtil.partitionTileMetricsByCode(tileRecords);
            Set<Integer> observedCodes = codeMetricsMap.keySet();
            if (!observedCodes.contains(IlluminaMetricsCode.DENSITY_ID.getMetricsCode()) || !observedCodes.contains(IlluminaMetricsCode.CLUSTER_ID.getMetricsCode())) {
                throw new PicardException(String.format("Expected to find cluster and density record codes (%s and %s) in records read for tile location %s (lane:tile), but found only %s.", IlluminaMetricsCode.CLUSTER_ID.getMetricsCode(), IlluminaMetricsCode.DENSITY_ID.getMetricsCode(), entry.getKey(), observedCodes));
            }
            TileMetricsOutReader.IlluminaTileMetrics densityRecord = CollectionUtil.getSoleElement(codeMetricsMap.get(IlluminaMetricsCode.DENSITY_ID.getMetricsCode()));
            TileMetricsOutReader.IlluminaTileMetrics clusterRecord = CollectionUtil.getSoleElement(codeMetricsMap.get(IlluminaMetricsCode.CLUSTER_ID.getMetricsCode()));
            Collection<TilePhasingValue> tilePhasingValues = TileMetricsUtil.getTilePhasingValues(codeMetricsMap, readStructure);
            tiles.add(new Tile(densityRecord.getLaneNumber(), densityRecord.getTileNumber(), densityRecord.getMetricValue(), clusterRecord.getMetricValue(), tilePhasingValues.toArray(new TilePhasingValue[tilePhasingValues.size()])));
        }
        return Collections.unmodifiableCollection(tiles);
    }

    private static Collection<TilePhasingValue> getTilePhasingValues(Map<Integer, Collection<TileMetricsOutReader.IlluminaTileMetrics>> codeMetricsMap, ReadStructure readStructure) {
        boolean isFirstRead = true;
        ArrayList<TilePhasingValue> tilePhasingValues = new ArrayList<TilePhasingValue>();
        for (int descriptorIndex = 0; descriptorIndex < readStructure.descriptors.size(); ++descriptorIndex) {
            if (readStructure.descriptors.get((int)descriptorIndex).type != ReadType.Template) continue;
            TileTemplateRead tileTemplateRead = isFirstRead ? TileTemplateRead.FIRST : TileTemplateRead.SECOND;
            int phasingCode = IlluminaMetricsCode.getPhasingCode(descriptorIndex, IlluminaMetricsCode.PHASING_BASE);
            int prePhasingCode = IlluminaMetricsCode.getPhasingCode(descriptorIndex, IlluminaMetricsCode.PREPHASING_BASE);
            if (!codeMetricsMap.containsKey(phasingCode) || !codeMetricsMap.containsKey(prePhasingCode)) {
                throw new PicardException("Don't have both phasing and prephasing values for tile");
            }
            tilePhasingValues.add(new TilePhasingValue(tileTemplateRead, CollectionUtil.getSoleElement(codeMetricsMap.get(phasingCode)).getMetricValue(), CollectionUtil.getSoleElement(codeMetricsMap.get(prePhasingCode)).getMetricValue()));
            isFirstRead = false;
        }
        return tilePhasingValues;
    }

    private static Collection<TileMetricsOutReader.IlluminaTileMetrics> determineLastValueForLaneTileMetricsCode(Iterator<TileMetricsOutReader.IlluminaTileMetrics> tileMetricsIterator) {
        HashMap<TileMetricsOutReader.IlluminaLaneTileCode, TileMetricsOutReader.IlluminaTileMetrics> filteredTileMetrics = new HashMap<TileMetricsOutReader.IlluminaLaneTileCode, TileMetricsOutReader.IlluminaTileMetrics>();
        for (TileMetricsOutReader.IlluminaTileMetrics illuminaTileMetrics : new IterableAdapter<TileMetricsOutReader.IlluminaTileMetrics>(tileMetricsIterator)) {
            filteredTileMetrics.put(illuminaTileMetrics.getLaneTileCode(), illuminaTileMetrics);
        }
        return filteredTileMetrics.values();
    }

    private static String renderMetricLocationKey(TileMetricsOutReader.IlluminaTileMetrics metric) {
        return String.format("%s:%s", metric.getLaneNumber(), metric.getTileNumber());
    }

    private static Map<Integer, Collection<TileMetricsOutReader.IlluminaTileMetrics>> partitionTileMetricsByCode(Collection<TileMetricsOutReader.IlluminaTileMetrics> tileMetrics) {
        return CollectionUtil.partition(tileMetrics, new CollectionUtil.Partitioner<TileMetricsOutReader.IlluminaTileMetrics, Integer>(){

            @Override
            public Integer getPartition(TileMetricsOutReader.IlluminaTileMetrics metric) {
                return metric.getMetricCode();
            }
        });
    }

    private static Map<String, Collection<TileMetricsOutReader.IlluminaTileMetrics>> partitionTileMetricsByLocation(Collection<TileMetricsOutReader.IlluminaTileMetrics> tileMetrics) {
        return CollectionUtil.partition(tileMetrics, new CollectionUtil.Partitioner<TileMetricsOutReader.IlluminaTileMetrics, String>(){

            @Override
            public String getPartition(TileMetricsOutReader.IlluminaTileMetrics metric) {
                return TileMetricsUtil.renderMetricLocationKey(metric);
            }
        });
    }
}

