/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.vector;

import edu.rit.mp.Buf;
import edu.rit.mp.DoubleBuf;
import edu.rit.pj.reduction.Op;
import edu.rit.util.Range;
import edu.rit.vector.Vector2D;
import java.nio.ByteBuffer;

class Vector2DArrayDoubleBuf
extends DoubleBuf {
    Vector2D[] myArray;
    Range myRange;
    int myArrayOffset;
    int myStride;

    public Vector2DArrayDoubleBuf(Vector2D[] vector2DArray, Range range) {
        super(range.length() * 2);
        if (0 > range.lb() || range.ub() >= vector2DArray.length) {
            throw new IndexOutOfBoundsException("Vector2DArrayDoubleBuf(): theArray index range = 0.." + (vector2DArray.length - 1) + "1, theRange = " + range);
        }
        this.myArray = vector2DArray;
        this.myRange = range;
        this.myArrayOffset = range.lb();
        this.myStride = range.stride();
    }

    public double get(int n) {
        int n2 = this.myArrayOffset + (n >>> 1) * this.myStride;
        if ((n & 1) == 0) {
            return this.myArray[n2].x;
        }
        return this.myArray[n2].y;
    }

    public void put(int n, double d) {
        int n2 = this.myArrayOffset + (n >>> 1) * this.myStride;
        if ((n & 1) == 0) {
            this.myArray[n2].x = d;
        } else {
            this.myArray[n2].y = d;
        }
    }

    public void copy(Buf buf) {
        if (buf != this) {
            if (buf instanceof Vector2DArrayDoubleBuf) {
                Vector2DArrayDoubleBuf vector2DArrayDoubleBuf = (Vector2DArrayDoubleBuf)buf;
                if (vector2DArrayDoubleBuf.myArray != this.myArray || vector2DArrayDoubleBuf.myArrayOffset > this.myArrayOffset) {
                    int n = Math.min(vector2DArrayDoubleBuf.myLength / 2, this.myLength / 2);
                    int n2 = vector2DArrayDoubleBuf.myArrayOffset;
                    int n3 = this.myArrayOffset;
                    for (int i = 0; i < n; ++i) {
                        this.myArray[n3].assign(vector2DArrayDoubleBuf.myArray[n2]);
                        n2 += vector2DArrayDoubleBuf.myStride;
                        n3 += this.myStride;
                    }
                } else if (vector2DArrayDoubleBuf.myArrayOffset < this.myArrayOffset) {
                    int n = Math.min(vector2DArrayDoubleBuf.myLength / 2, this.myLength / 2);
                    int n4 = vector2DArrayDoubleBuf.myArrayOffset + (n - 1) * vector2DArrayDoubleBuf.myStride;
                    int n5 = this.myArrayOffset + (n - 1) * this.myStride;
                    for (int i = n - 1; i >= 0; --i) {
                        this.myArray[n5].assign(vector2DArrayDoubleBuf.myArray[n4]);
                        n4 -= vector2DArrayDoubleBuf.myStride;
                        n5 -= this.myStride;
                    }
                }
            } else {
                DoubleBuf.defaultCopy((DoubleBuf)buf, this);
            }
        }
    }

    public Buf getReductionBuf(Op op) {
        throw new UnsupportedOperationException();
    }

    protected int sendItems(int n, ByteBuffer byteBuffer) {
        int n2;
        int n3 = this.myArrayOffset + (n >>> 1) * this.myStride;
        for (n2 = n; n2 < this.myLength && byteBuffer.remaining() >= 16; n2 += 2) {
            Vector2D vector2D = this.myArray[n3];
            byteBuffer.putDouble(vector2D.x);
            byteBuffer.putDouble(vector2D.y);
            n3 += this.myStride;
        }
        return n2 - n;
    }

    protected int receiveItems(int n, int n2, ByteBuffer byteBuffer) {
        int n3;
        int n4 = this.myArrayOffset + (n >>> 1) * this.myStride;
        int n5 = Math.min(n + n2, this.myLength);
        for (n3 = n; n3 < n5 && byteBuffer.remaining() >= 16; n3 += 2) {
            Vector2D vector2D = this.myArray[n4];
            vector2D.x = byteBuffer.getDouble();
            vector2D.y = byteBuffer.getDouble();
            n4 += this.myStride;
        }
        return n3 - n;
    }
}

