/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.vector;

import edu.rit.mp.DoubleBuf;
import edu.rit.util.Range;
import edu.rit.vector.Vector2DArrayDoubleBuf;
import edu.rit.vector.Vector2DArrayDoubleBuf_1;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class Vector2D
implements Externalizable {
    private static final long serialVersionUID = -4617340700183457338L;
    public double x;
    public double y;

    public Vector2D() {
    }

    public Vector2D(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public Vector2D(Vector2D vector2D) {
        this.x = vector2D.x;
        this.y = vector2D.y;
    }

    public Vector2D clear() {
        this.x = 0.0;
        this.y = 0.0;
        return this;
    }

    public Vector2D assign(double d, double d2) {
        this.x = d;
        this.y = d2;
        return this;
    }

    public Vector2D assign(Vector2D vector2D) {
        this.x = vector2D.x;
        this.y = vector2D.y;
        return this;
    }

    public Vector2D add(Vector2D vector2D) {
        this.x += vector2D.x;
        this.y += vector2D.y;
        return this;
    }

    public Vector2D sub(Vector2D vector2D) {
        this.x -= vector2D.x;
        this.y -= vector2D.y;
        return this;
    }

    public Vector2D mul(double d) {
        this.x *= d;
        this.y *= d;
        return this;
    }

    public Vector2D div(double d) {
        this.x /= d;
        this.y /= d;
        return this;
    }

    public Vector2D neg() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    public Vector2D norm() {
        return this.div(this.mag());
    }

    public double dot(Vector2D vector2D) {
        return this.x * vector2D.x + this.y * vector2D.y;
    }

    public double mag() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double sqrMag() {
        return this.x * this.x + this.y * this.y;
    }

    public double arg() {
        return Math.atan2(this.y, this.x);
    }

    public double dist(Vector2D vector2D) {
        double d = this.x - vector2D.x;
        double d2 = this.y - vector2D.y;
        return Math.sqrt(d * d + d2 * d2);
    }

    public double sqrDist(Vector2D vector2D) {
        double d = this.x - vector2D.x;
        double d2 = this.y - vector2D.y;
        return d * d + d2 * d2;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeDouble(this.x);
        objectOutput.writeDouble(this.y);
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        this.x = objectInput.readDouble();
        this.y = objectInput.readDouble();
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }

    public static DoubleBuf doubleBuffer(Vector2D[] vector2DArray) {
        return new Vector2DArrayDoubleBuf_1(vector2DArray, new Range(0, vector2DArray.length - 1));
    }

    public static DoubleBuf doubleSliceBuffer(Vector2D[] vector2DArray, Range range) {
        if (range.stride() == 1) {
            return new Vector2DArrayDoubleBuf_1(vector2DArray, range);
        }
        return new Vector2DArrayDoubleBuf(vector2DArray, range);
    }

    public static DoubleBuf[] doubleSliceBuffers(Vector2D[] vector2DArray, Range[] rangeArray) {
        int n = rangeArray.length;
        DoubleBuf[] doubleBufArray = new DoubleBuf[n];
        for (int i = 0; i < n; ++i) {
            doubleBufArray[i] = Vector2D.doubleSliceBuffer(vector2DArray, rangeArray[i]);
        }
        return doubleBufArray;
    }
}

