/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.util;

import edu.rit.util.DefaultRandom;
import java.io.Serializable;
import java.lang.reflect.Constructor;

public abstract class Random
implements Serializable {
    protected Random() {
    }

    public static Random getInstance(long l) {
        String string = System.getProperty("pj.prng");
        return string == null ? new DefaultRandom(l) : Random.getInstance(l, string);
    }

    public static Random getInstance(long l, String string) {
        try {
            Class<?> clazz = Class.forName(string);
            Constructor<?> constructor = clazz.getConstructor(Long.TYPE);
            return (Random)constructor.newInstance(l);
        }
        catch (Exception exception) {
            throw new TypeNotPresentException(string, exception);
        }
    }

    public abstract void setSeed(long var1);

    public void skip() {
        this.next();
    }

    public void skip(long l) {
        if (l > 0L) {
            this.next(l);
        }
    }

    public boolean nextBoolean() {
        return (this.next() & 0x4000000000000000L) != 0L;
    }

    public boolean nextBoolean(long l) {
        return (this.next(l) & 0x4000000000000000L) != 0L;
    }

    public int nextInt(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        return (int)Math.floor(this.nextDouble() * (double)n);
    }

    public int nextInt(int n, long l) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        return (int)Math.floor(this.nextDouble(l) * (double)n);
    }

    public float nextFloat() {
        return Float.intBitsToFloat(0x3F800000 | (int)(this.next() >>> 40)) - 1.0f;
    }

    public float nextFloat(long l) {
        return Float.intBitsToFloat(0x3F800000 | (int)(this.next(l) >>> 40)) - 1.0f;
    }

    public double nextDouble() {
        return Double.longBitsToDouble(0x3FF0000000000000L | this.next() >>> 11) - 1.0;
    }

    public double nextDouble(long l) {
        return Double.longBitsToDouble(0x3FF0000000000000L | this.next(l) >>> 11) - 1.0;
    }

    protected abstract long next();

    protected abstract long next(long var1);
}

