/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.util;

import edu.rit.util.Random;

public class DefaultRandom
extends Random {
    private static final long A = 2307085864L;
    private static final long M = 0x7FFFFFFFFFFFFFE7L;
    private static final long[] powtable = new long[]{2307085864L, 5322645183868626496L, 983401115462215297L, 3556108090190705823L, 7990665143195102590L, 2110036525984475599L, 7043012601020815633L, 8705155707092105232L, 3648485552813098205L, 3168429798853819517L, 7370936612916750461L, 7860663018156131952L, 3001105880121306407L, 2701734581708584636L, 44173215984149523L, 4386281867185367357L, 6179163218358095360L, 7483044026478026567L, 3475714592143337300L, 1764426730688581302L, 3750657437672096664L, 622726075290379426L, 5708473958970181660L, 4021546582722653103L, 2336213934427760687L, 1250271094601288883L, 3574383011208782094L, 8396902035548884488L, 8461483610275050157L, 4570169555765982077L, 8905831846701231221L, 8735916407118983196L, 2440495732904503112L, 1885457269016286005L, 4972446378304258072L, 5086882142287647560L, 7606891628733932672L, 1492990033908793408L, 9099993837175275499L, 164616137930049276L, 5117944347055477320L, 3732738446422589684L, 577797231373159603L, 2884327325873197522L, 4833803989390835826L, 7647846260763424785L, 4871120313232679781L, 2522743552130321382L, 2285147082121189109L, 3702619298913044713L, 7517285182136659617L, 1501022168611987834L, 4083684657803873370L, 1174110446001111617L, 82581059520186299L, 1334190853588951475L, 3130709730706025384L, 8886205968707213290L, 993283284549990895L, 3258516944203296282L, 4273233140749644635L, 7682756089153477585L, 8243539608199123644L};
    private long seed;
    private transient long pad01;
    private transient long pad02;
    private transient long pad03;
    private transient long pad04;
    private transient long pad05;
    private transient long pad06;
    private transient long pad07;
    private transient long pad08;

    public DefaultRandom(long l) {
        this.setSeed(l);
    }

    public void setSeed(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("DefaultRandom.setSeed(): seed <= 0");
        }
        this.seed = l;
    }

    protected long next() {
        long l = (this.seed & 0xFFFFFFFFL) * 2307085864L;
        long l2 = (this.seed >>> 32) * 2307085864L;
        long l3 = (l2 << 32) + l;
        long l4 = l2 + (l >>> 32);
        long l5 = l4 >>> 31;
        long l6 = l3 & Long.MAX_VALUE;
        if ((l6 += l5 * 25L) < 0L || l6 >= 0x7FFFFFFFFFFFFFE7L) {
            l6 -= 0x7FFFFFFFFFFFFFE7L;
        }
        this.seed = l6;
        return l6;
    }

    protected long next(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("DefaultRandom.next(): skip <= 0");
        }
        int n = 0;
        while (l != 0L) {
            if ((l & 1L) != 0L) {
                this.seed = DefaultRandom.modMultiply(powtable[n], this.seed);
            }
            l >>>= 1;
            ++n;
        }
        return this.seed;
    }

    private static long modMultiply(long l, long l2) {
        long l3 = l >>> 32;
        long l4 = l & 0xFFFFFFFFL;
        long l5 = l2 >>> 32;
        long l6 = l2 & 0xFFFFFFFFL;
        long l7 = l4 * l6;
        long l8 = l3 * l6;
        long l9 = l4 * l5;
        long l10 = l3 * l5;
        long l11 = (l7 >>> 32) + (l8 & 0xFFFFFFFFL) + (l9 & 0xFFFFFFFFL);
        long l12 = (l7 & 0xFFFFFFFFL) + (l11 << 32);
        long l13 = (l11 >>> 32) + (l8 >>> 32) + (l9 >>> 32) + l10;
        long l14 = l13 << 1 | l12 >>> 63;
        long l15 = l12 & Long.MAX_VALUE;
        while (l14 > 0L) {
            long l16 = (l14 & 0xFFFFFFFFL) * 25L;
            long l17 = (l14 >>> 32) * 25L;
            long l18 = (l17 << 32) + l16;
            long l19 = l17 + (l16 >>> 32);
            l14 = l19 >>> 31;
            if ((l15 += l18 & Long.MAX_VALUE) >= 0L && l15 < 0x7FFFFFFFFFFFFFE7L) continue;
            l15 -= 0x7FFFFFFFFFFFFFE7L;
        }
        return l15;
    }
}

