/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.util;

import edu.rit.util.Range;
import java.util.Arrays;

public class Checklist {
    private int[] myBitSet;
    private int myLength;
    private static final int[] masktable = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000, 0x1000000, 0x2000000, 0x4000000, 0x8000000, 0x10000000, 0x20000000, 0x40000000, Integer.MIN_VALUE};

    public Checklist(int n) {
        if (n < 0) {
            throw new NegativeArraySizeException("Checklist(): length = " + n + " illegal");
        }
        this.myBitSet = new int[(n + 31) / 32];
        this.myLength = n;
    }

    public int length() {
        return this.myLength;
    }

    public synchronized void clear() {
        Arrays.fill(this.myBitSet, 0);
    }

    public synchronized void mark(int n) {
        if (0 > n || n >= this.myLength) {
            throw new IndexOutOfBoundsException("Checklist.mark(): i = " + n + " out of bounds");
        }
        int n2 = n >>> 5;
        int n3 = masktable[n & 0x1F];
        int n4 = n2;
        this.myBitSet[n4] = this.myBitSet[n4] | n3;
        this.notifyAll();
    }

    public synchronized void mark(Range range) {
        int n = range.length();
        if (n == 0) {
            return;
        }
        int n2 = range.lb();
        int n3 = range.ub();
        if (0 > n2 || n2 >= this.myLength || 0 > n3 || n3 >= this.myLength) {
            throw new IndexOutOfBoundsException("Checklist.mark(): range = " + range + " out of bounds");
        }
        int n4 = n2 >>> 5;
        int n5 = masktable[n2 & 0x1F];
        while (n > 0) {
            int n6 = n4++;
            this.myBitSet[n6] = this.myBitSet[n6] | n5;
            if ((n5 <<= 1) == 0) {
                n5 = 1;
            }
            --n;
        }
        this.notifyAll();
    }

    public synchronized void waitForMark(int n) throws InterruptedException {
        if (0 > n || n >= this.myLength) {
            throw new IndexOutOfBoundsException("Checklist.waitForMark(): i = " + n + " illegal");
        }
        int n2 = n >>> 5;
        int n3 = masktable[n & 0x1F];
        while ((this.myBitSet[n2] & n3) == 0) {
            this.wait();
        }
    }
}

