/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.smp.network;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class FloydSmpRow {
    static int n;
    static double[][] d;

    private FloydSmpRow() {
    }

    public static void main(String[] stringArray) throws Exception {
        long l = System.currentTimeMillis();
        if (stringArray.length != 2) {
            FloydSmpRow.usage();
        }
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        n = dataInputStream.readInt();
        d = new double[n][n];
        for (int i = 0; i < n; ++i) {
            double[] dArray = d[i];
            for (int j = 0; j < n; ++j) {
                dArray[j] = dataInputStream.readDouble();
            }
        }
        dataInputStream.close();
        long l2 = System.currentTimeMillis();
        new ParallelTeam().execute(new ParallelRegion(){

            public void run() throws Exception {
                int n = 0;
                while (n < FloydSmpRow.n) {
                    final int n2 = n++;
                    final double[] dArray = d[n2];
                    this.execute(0, FloydSmpRow.n - 1, new IntegerForLoop(){

                        public void run(int n, int n22) {
                            for (int i = n; i <= n22; ++i) {
                                double[] dArray2 = d[i];
                                for (int j = 0; j < FloydSmpRow.n; ++j) {
                                    dArray2[j] = Math.min(dArray2[j], dArray2[n2] + dArray[j]);
                                }
                            }
                        }
                    });
                }
            }
        });
        long l3 = System.currentTimeMillis();
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));
        dataOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            double[] dArray = d[i];
            for (int j = 0; j < n; ++j) {
                dataOutputStream.writeDouble(dArray[j]);
            }
        }
        dataOutputStream.close();
        long l4 = System.currentTimeMillis();
        System.out.println(l2 - l + " msec pre");
        System.out.println(l3 - l2 + " msec calc");
        System.out.println(l4 - l3 + " msec post");
        System.out.println(l4 - l + " msec total");
    }

    private static void usage() {
        System.err.println("Usage: java -Dpj.nt=<K> edu.rit.smp.network.FloydSmpRow <infile> <outfile>");
        System.err.println("<K> = Number of parallel threads");
        System.err.println("<infile> = Input distance matrix file");
        System.err.println("<outfile> = Output distance matrix file");
        System.exit(1);
    }
}

