/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.smp.network;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class FloydSmpCol {
    static int n;
    static double[][] d;

    private FloydSmpCol() {
    }

    public static void main(String[] stringArray) throws Exception {
        long l = System.currentTimeMillis();
        if (stringArray.length != 2) {
            FloydSmpCol.usage();
        }
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        n = dataInputStream.readInt();
        d = new double[n][n];
        for (int i = 0; i < n; ++i) {
            double[] dArray = d[i];
            for (int j = 0; j < n; ++j) {
                dArray[j] = dataInputStream.readDouble();
            }
        }
        dataInputStream.close();
        long l2 = System.currentTimeMillis();
        new ParallelTeam().execute(new ParallelRegion(){

            public void run() throws Exception {
                for (int i = 0; i < n; ++i) {
                    final int n = i;
                    final double[] dArray = d[n];
                    for (int j = 0; j < FloydSmpCol.n; ++j) {
                        final double[] dArray2 = d[j];
                        this.execute(0, FloydSmpCol.n - 1, new IntegerForLoop(){

                            public void run(int n3, int n2) {
                                for (int i = n3; i <= n2; ++i) {
                                    dArray2[i] = Math.min(dArray2[i], dArray2[n] + dArray[i]);
                                }
                            }
                        });
                    }
                }
            }
        });
        long l3 = System.currentTimeMillis();
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));
        dataOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            double[] dArray = d[i];
            for (int j = 0; j < n; ++j) {
                dataOutputStream.writeDouble(dArray[j]);
            }
        }
        dataOutputStream.close();
        long l4 = System.currentTimeMillis();
        System.out.println(l2 - l + " msec pre");
        System.out.println(l3 - l2 + " msec calc");
        System.out.println(l4 - l3 + " msec post");
        System.out.println(l4 - l + " msec total");
    }

    private static void usage() {
        System.err.println("Usage: java -Dpj.nt=<K> edu.rit.smp.network.FloydSmpCol <infile> <outfile>");
        System.err.println("<K> = Number of parallel threads");
        System.err.println("<infile> = Input distance matrix file");
        System.err.println("<outfile> = Output distance matrix file");
        System.exit(1);
    }
}

