/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.smp.monte;

import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import edu.rit.pj.reduction.SharedLong;
import edu.rit.util.LongRange;
import edu.rit.util.Random;

public class PiSmp3 {
    static long seed;
    static long N;
    static SharedLong count;

    private PiSmp3() {
    }

    public static void main(String[] stringArray) throws Exception {
        long l = -System.currentTimeMillis();
        if (stringArray.length != 2) {
            PiSmp3.usage();
        }
        seed = Long.parseLong(stringArray[0]);
        N = Long.parseLong(stringArray[1]);
        count = new SharedLong(0L);
        new ParallelTeam().execute(new ParallelRegion(){

            public void run() {
                Random random = Random.getInstance(seed);
                long l = 0L;
                LongRange longRange = new LongRange(0L, N - 1L).subrange(this.getThreadCount(), this.getThreadIndex());
                long l2 = longRange.length();
                random.skip(2L * longRange.lb());
                for (long i = 0L; i < l2; ++i) {
                    double d;
                    double d2 = random.nextDouble();
                    if (!(d2 * d2 + (d = random.nextDouble()) * d <= 1.0)) continue;
                    ++l;
                }
                count.addAndGet(l);
            }
        });
        System.out.println("pi = 4 * " + count + " / " + N + " = " + 4.0 * count.doubleValue() / (double)N);
        System.out.println((l += System.currentTimeMillis()) + " msec");
    }

    private static void usage() {
        System.err.println("Usage: java -Dpj.nt=<K> PiSmp3 <seed> <N>");
        System.err.println("<K> = Number of parallel threads");
        System.err.println("<seed> = Random seed");
        System.err.println("<N> = Number of random points");
        System.exit(1);
    }
}

