/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.smp.monte;

import java.util.Random;

public class PiSeq {
    static long seed;
    static long N;
    static Random prng;
    static long count;

    private PiSeq() {
    }

    public static void main(String[] stringArray) throws Exception {
        long l = -System.currentTimeMillis();
        if (stringArray.length != 2) {
            PiSeq.usage();
        }
        seed = Long.parseLong(stringArray[0]);
        N = Long.parseLong(stringArray[1]);
        prng = new Random(seed);
        count = 0L;
        for (long i = 0L; i < N; ++i) {
            double d;
            double d2 = prng.nextDouble();
            if (!(d2 * d2 + (d = prng.nextDouble()) * d <= 1.0)) continue;
            ++count;
        }
        System.out.println("pi = 4 * " + count + " / " + N + " = " + 4.0 * (double)count / (double)N);
        System.out.println((l += System.currentTimeMillis()) + " msec");
    }

    private static void usage() {
        System.err.println("Usage: java PiSeq <seed> <N>");
        System.err.println("<seed> = Random seed");
        System.err.println("<N> = Number of random points");
        System.exit(1);
    }
}

